/*     */ package org.jboss.ejb3.tx;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.ejb.TransactionAttribute;
/*     */ import javax.ejb.TransactionAttributeType;
/*     */ import javax.ejb.TransactionManagementType;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodJoinpoint;
/*     */ import org.jboss.aspects.tx.TxInterceptor.Required;
/*     */ import org.jboss.aspects.tx.TxInterceptor.RequiresNew;
/*     */ import org.jboss.ejb3.annotation.TransactionTimeout;
/*     */ import org.jboss.ejb3.stateful.StatefulContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class TxInterceptorFactory extends org.jboss.aspects.tx.TxInterceptorFactory
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(TxInterceptorFactory.class);
/*     */   private static final String TX_TYPE_REQUIRED = "REQUIRED";
/*     */   private static final String TX_TYPE_NOT_SUPPORTED = "NOTSUPPORTED";
/*     */   private static final String TX_TYPE_REQUIRES_NEW = "REQUIRESNEW";
/*     */   private static final String TX_TYPE_NEVER = "NEVER";
/*     */ 
/*     */   protected String resolveTxType(Advisor advisor, Joinpoint jp)
/*     */   {
/*  58 */     Method method = ((MethodJoinpoint)jp).getMethod();
/*  59 */     TransactionAttribute tx = (TransactionAttribute)advisor.resolveAnnotation(method, TransactionAttribute.class);
/*     */ 
/*  61 */     if (tx == null) {
/*  62 */       tx = (TransactionAttribute)advisor.resolveAnnotation(TransactionAttribute.class);
/*     */     }
/*  64 */     String value = "REQUIRED";
/*  65 */     if (tx != null)
/*     */     {
/*  67 */       TransactionAttributeType type = tx.value();
/*     */ 
/*  69 */       if (type == null)
/*     */       {
/*  71 */         value = "REQUIRED";
/*     */       }
/*  73 */       else if (type == TransactionAttributeType.NOT_SUPPORTED)
/*     */       {
/*  75 */         value = "NOTSUPPORTED";
/*     */       }
/*  77 */       else if (type == TransactionAttributeType.REQUIRES_NEW)
/*     */       {
/*  79 */         value = "REQUIRESNEW";
/*     */       }
/*     */       else
/*     */       {
/*  83 */         value = type.name();
/*     */       }
/*     */     }
/*     */ 
/*  87 */     return value;
/*     */   }
/*     */ 
/*     */   protected int resolveTransactionTimeout(Advisor advisor, Method method)
/*     */   {
/*  92 */     TransactionTimeout annotation = (TransactionTimeout)advisor.resolveAnnotation(method, TransactionTimeout.class);
/*     */ 
/*  94 */     if (annotation == null) {
/*  95 */       annotation = (TransactionTimeout)advisor.resolveAnnotation(TransactionTimeout.class);
/*     */     }
/*  97 */     if (annotation != null)
/*     */     {
/*  99 */       return annotation.value();
/*     */     }
/*     */ 
/* 102 */     return -1;
/*     */   }
/*     */ 
/*     */   protected void initializePolicy()
/*     */   {
/* 107 */     this.policy = new Ejb3TxPolicy();
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*     */   {
/* 113 */     TransactionManagementType type = TxUtil.getTransactionManagementType(advisor);
/* 114 */     if (type == TransactionManagementType.BEAN) {
/* 115 */       return new BMTInterceptor(TxUtil.getTransactionManager(), !(advisor instanceof StatefulContainer));
/*     */     }
/* 117 */     Method method = ((MethodJoinpoint)jp).getMethod();
/* 118 */     int timeout = resolveTransactionTimeout(advisor, method);
/*     */ 
/* 120 */     if (this.policy == null);
/* 121 */     super.initialize();
/*     */ 
/* 123 */     String txType = resolveTxType(advisor, jp).toUpperCase();
/* 124 */     if (txType.equals("NEVER"))
/*     */     {
/* 127 */       return new TxInterceptor.Never(TxUtil.getTransactionManager(), this.policy);
/*     */     }
/* 129 */     if (txType.equals("REQUIRED"))
/*     */     {
/* 131 */       return new TxInterceptor.Required(TxUtil.getTransactionManager(), this.policy, timeout);
/*     */     }
/* 133 */     if (txType.equals("REQUIRESNEW"))
/*     */     {
/* 135 */       return new TxInterceptor.RequiresNew(TxUtil.getTransactionManager(), this.policy, timeout);
/*     */     }
/* 137 */     if (txType.equals("NOTSUPPORTED"))
/*     */     {
/* 139 */       return new TxInterceptor.NotSupported(TxUtil.getTransactionManager(), this.policy, timeout);
/*     */     }
/*     */ 
/* 143 */     return super.createPerJoinpoint(advisor, jp);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 149 */     return getClass().getName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.tx.TxInterceptorFactory
 * JD-Core Version:    0.6.0
 */