/*     */ package org.jboss.ejb3.tx;
/*     */ 
/*     */ import javax.ejb.ApplicationException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aspects.tx.TxPolicy;
/*     */ 
/*     */ public class TxInterceptor extends org.jboss.aspects.tx.TxInterceptor
/*     */ {
/*     */   public static class NotSupported extends org.jboss.aspects.tx.TxInterceptor.NotSupported
/*     */   {
/*     */     public NotSupported(TransactionManager tm, TxPolicy policy)
/*     */     {
/*  67 */       super(policy);
/*     */     }
/*     */ 
/*     */     public NotSupported(TransactionManager tm, TxPolicy policy, int timeout)
/*     */     {
/*  72 */       super(policy, timeout);
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation)
/*     */       throws Throwable
/*     */     {
/*  82 */       Transaction tx = this.tm.getTransaction();
/*  83 */       if (tx != null)
/*     */       {
/*  85 */         this.tm.suspend();
/*     */         try
/*     */         {
/*  88 */           localObject1 = this.policy.invokeInNoTx(invocation);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */           Object localObject1;
/*  93 */           if (e.getClass().getAnnotation(ApplicationException.class) != null)
/*     */           {
/*  95 */             throw e;
/*     */           }
/*     */ 
/* 100 */           throw new EJBException(e);
/*     */         }
/*     */         finally
/*     */         {
/* 105 */           this.tm.resume(tx);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 110 */       return this.policy.invokeInNoTx(invocation);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Never extends org.jboss.aspects.tx.TxInterceptor.Never
/*     */   {
/*     */     public Never(TransactionManager tm, TxPolicy policy)
/*     */     {
/*  49 */       super(policy);
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation)
/*     */       throws Throwable
/*     */     {
/*  55 */       if (this.tm.getTransaction() != null)
/*     */       {
/*  57 */         throw new EJBException("Transaction present on server in Never call (EJB3 13.6.2.6)");
/*     */       }
/*  59 */       return this.policy.invokeInNoTx(invocation);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.tx.TxInterceptor
 * JD-Core Version:    0.6.0
 */