/*    */ package org.jboss.ejb3.tx;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import java.rmi.RemoteException;
/*    */ import javax.ejb.ApplicationException;
/*    */ import javax.ejb.EJBException;
/*    */ import javax.ejb.EJBTransactionRequiredException;
/*    */ import javax.ejb.EJBTransactionRolledbackException;
/*    */ import javax.transaction.Transaction;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.aspects.tx.TxPolicy;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class Ejb3TxPolicy extends TxPolicy
/*    */ {
/*    */   public void throwMandatory(Invocation invocation)
/*    */   {
/* 45 */     throw new EJBTransactionRequiredException(((MethodInvocation)invocation).getActualMethod().toString());
/*    */   }
/*    */ 
/*    */   public void handleExceptionInOurTx(Invocation invocation, Throwable t, Transaction tx) throws Throwable
/*    */   {
/* 50 */     ApplicationException ae = TxUtil.getApplicationException(t.getClass(), invocation);
/* 51 */     if (ae != null)
/*    */     {
/* 53 */       if (ae.rollback()) setRollbackOnly(tx);
/* 54 */       throw t;
/*    */     }
/* 56 */     if ((!(t instanceof RuntimeException)) && (!(t instanceof RemoteException)))
/*    */     {
/* 58 */       throw t;
/*    */     }
/* 60 */     setRollbackOnly(tx);
/* 61 */     if (((t instanceof RuntimeException)) && (!(t instanceof EJBException)))
/*    */     {
/* 63 */       throw new EJBException((Exception)t);
/*    */     }
/* 65 */     throw t;
/*    */   }
/*    */ 
/*    */   public void handleInCallerTx(Invocation invocation, Throwable t, Transaction tx) throws Throwable
/*    */   {
/* 70 */     ApplicationException ae = TxUtil.getApplicationException(t.getClass(), invocation);
/*    */ 
/* 72 */     if (ae != null)
/*    */     {
/* 74 */       if (ae.rollback()) setRollbackOnly(tx);
/* 75 */       throw t;
/*    */     }
/* 77 */     if ((!(t instanceof RuntimeException)) && (!(t instanceof RemoteException)))
/*    */     {
/* 79 */       throw t;
/*    */     }
/* 81 */     setRollbackOnly(tx);
/*    */ 
/* 84 */     if ((t instanceof EJBTransactionRolledbackException))
/*    */     {
/* 86 */       log.error(t);
/* 87 */       throw t;
/*    */     }
/*    */ 
/* 91 */     Throwable ejbtre = new EJBTransactionRolledbackException(t.getMessage(), (Exception)t);
/* 92 */     log.error(ejbtre);
/* 93 */     throw ejbtre;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.tx.Ejb3TxPolicy
 * JD-Core Version:    0.6.0
 */