/*     */ package org.jboss.ejb3.timerservice.quartz;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Date;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.NoSuchObjectLocalException;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerHandle;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.Trigger;
/*     */ 
/*     */ public class TimerImpl
/*     */   implements Timer
/*     */ {
/*     */   private static final Logger log;
/*     */   private Scheduler scheduler;
/*     */   private Trigger trigger;
/*     */   private Serializable info;
/*     */ 
/*     */   protected TimerImpl(Scheduler scheduler, Trigger trigger, Serializable info)
/*     */   {
/*  54 */     assert (scheduler != null);
/*  55 */     assert (trigger != null);
/*     */ 
/*  57 */     this.scheduler = scheduler;
/*  58 */     this.trigger = trigger;
/*  59 */     this.info = info;
/*     */   }
/*     */ 
/*     */   protected void checkState()
/*     */   {
/*  66 */     if (this.trigger.getNextFireTime() == null)
/*  67 */       throw new NoSuchObjectLocalException("timer has expired");
/*     */   }
/*     */ 
/*     */   public void cancel()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/*  79 */     checkState();
/*     */     try
/*     */     {
/*  83 */       this.scheduler.unscheduleJob(this.trigger.getName(), this.trigger.getGroup());
/*     */     }
/*     */     catch (SchedulerException e) {
/*  86 */       log.error("cancel failed", e);
/*  87 */       throw new EJBException(e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public long getTimeRemaining()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/* 102 */     return getNextTimeout().getTime() - System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   public Date getNextTimeout()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/* 115 */     checkState();
/*     */ 
/* 117 */     Date nextTimeout = this.trigger.getNextFireTime();
/* 118 */     if (nextTimeout == null)
/* 119 */       throw new IllegalStateException("trigger does not have a next fire time");
/* 120 */     return nextTimeout;
/*     */   }
/*     */ 
/*     */   public Serializable getInfo()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/* 133 */     checkState();
/*     */ 
/* 135 */     return this.info;
/*     */   }
/*     */ 
/*     */   public TimerHandle getHandle()
/*     */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*     */   {
/* 148 */     checkState();
/*     */ 
/* 150 */     return null;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  47 */     log = Logger.getLogger(TimerImpl.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.timerservice.quartz.TimerImpl
 * JD-Core Version:    0.6.0
 */