/*    */ package org.jboss.ejb3.timerservice.quartz;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import javax.ejb.EJBException;
/*    */ import javax.ejb.NoSuchObjectLocalException;
/*    */ import javax.ejb.Timer;
/*    */ import javax.ejb.TimerHandle;
/*    */ import org.jboss.ejb3.Ejb3Registry;
/*    */ import org.jboss.ejb3.timerservice.TimedObjectInvoker;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.quartz.Scheduler;
/*    */ import org.quartz.SchedulerException;
/*    */ import org.quartz.Trigger;
/*    */ 
/*    */ public class PersistentTimer
/*    */   implements Serializable, TimerHandle
/*    */ {
/*    */   private static final Logger log;
/*    */   private static final long serialVersionUID = 1L;
/*    */   private String triggerName;
/*    */   private String triggerGroup;
/*    */   private String containerGuid;
/*    */   private Serializable info;
/*    */ 
/*    */   protected PersistentTimer(Trigger trigger, String containerGuid, Serializable info)
/*    */   {
/* 62 */     assert (trigger != null);
/* 63 */     assert (containerGuid != null);
/*    */ 
/* 65 */     this.triggerName = trigger.getName();
/* 66 */     this.triggerGroup = trigger.getGroup();
/* 67 */     this.info = info;
/* 68 */     this.containerGuid = containerGuid;
/*    */   }
/*    */ 
/*    */   protected TimedObjectInvoker getTimedObjectInvoker()
/*    */   {
/* 74 */     TimedObjectInvoker invoker = (TimedObjectInvoker)Ejb3Registry.getContainer(this.containerGuid);
/* 75 */     assert (invoker != null);
/* 76 */     return invoker;
/*    */   }
/*    */ 
/*    */   public Timer getTimer()
/*    */     throws IllegalStateException, NoSuchObjectLocalException, EJBException
/*    */   {
/*    */     try
/*    */     {
/* 84 */       Scheduler scheduler = QuartzTimerServiceFactory.getScheduler();
/* 85 */       Trigger trigger = scheduler.getTrigger(this.triggerName, this.triggerGroup);
/* 86 */       if (trigger == null)
/* 87 */         throw new NoSuchObjectLocalException("can't find trigger '" + this.triggerName + "' in group '" + this.triggerGroup + "'");
/* 88 */       return new TimerImpl(scheduler, trigger, this.info);
/*    */     }
/*    */     catch (SchedulerException e)
/*    */     {
/* 92 */       log.error("getTimer failed", e);
/* 93 */     }throw new EJBException(e);
/*    */   }
/*    */ 
/*    */   static
/*    */   {
/* 47 */     log = Logger.getLogger(PersistentTimer.class);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.timerservice.quartz.PersistentTimer
 * JD-Core Version:    0.6.0
 */