/*     */ package org.jboss.ejb3.timerservice.jboss;
/*     */ 
/*     */ import javax.ejb.TimerService;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.ejb.txtimer.EJBTimerService;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.timerservice.TimedObjectInvoker;
/*     */ import org.jboss.ejb3.timerservice.TimerServiceFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ 
/*     */ public class JBossTimerServiceFactory extends TimerServiceFactory
/*     */ {
/*  44 */   private static Logger log = Logger.getLogger(JBossTimerServiceFactory.class);
/*     */ 
/*     */   public TimerService createTimerService(Container container, TimedObjectInvoker invoker)
/*     */   {
/*  52 */     TimerService timerService = null;
/*     */     try
/*     */     {
/*  55 */       EJBTimerService service = getEJBTimerService();
/*  56 */       TimerService delegate = service.createTimerService(container.getObjectName(), null, invoker);
/*  57 */       timerService = new TimerServiceFacade(container, delegate);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  62 */       if (log.isTraceEnabled())
/*     */       {
/*  64 */         log.trace("Unable to initialize timer service", e);
/*     */       }
/*     */       else
/*     */       {
/*  68 */         log.trace("Unable to initialize timer service");
/*     */       }
/*     */     }
/*  71 */     return timerService;
/*     */   }
/*     */ 
/*     */   protected EJBTimerService getEJBTimerService()
/*     */   {
/*  76 */     return (EJBTimerService)MBeanProxyExt.create(EJBTimerService.class, EJBTimerService.OBJECT_NAME, MBeanServerLocator.locateJBoss());
/*     */   }
/*     */ 
/*     */   public void removeTimerService(TimerService timerService)
/*     */   {
/*  85 */     removeTimerService(((TimerServiceFacade)timerService).getContainerId());
/*     */   }
/*     */ 
/*     */   protected void removeTimerService(ObjectName containerId)
/*     */   {
/*     */     try
/*     */     {
/*  92 */       EJBTimerService service = getEJBTimerService();
/*  93 */       service.removeTimerService(containerId, true);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  98 */       if (log.isTraceEnabled())
/*     */       {
/* 100 */         log.trace("Unable to initialize timer service", e);
/*     */       }
/*     */       else
/*     */       {
/* 104 */         log.trace("Unable to initialize timer service");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void restoreTimerService(TimerService aTimerService)
/*     */   {
/* 111 */     if (aTimerService == null)
/*     */     {
/* 113 */       log.warn("TIMER SERVICE IS NOT INSTALLED");
/* 114 */       return;
/*     */     }
/* 116 */     TimerServiceFacade timerService = (TimerServiceFacade)aTimerService;
/* 117 */     EJBContainer container = timerService.getContainer();
/*     */ 
/* 119 */     ClassLoader loader = container.getClassloader();
/*     */ 
/* 121 */     getEJBTimerService().restoreTimers(timerService.getContainerId(), loader);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.timerservice.jboss.JBossTimerServiceFactory
 * JD-Core Version:    0.6.0
 */