/*    */ package org.jboss.ejb3.timerservice;
/*    */ 
/*    */ import javax.ejb.EJBException;
/*    */ import javax.ejb.TimerService;
/*    */ import org.jboss.ejb3.Container;
/*    */ 
/*    */ public abstract class TimerServiceFactory
/*    */ {
/*    */   private static TimerServiceFactory instance;
/*    */ 
/*    */   private static synchronized TimerServiceFactory createInstance()
/*    */   {
/* 42 */     if (instance != null) {
/* 43 */       return instance;
/*    */     }
/* 45 */     String factoryClass = "org.jboss.ejb3.timerservice.jboss.JBossTimerServiceFactory";
/* 46 */     factoryClass = System.getProperty("org.jboss.ejb3.timerservice.factory", factoryClass);
/*    */     try
/*    */     {
/* 50 */       Class cls = Class.forName(factoryClass);
/* 51 */       instance = (TimerServiceFactory)cls.newInstance();
/*    */ 
/* 53 */       return instance;
/*    */     }
/*    */     catch (ClassNotFoundException e)
/*    */     {
/* 57 */       throw new EJBException(e);
/*    */     }
/*    */     catch (InstantiationException e)
/*    */     {
/* 61 */       throw new EJBException(e);
/*    */     }
/*    */     catch (IllegalAccessException e) {
/*    */     }
/* 65 */     throw new EJBException(e);
/*    */   }
/*    */ 
/*    */   public abstract TimerService createTimerService(Container paramContainer, TimedObjectInvoker paramTimedObjectInvoker);
/*    */ 
/*    */   public static TimerServiceFactory getInstance()
/*    */   {
/* 73 */     if (instance == null)
/*    */     {
/* 75 */       createInstance();
/*    */     }
/*    */ 
/* 78 */     return instance;
/*    */   }
/*    */ 
/*    */   public abstract void removeTimerService(TimerService paramTimerService);
/*    */ 
/*    */   public abstract void restoreTimerService(TimerService paramTimerService);
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.timerservice.TimerServiceFactory
 * JD-Core Version:    0.6.0
 */