/*     */ package org.jboss.ejb3.statistics;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class InvocationStatistics
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -1637309757441812924L;
/*     */   private Map methodStats;
/*  44 */   public long concurrentCalls = 0L;
/*  45 */   public long maxConcurrentCalls = 0L;
/*  46 */   public long lastResetTime = System.currentTimeMillis();
/*     */ 
/*     */   public InvocationStatistics()
/*     */   {
/*  68 */     this.methodStats = new ConcurrentReaderHashMap();
/*     */   }
/*     */ 
/*     */   public void updateStats(Method m, long elapsed)
/*     */   {
/*  79 */     TimeStatistic stat = (TimeStatistic)this.methodStats.get(m.getName());
/*  80 */     if (stat == null)
/*     */     {
/*  82 */       stat = new TimeStatistic();
/*  83 */       this.methodStats.put(m.getName(), stat);
/*     */     }
/*  85 */     stat.count += 1L;
/*  86 */     stat.totalTime += elapsed;
/*  87 */     if (stat.minTime > elapsed)
/*  88 */       stat.minTime = elapsed;
/*  89 */     if (stat.maxTime < elapsed)
/*  90 */       stat.maxTime = elapsed;
/*     */   }
/*     */ 
/*     */   public synchronized void callIn()
/*     */   {
/*  95 */     this.concurrentCalls += 1L;
/*  96 */     if (this.concurrentCalls > this.maxConcurrentCalls)
/*  97 */       this.maxConcurrentCalls = this.concurrentCalls;
/*     */   }
/*     */ 
/*     */   public synchronized void callOut()
/*     */   {
/* 102 */     this.concurrentCalls -= 1L;
/*     */   }
/*     */ 
/*     */   public void resetStats()
/*     */   {
/* 110 */     synchronized (this.methodStats)
/*     */     {
/* 112 */       Iterator iter = this.methodStats.values().iterator();
/* 113 */       while (iter.hasNext())
/*     */       {
/* 115 */         TimeStatistic stat = (TimeStatistic)iter.next();
/* 116 */         stat.reset();
/*     */       }
/*     */     }
/* 119 */     this.maxConcurrentCalls = 0L;
/* 120 */     this.lastResetTime = System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   public Map getStats()
/*     */   {
/* 129 */     return this.methodStats;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 142 */     StringBuffer tmp = new StringBuffer("<InvocationStatistics concurrentCalls='");
/* 143 */     tmp.append(this.concurrentCalls);
/* 144 */     tmp.append("' >\n");
/*     */ 
/* 146 */     HashMap copy = new HashMap(this.methodStats);
/* 147 */     Iterator iter = copy.entrySet().iterator();
/* 148 */     while (iter.hasNext())
/*     */     {
/* 150 */       Map.Entry entry = (Map.Entry)iter.next();
/* 151 */       TimeStatistic stat = (TimeStatistic)entry.getValue();
/* 152 */       if (stat != null)
/*     */       {
/* 154 */         tmp.append("<method name='");
/* 155 */         tmp.append(entry.getKey());
/* 156 */         tmp.append("' count='");
/* 157 */         tmp.append(stat.count);
/* 158 */         tmp.append("' minTime='");
/* 159 */         tmp.append(stat.minTime);
/* 160 */         tmp.append("' maxTime='");
/* 161 */         tmp.append(stat.maxTime);
/* 162 */         tmp.append("' totalTime='");
/* 163 */         tmp.append(stat.totalTime);
/* 164 */         tmp.append("' />\n");
/*     */       }
/*     */     }
/* 167 */     tmp.append("</InvocationStatistics>");
/* 168 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   public class TimeStatistic
/*     */     implements Serializable
/*     */   {
/*     */     private static final long serialVersionUID = -3717837456831579570L;
/*     */     public volatile long count;
/*  53 */     public volatile long minTime = 9223372036854775807L;
/*     */     public volatile long maxTime;
/*     */     public volatile long totalTime;
/*     */ 
/*     */     public TimeStatistic()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void reset()
/*     */     {
/*  59 */       this.count = 0L;
/*  60 */       this.minTime = 9223372036854775807L;
/*  61 */       this.maxTime = 0L;
/*  62 */       this.totalTime = 0L;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.statistics.InvocationStatistics
 * JD-Core Version:    0.6.0
 */