/*     */ package org.jboss.ejb3.stateless;
/*     */ 
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.ejb.RemoteHome;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.AdviceStack;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class StatelessRemoteProxyFactory extends BaseStatelessProxyFactory
/*     */   implements RemoteProxyFactory
/*     */ {
/*  53 */   private static final Logger log = Logger.getLogger(StatelessRemoteProxyFactory.class);
/*     */   protected RemoteBinding binding;
/*     */   protected InvokerLocator locator;
/*     */ 
/*     */   public StatelessRemoteProxyFactory(SessionContainer container, RemoteBinding binding)
/*     */   {
/*  60 */     super(container, binding.jndiBinding());
/*     */ 
/*  62 */     this.binding = binding;
/*     */   }
/*     */ 
/*     */   protected Class<?>[] getInterfaces()
/*     */   {
/*  67 */     StatelessContainer statelessContainer = (StatelessContainer)getContainer();
/*  68 */     RemoteHome remoteHome = (RemoteHome)statelessContainer.resolveAnnotation(RemoteHome.class);
/*     */ 
/*  70 */     boolean bindTogether = false;
/*     */ 
/*  72 */     if ((remoteHome != null) && (bindHomeAndBusinessTogether(statelessContainer))) {
/*  73 */       bindTogether = true;
/*     */     }
/*     */ 
/*  76 */     Set remoteInterfaces = new HashSet();
/*  77 */     remoteInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(getContainer())));
/*     */ 
/*  80 */     ensureEjb21ViewComplete(remoteHome == null ? null : remoteHome.value(), ProxyFactoryHelper.getRemoteInterfaces(getContainer()));
/*     */ 
/*  84 */     if (remoteInterfaces.size() > 0)
/*     */     {
/*  87 */       remoteInterfaces.add(JBossProxy.class);
/*     */ 
/*  90 */       if (bindTogether)
/*     */       {
/*  92 */         remoteInterfaces.add(remoteHome.value());
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/*  98 */       log.warn("[EJBTHREE-933] NPE when deploying web service beans");
/*     */     }
/*     */ 
/* 102 */     return (Class[])remoteInterfaces.toArray(new Class[0]);
/*     */   }
/*     */ 
/*     */   protected boolean bindHomeAndBusinessTogether(EJBContainer container)
/*     */   {
/* 108 */     return ProxyFactoryHelper.getHomeJndiName(container).equals(ProxyFactoryHelper.getRemoteJndiName(container));
/*     */   }
/*     */ 
/*     */   public void init() throws Exception
/*     */   {
/* 113 */     super.init();
/* 114 */     String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
/* 115 */     this.locator = new InvokerLocator(clientBindUrl);
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 120 */     super.start();
/* 121 */     EJBContainer statelessContainer = (EJBContainer)getContainer();
/* 122 */     RemoteHome remoteHome = (RemoteHome)statelessContainer.resolveAnnotation(RemoteHome.class);
/* 123 */     if ((remoteHome != null) && (!bindHomeAndBusinessTogether(statelessContainer)))
/*     */     {
/* 125 */       Object homeProxy = createHomeProxy(remoteHome.value());
/* 126 */       String jndiName = ProxyFactoryHelper.getHomeJndiName(getContainer());
/*     */       try
/*     */       {
/* 129 */         log.debug("Binding proxy for " + getContainer().getEjbName() + " in JNDI at " + jndiName);
/* 130 */         Util.rebind(getContainer().getInitialContext(), jndiName, homeProxy);
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 134 */         NamingException namingException = new NamingException("Could not bind stateless home proxy with ejb name " + getContainer().getEjbName() + " into JNDI under jndiName: " + getContainer().getInitialContext().getNameInNamespace() + "/" + jndiName);
/* 135 */         namingException.setRootCause(e);
/* 136 */         throw namingException;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 144 */     super.stop();
/* 145 */     EJBContainer statelessContainer = (EJBContainer)getContainer();
/* 146 */     RemoteHome remoteHome = (RemoteHome)statelessContainer.resolveAnnotation(RemoteHome.class);
/* 147 */     if ((remoteHome != null) && (!bindHomeAndBusinessTogether(statelessContainer)))
/*     */     {
/* 149 */       Util.unbind(getContainer().getInitialContext(), ProxyFactoryHelper.getHomeJndiName(getContainer()));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected StatelessHandleImpl getHandle()
/*     */   {
/* 155 */     StatelessHandleImpl handle = new StatelessHandleImpl();
/* 156 */     RemoteBinding remoteBinding = (RemoteBinding)((Advisor)getContainer()).resolveAnnotation(RemoteBinding.class);
/* 157 */     if (remoteBinding != null) {
/* 158 */       handle.jndiName = remoteBinding.jndiBinding();
/*     */     }
/* 160 */     return handle;
/*     */   }
/*     */ 
/*     */   public Object createHomeProxy(Class homeInterface)
/*     */   {
/*     */     try
/*     */     {
/* 167 */       String stackName = "StatelessSessionClientInterceptors";
/* 168 */       if ((this.binding.interceptorStack() != null) && (!this.binding.interceptorStack().equals("")))
/*     */       {
/* 170 */         stackName = this.binding.interceptorStack();
/*     */       }
/* 172 */       AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 173 */       StatelessRemoteProxy proxy = new StatelessRemoteProxy(getContainer(), stack.createInterceptors((Advisor)getContainer(), null), this.locator);
/*     */ 
/* 175 */       setEjb21Objects(proxy);
/* 176 */       Class[] interfaces = { homeInterface };
/* 177 */       return Proxy.newProxyInstance(getContainer().getBeanClass().getClassLoader(), interfaces, proxy);
/*     */     }
/*     */     catch (IllegalArgumentException e) {
/*     */     }
/* 181 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Object createProxy()
/*     */   {
/* 189 */     String stackName = "StatelessSessionClientInterceptors";
/* 190 */     if ((this.binding.interceptorStack() != null) && (!this.binding.interceptorStack().equals("")))
/*     */     {
/* 192 */       stackName = this.binding.interceptorStack();
/*     */     }
/* 194 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 195 */     StatelessRemoteProxy proxy = new StatelessRemoteProxy(getContainer(), stack.createInterceptors((Advisor)getContainer(), null), this.locator);
/*     */ 
/* 197 */     setEjb21Objects(proxy);
/*     */ 
/* 202 */     return constructProxy(proxy);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.StatelessRemoteProxyFactory
 * JD-Core Version:    0.6.0
 */