/*    */ package org.jboss.ejb3.stateless;
/*    */ 
/*    */ import java.rmi.RemoteException;
/*    */ import javax.ejb.EJBException;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.ejb3.BeanContext;
/*    */ import org.jboss.ejb3.EJBContainer;
/*    */ import org.jboss.ejb3.EJBContainerInvocation;
/*    */ import org.jboss.ejb3.pool.Pool;
/*    */ import org.jboss.ejb3.stateful.StatefulInstanceInterceptor;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class StatelessInstanceInterceptor
/*    */   implements Interceptor
/*    */ {
/* 43 */   private static final Logger log = Logger.getLogger(StatelessInstanceInterceptor.class);
/*    */ 
/*    */   public String getName()
/*    */   {
/* 47 */     return "StatelessInstanceInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 52 */     EJBContainerInvocation ejb = (EJBContainerInvocation)invocation;
/* 53 */     EJBContainer container = ejb.getAdvisor();
/* 54 */     Pool pool = container.getPool();
/* 55 */     BeanContext ctx = pool.get();
/* 56 */     ejb.setTargetObject(ctx.getInstance());
/* 57 */     ejb.setBeanContext(ctx);
/* 58 */     container.pushContext(ctx);
/*    */ 
/* 60 */     boolean discard = false;
/*    */     try
/*    */     {
/* 64 */       localObject1 = ejb.invokeNext();
/*    */     }
/*    */     catch (Exception ex)
/*    */     {
/*    */       Object localObject1;
/* 68 */       discard = ((ex instanceof EJBException)) || ((((ex instanceof RuntimeException)) || ((ex instanceof RemoteException))) && (!StatefulInstanceInterceptor.isApplicationException(ex.getClass(), container)));
/*    */ 
/* 70 */       throw ex;
/*    */     }
/*    */     finally
/*    */     {
/* 74 */       container.popContext();
/* 75 */       ejb.setTargetObject(null);
/* 76 */       ejb.setBeanContext(null);
/* 77 */       if (discard) pool.discard(ctx); else
/* 78 */         pool.release(ctx);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.StatelessInstanceInterceptor
 * JD-Core Version:    0.6.0
 */