/*     */ package org.jboss.ejb3.stateless;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.Hashtable;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.naming.NamingContextFactory;
/*     */ 
/*     */ public class StatelessHandleImpl
/*     */   implements Handle
/*     */ {
/*     */   static final long serialVersionUID = 3811452873535097661L;
/*  54 */   private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("jndiName", String.class), new ObjectStreamField("jndiEnv", Hashtable.class) };
/*     */   public String jndiName;
/*     */   private Hashtable jndiEnv;
/*     */ 
/*     */   public StatelessHandleImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public StatelessHandleImpl(String jndiName)
/*     */   {
/*  83 */     this.jndiName = jndiName;
/*  84 */     this.jndiEnv = ((Hashtable)NamingContextFactory.lastInitialContextEnv.get());
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject()
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/*  93 */       InitialContext ic = InitialContextFactory.getInitialContext(this.jndiEnv);
/*     */ 
/*  95 */       Proxy proxy = (Proxy)ic.lookup(this.jndiName);
/*     */ 
/*  97 */       return (EJBObject)proxy;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 101 */       t.printStackTrace();
/* 102 */     }throw new RemoteException("Error during getEJBObject", t);
/*     */   }
/*     */ 
/*     */   public String getJNDIName()
/*     */   {
/* 111 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 117 */     ObjectInputStream.GetField getField = ois.readFields();
/* 118 */     this.jndiName = ((String)getField.get("jndiName", null));
/* 119 */     this.jndiEnv = ((Hashtable)getField.get("jndiEnv", null));
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 125 */     ObjectOutputStream.PutField putField = oos.putFields();
/* 126 */     putField.put("jndiName", this.jndiName);
/* 127 */     putField.put("jndiEnv", this.jndiEnv);
/* 128 */     oos.writeFields();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.StatelessHandleImpl
 * JD-Core Version:    0.6.0
 */