/*     */ package org.jboss.ejb3.stateless;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Hashtable;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aspects.asynch.FutureHolder;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.ejb.AllowedOperationsFlags;
/*     */ import org.jboss.ejb3.BeanContext;
/*     */ import org.jboss.ejb3.EJBContainerInvocation;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.Clustered;
/*     */ import org.jboss.ejb3.annotation.LocalBinding;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.annotation.RemoteBindings;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*     */ import org.jboss.ejb3.interceptor.LifecycleInterceptorHandler;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.ejb3.timerservice.TimedObjectInvoker;
/*     */ import org.jboss.ejb3.timerservice.TimerServiceFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.proxy.ejb.handle.HomeHandleImpl;
/*     */ import org.jboss.proxy.ejb.handle.StatelessHandleImpl;
/*     */ 
/*     */ public class StatelessContainer extends SessionContainer
/*     */   implements TimedObjectInvoker
/*     */ {
/*     */   private static final Logger log;
/*     */   protected TimerService timerService;
/*  75 */   private StatelessDelegateWrapper mbean = new StatelessDelegateWrapper(this);
/*     */ 
/*     */   public StatelessContainer(ClassLoader cl, String beanClassName, String ejbName, AspectManager manager, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment)
/*     */   {
/*  81 */     super(cl, beanClassName, ejbName, manager, ctxProperties, interceptorRepository, deployment);
/*     */   }
/*     */ 
/*     */   public BeanContext<?> createBeanContext()
/*     */   {
/*  87 */     return new StatelessBeanContext(this, construct());
/*     */   }
/*     */ 
/*     */   protected ProxyFactory createProxyFactory(LocalBinding binding)
/*     */   {
/*  93 */     return new StatelessLocalProxyFactory(this, binding);
/*     */   }
/*     */ 
/*     */   protected RemoteProxyFactory createRemoteProxyFactory(RemoteBinding binding)
/*     */   {
/*  99 */     Clustered clustered = (Clustered)getAnnotation(Clustered.class);
/* 100 */     if (clustered != null) {
/* 101 */       return new StatelessClusterProxyFactory(this, binding, clustered);
/*     */     }
/* 103 */     return new StatelessRemoteProxyFactory(this, binding);
/*     */   }
/*     */ 
/*     */   public Object createSession(Class[] initTypes, Object[] initArgs)
/*     */   {
/* 108 */     if (((initTypes != null) && (initTypes.length > 0)) || ((initArgs != null) && (initArgs.length > 0))) {
/* 109 */       throw new IllegalArgumentException("stateless bean create method must take no arguments (EJB3 4.5)");
/*     */     }
/*     */ 
/* 112 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getMBean()
/*     */   {
/* 117 */     return this.mbean;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 124 */       super.start();
/*     */ 
/* 126 */       this.timerService = TimerServiceFactory.getInstance().createTimerService(this, this);
/*     */ 
/* 128 */       TimerServiceFactory.getInstance().restoreTimerService(this.timerService);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       try
/*     */       {
/* 134 */         stop();
/*     */       }
/*     */       catch (Exception ignore)
/*     */       {
/* 138 */         log.debug("Failed to cleanup after start() failure", ignore);
/*     */       }
/* 140 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 146 */     if (this.timerService != null)
/*     */     {
/* 148 */       TimerServiceFactory.getInstance().removeTimerService(this.timerService);
/* 149 */       this.timerService = null;
/*     */     }
/*     */ 
/* 152 */     super.stop();
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService()
/*     */   {
/* 157 */     return this.timerService;
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService(Object pKey)
/*     */   {
/* 162 */     assert (this.timerService != null) : "Timer Service not yet initialized";
/* 163 */     return this.timerService;
/*     */   }
/*     */ 
/*     */   public void callTimeout(Timer timer) throws Exception
/*     */   {
/* 168 */     Method timeout = this.callbackHandler.getTimeoutCallback();
/* 169 */     if (timeout == null) throw new EJBException("No method has been annotated with @Timeout");
/* 170 */     Object[] args = { timer };
/* 171 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 174 */       AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */       try
/*     */       {
/* 177 */         MethodInfo info = (MethodInfo)this.methodInterceptors.get(this.callbackHandler.getTimeoutCalllbackHash());
/* 178 */         EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info);
/* 179 */         nextInvocation.setAdvisor(this);
/* 180 */         nextInvocation.setArguments(args);
/* 181 */         nextInvocation.invokeNext();
/*     */       }
/*     */       catch (Throwable throwable)
/*     */       {
/* 185 */         if ((throwable instanceof Exception)) throw ((Exception)throwable);
/* 186 */         throw new RuntimeException(throwable);
/*     */       }
/*     */       finally
/*     */       {
/* 190 */         AllowedOperationsAssociation.popInMethodFlag();
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 195 */       Thread.currentThread().setContextClassLoader(oldLoader);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object localInvoke(Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 204 */     return localInvoke(method, args, null);
/*     */   }
/*     */ 
/*     */   public Object localInvoke(Method method, Object[] args, FutureHolder provider)
/*     */     throws Throwable
/*     */   {
/* 214 */     return localInvoke(method, args, provider, null);
/*     */   }
/*     */ 
/*     */   public Object localInvoke(Object id, Method method, Object[] args, FutureHolder provider) throws Throwable
/*     */   {
/* 219 */     return localInvoke(method, args, provider); } 
/*     */   // ERROR //
/*     */   public Object localInvoke(Method method, Object[] args, FutureHolder provider, org.jboss.ejb3.BeanContextLifecycleCallback<StatelessBeanContext> callback) throws Throwable { // Byte code:
/*     */     //   0: invokestatic 61	java/lang/System:currentTimeMillis	()J
/*     */     //   3: lstore 5
/*     */     //   5: invokestatic 41	java/lang/Thread:currentThread	()Ljava/lang/Thread;
/*     */     //   8: invokevirtual 42	java/lang/Thread:getContextClassLoader	()Ljava/lang/ClassLoader;
/*     */     //   11: astore 7
/*     */     //   13: aload_0
/*     */     //   14: aload_1
/*     */     //   15: invokevirtual 62	org/jboss/ejb3/stateless/StatelessContainer:getMethodInfo	(Ljava/lang/reflect/Method;)Lorg/jboss/aop/MethodInfo;
/*     */     //   18: astore 8
/*     */     //   20: aload 8
/*     */     //   22: invokevirtual 63	org/jboss/aop/MethodInfo:getUnadvisedMethod	()Ljava/lang/reflect/Method;
/*     */     //   25: astore 9
/*     */     //   27: aload_0
/*     */     //   28: getfield 64	org/jboss/ejb3/stateless/StatelessContainer:invokeStats	Lorg/jboss/ejb3/statistics/InvocationStatistics;
/*     */     //   31: invokevirtual 65	org/jboss/ejb3/statistics/InvocationStatistics:callIn	()V
/*     */     //   34: aload_0
/*     */     //   35: getfield 66	org/jboss/ejb3/stateless/StatelessContainer:invokedMethod	Lorg/jboss/ejb3/ThreadLocalStack;
/*     */     //   38: new 67	org/jboss/ejb3/session/SessionContainer$InvokedMethod
/*     */     //   41: dup
/*     */     //   42: aload_0
/*     */     //   43: iconst_1
/*     */     //   44: aload 9
/*     */     //   46: invokespecial 68	org/jboss/ejb3/session/SessionContainer$InvokedMethod:<init>	(Lorg/jboss/ejb3/session/SessionContainer;ZLjava/lang/reflect/Method;)V
/*     */     //   49: invokevirtual 69	org/jboss/ejb3/ThreadLocalStack:push	(Ljava/lang/Object;)V
/*     */     //   52: aload 9
/*     */     //   54: ifnull +30 -> 84
/*     */     //   57: aload_0
/*     */     //   58: aload 9
/*     */     //   60: invokevirtual 70	org/jboss/ejb3/stateless/StatelessContainer:isHomeMethod	(Ljava/lang/reflect/Method;)Z
/*     */     //   63: ifeq +21 -> 84
/*     */     //   66: aload_0
/*     */     //   67: aload 9
/*     */     //   69: aload_2
/*     */     //   70: invokevirtual 71	org/jboss/ejb3/stateless/StatelessContainer:localHomeInvoke	(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;
/*     */     //   73: astore 10
/*     */     //   75: jsr +69 -> 144
/*     */     //   78: jsr +121 -> 199
/*     */     //   81: aload 10
/*     */     //   83: areturn
/*     */     //   84: new 49	org/jboss/ejb3/EJBContainerInvocation
/*     */     //   87: dup
/*     */     //   88: aload 8
/*     */     //   90: invokespecial 50	org/jboss/ejb3/EJBContainerInvocation:<init>	(Lorg/jboss/aop/MethodInfo;)V
/*     */     //   93: astore 10
/*     */     //   95: aload 10
/*     */     //   97: aload_0
/*     */     //   98: invokevirtual 51	org/jboss/ejb3/EJBContainerInvocation:setAdvisor	(Lorg/jboss/aop/Advisor;)V
/*     */     //   101: aload 10
/*     */     //   103: aload_2
/*     */     //   104: invokevirtual 52	org/jboss/ejb3/EJBContainerInvocation:setArguments	([Ljava/lang/Object;)V
/*     */     //   107: aload 10
/*     */     //   109: aload 4
/*     */     //   111: invokevirtual 72	org/jboss/ejb3/EJBContainerInvocation:setContextCallback	(Lorg/jboss/ejb3/BeanContextLifecycleCallback;)V
/*     */     //   114: aload 10
/*     */     //   116: aload_3
/*     */     //   117: invokestatic 73	org/jboss/ejb3/ProxyUtils:addLocalAsynchronousInfo	(Lorg/jboss/aop/joinpoint/MethodInvocation;Lorg/jboss/aspects/asynch/FutureHolder;)V
/*     */     //   120: aload 10
/*     */     //   122: invokevirtual 53	org/jboss/ejb3/EJBContainerInvocation:invokeNext	()Ljava/lang/Object;
/*     */     //   125: astore 11
/*     */     //   127: jsr +17 -> 144
/*     */     //   130: jsr +69 -> 199
/*     */     //   133: aload 11
/*     */     //   135: areturn
/*     */     //   136: astore 12
/*     */     //   138: jsr +6 -> 144
/*     */     //   141: aload 12
/*     */     //   143: athrow
/*     */     //   144: astore 13
/*     */     //   146: aload 9
/*     */     //   148: ifnull +26 -> 174
/*     */     //   151: invokestatic 61	java/lang/System:currentTimeMillis	()J
/*     */     //   154: lstore 14
/*     */     //   156: lload 14
/*     */     //   158: lload 5
/*     */     //   160: lsub
/*     */     //   161: lstore 16
/*     */     //   163: aload_0
/*     */     //   164: getfield 64	org/jboss/ejb3/stateless/StatelessContainer:invokeStats	Lorg/jboss/ejb3/statistics/InvocationStatistics;
/*     */     //   167: aload 9
/*     */     //   169: lload 16
/*     */     //   171: invokevirtual 74	org/jboss/ejb3/statistics/InvocationStatistics:updateStats	(Ljava/lang/reflect/Method;J)V
/*     */     //   174: aload_0
/*     */     //   175: getfield 64	org/jboss/ejb3/stateless/StatelessContainer:invokeStats	Lorg/jboss/ejb3/statistics/InvocationStatistics;
/*     */     //   178: invokevirtual 75	org/jboss/ejb3/statistics/InvocationStatistics:callOut	()V
/*     */     //   181: aload_0
/*     */     //   182: getfield 66	org/jboss/ejb3/stateless/StatelessContainer:invokedMethod	Lorg/jboss/ejb3/ThreadLocalStack;
/*     */     //   185: invokevirtual 76	org/jboss/ejb3/ThreadLocalStack:pop	()Ljava/lang/Object;
/*     */     //   188: pop
/*     */     //   189: ret 13
/*     */     //   191: astore 18
/*     */     //   193: jsr +6 -> 199
/*     */     //   196: aload 18
/*     */     //   198: athrow
/*     */     //   199: astore 19
/*     */     //   201: invokestatic 41	java/lang/Thread:currentThread	()Ljava/lang/Thread;
/*     */     //   204: aload 7
/*     */     //   206: invokevirtual 58	java/lang/Thread:setContextClassLoader	(Ljava/lang/ClassLoader;)V
/*     */     //   209: ret 19
/*     */     //
/*     */     // Exception table:
/*     */     //   from	to	target	type
/*     */     //   27	78	136	finally
/*     */     //   84	130	136	finally
/*     */     //   136	141	136	finally
/*     */     //   13	81	191	finally
/*     */     //   84	133	191	finally
/*     */     //   136	196	191	finally } 
/*     */   // ERROR //
/*     */   public org.jboss.aop.joinpoint.InvocationResponse dynamicInvoke(Object target, org.jboss.aop.joinpoint.Invocation invocation) throws Throwable { // Byte code:
/*     */     //   0: invokestatic 61	java/lang/System:currentTimeMillis	()J
/*     */     //   3: lstore_3
/*     */     //   4: invokestatic 41	java/lang/Thread:currentThread	()Ljava/lang/Thread;
/*     */     //   7: invokevirtual 42	java/lang/Thread:getContextClassLoader	()Ljava/lang/ClassLoader;
/*     */     //   10: astore 5
/*     */     //   12: invokestatic 41	java/lang/Thread:currentThread	()Ljava/lang/Thread;
/*     */     //   15: aload_0
/*     */     //   16: getfield 77	org/jboss/ejb3/stateless/StatelessContainer:classloader	Ljava/lang/ClassLoader;
/*     */     //   19: invokevirtual 58	java/lang/Thread:setContextClassLoader	(Ljava/lang/ClassLoader;)V
/*     */     //   22: aload_2
/*     */     //   23: checkcast 78	org/jboss/aop/joinpoint/MethodInvocation
/*     */     //   26: astore 6
/*     */     //   28: aload_0
/*     */     //   29: getfield 45	org/jboss/ejb3/stateless/StatelessContainer:methodInterceptors	Lgnu/trove/TLongObjectHashMap;
/*     */     //   32: aload 6
/*     */     //   34: invokevirtual 79	org/jboss/aop/joinpoint/MethodInvocation:getMethodHash	()J
/*     */     //   37: invokevirtual 47	gnu/trove/TLongObjectHashMap:get	(J)Ljava/lang/Object;
/*     */     //   40: checkcast 48	org/jboss/aop/MethodInfo
/*     */     //   43: astore 7
/*     */     //   45: aload 7
/*     */     //   47: ifnonnull +13 -> 60
/*     */     //   50: new 55	java/lang/RuntimeException
/*     */     //   53: dup
/*     */     //   54: ldc 80
/*     */     //   56: invokespecial 81	java/lang/RuntimeException:<init>	(Ljava/lang/String;)V
/*     */     //   59: athrow
/*     */     //   60: aload 7
/*     */     //   62: invokevirtual 63	org/jboss/aop/MethodInfo:getUnadvisedMethod	()Ljava/lang/reflect/Method;
/*     */     //   65: astore 8
/*     */     //   67: aload_0
/*     */     //   68: getfield 64	org/jboss/ejb3/stateless/StatelessContainer:invokeStats	Lorg/jboss/ejb3/statistics/InvocationStatistics;
/*     */     //   71: invokevirtual 65	org/jboss/ejb3/statistics/InvocationStatistics:callIn	()V
/*     */     //   74: aload_0
/*     */     //   75: getfield 66	org/jboss/ejb3/stateless/StatelessContainer:invokedMethod	Lorg/jboss/ejb3/ThreadLocalStack;
/*     */     //   78: new 67	org/jboss/ejb3/session/SessionContainer$InvokedMethod
/*     */     //   81: dup
/*     */     //   82: aload_0
/*     */     //   83: iconst_0
/*     */     //   84: aload 8
/*     */     //   86: invokespecial 68	org/jboss/ejb3/session/SessionContainer$InvokedMethod:<init>	(Lorg/jboss/ejb3/session/SessionContainer;ZLjava/lang/reflect/Method;)V
/*     */     //   89: invokevirtual 69	org/jboss/ejb3/ThreadLocalStack:push	(Ljava/lang/Object;)V
/*     */     //   92: aconst_null
/*     */     //   93: astore 9
/*     */     //   95: aconst_null
/*     */     //   96: astore 10
/*     */     //   98: aload 8
/*     */     //   100: ifnull +25 -> 125
/*     */     //   103: aload_0
/*     */     //   104: aload 8
/*     */     //   106: invokevirtual 70	org/jboss/ejb3/stateless/StatelessContainer:isHomeMethod	(Ljava/lang/reflect/Method;)Z
/*     */     //   109: ifeq +16 -> 125
/*     */     //   112: aload_0
/*     */     //   113: aload 7
/*     */     //   115: aload 6
/*     */     //   117: invokevirtual 82	org/jboss/ejb3/stateless/StatelessContainer:invokeHomeMethod	(Lorg/jboss/aop/MethodInfo;Lorg/jboss/aop/joinpoint/MethodInvocation;)Ljava/lang/Object;
/*     */     //   120: astore 10
/*     */     //   122: goto +120 -> 242
/*     */     //   125: aload 7
/*     */     //   127: ifnull +30 -> 157
/*     */     //   130: aload 8
/*     */     //   132: ifnull +25 -> 157
/*     */     //   135: aload_0
/*     */     //   136: aload 8
/*     */     //   138: invokevirtual 83	org/jboss/ejb3/stateless/StatelessContainer:isEJBObjectMethod	(Ljava/lang/reflect/Method;)Z
/*     */     //   141: ifeq +16 -> 157
/*     */     //   144: aload_0
/*     */     //   145: aload 7
/*     */     //   147: aload 6
/*     */     //   149: invokevirtual 84	org/jboss/ejb3/stateless/StatelessContainer:invokeEJBObjectMethod	(Lorg/jboss/aop/MethodInfo;Lorg/jboss/aop/joinpoint/MethodInvocation;)Ljava/lang/Object;
/*     */     //   152: astore 10
/*     */     //   154: goto +88 -> 242
/*     */     //   157: aconst_null
/*     */     //   158: astore 11
/*     */     //   160: new 49	org/jboss/ejb3/EJBContainerInvocation
/*     */     //   163: dup
/*     */     //   164: aload 7
/*     */     //   166: invokespecial 50	org/jboss/ejb3/EJBContainerInvocation:<init>	(Lorg/jboss/aop/MethodInfo;)V
/*     */     //   169: astore 11
/*     */     //   171: aload 11
/*     */     //   173: aload 6
/*     */     //   175: invokevirtual 85	org/jboss/aop/joinpoint/MethodInvocation:getArguments	()[Ljava/lang/Object;
/*     */     //   178: invokevirtual 52	org/jboss/ejb3/EJBContainerInvocation:setArguments	([Ljava/lang/Object;)V
/*     */     //   181: aload 11
/*     */     //   183: aload 6
/*     */     //   185: invokevirtual 86	org/jboss/aop/joinpoint/MethodInvocation:getMetaData	()Lorg/jboss/aop/metadata/SimpleMetaData;
/*     */     //   188: invokevirtual 87	org/jboss/ejb3/EJBContainerInvocation:setMetaData	(Lorg/jboss/aop/metadata/SimpleMetaData;)V
/*     */     //   191: aload 11
/*     */     //   193: aload_0
/*     */     //   194: invokevirtual 51	org/jboss/ejb3/EJBContainerInvocation:setAdvisor	(Lorg/jboss/aop/Advisor;)V
/*     */     //   197: aload 11
/*     */     //   199: invokevirtual 53	org/jboss/ejb3/EJBContainerInvocation:invokeNext	()Ljava/lang/Object;
/*     */     //   202: astore 10
/*     */     //   204: aload 11
/*     */     //   206: invokevirtual 88	org/jboss/ejb3/EJBContainerInvocation:getResponseContextInfo	()Ljava/util/Map;
/*     */     //   209: astore 9
/*     */     //   211: goto +31 -> 242
/*     */     //   214: astore 12
/*     */     //   216: aload 11
/*     */     //   218: invokevirtual 88	org/jboss/ejb3/EJBContainerInvocation:getResponseContextInfo	()Ljava/util/Map;
/*     */     //   221: astore 9
/*     */     //   223: aload_2
/*     */     //   224: aload 12
/*     */     //   226: aload 9
/*     */     //   228: invokestatic 89	org/jboss/ejb3/stateless/StatelessContainer:marshallException	(Lorg/jboss/aop/joinpoint/Invocation;Ljava/lang/Throwable;Ljava/util/Map;)Lorg/jboss/aop/joinpoint/InvocationResponse;
/*     */     //   231: astore 13
/*     */     //   233: jsr +40 -> 273
/*     */     //   236: jsr +91 -> 327
/*     */     //   239: aload 13
/*     */     //   241: areturn
/*     */     //   242: aload_2
/*     */     //   243: aload 10
/*     */     //   245: aload 9
/*     */     //   247: invokestatic 90	org/jboss/ejb3/stateless/StatelessContainer:marshallResponse	(Lorg/jboss/aop/joinpoint/Invocation;Ljava/lang/Object;Ljava/util/Map;)Lorg/jboss/aop/joinpoint/InvocationResponse;
/*     */     //   250: astore 11
/*     */     //   252: aload 11
/*     */     //   254: astore 12
/*     */     //   256: jsr +17 -> 273
/*     */     //   259: jsr +68 -> 327
/*     */     //   262: aload 12
/*     */     //   264: areturn
/*     */     //   265: astore 14
/*     */     //   267: jsr +6 -> 273
/*     */     //   270: aload 14
/*     */     //   272: athrow
/*     */     //   273: astore 15
/*     */     //   275: aload 8
/*     */     //   277: ifnull +25 -> 302
/*     */     //   280: invokestatic 61	java/lang/System:currentTimeMillis	()J
/*     */     //   283: lstore 16
/*     */     //   285: lload 16
/*     */     //   287: lload_3
/*     */     //   288: lsub
/*     */     //   289: lstore 18
/*     */     //   291: aload_0
/*     */     //   292: getfield 64	org/jboss/ejb3/stateless/StatelessContainer:invokeStats	Lorg/jboss/ejb3/statistics/InvocationStatistics;
/*     */     //   295: aload 8
/*     */     //   297: lload 18
/*     */     //   299: invokevirtual 74	org/jboss/ejb3/statistics/InvocationStatistics:updateStats	(Ljava/lang/reflect/Method;J)V
/*     */     //   302: aload_0
/*     */     //   303: getfield 64	org/jboss/ejb3/stateless/StatelessContainer:invokeStats	Lorg/jboss/ejb3/statistics/InvocationStatistics;
/*     */     //   306: invokevirtual 75	org/jboss/ejb3/statistics/InvocationStatistics:callOut	()V
/*     */     //   309: aload_0
/*     */     //   310: getfield 66	org/jboss/ejb3/stateless/StatelessContainer:invokedMethod	Lorg/jboss/ejb3/ThreadLocalStack;
/*     */     //   313: invokevirtual 76	org/jboss/ejb3/ThreadLocalStack:pop	()Ljava/lang/Object;
/*     */     //   316: pop
/*     */     //   317: ret 15
/*     */     //   319: astore 20
/*     */     //   321: jsr +6 -> 327
/*     */     //   324: aload 20
/*     */     //   326: athrow
/*     */     //   327: astore 21
/*     */     //   329: invokestatic 41	java/lang/Thread:currentThread	()Ljava/lang/Thread;
/*     */     //   332: aload 5
/*     */     //   334: invokevirtual 58	java/lang/Thread:setContextClassLoader	(Ljava/lang/ClassLoader;)V
/*     */     //   337: ret 21
/*     */     //
/*     */     // Exception table:
/*     */     //   from	to	target	type
/*     */     //   197	211	214	java/lang/Throwable
/*     */     //   67	236	265	finally
/*     */     //   242	259	265	finally
/*     */     //   265	270	265	finally
/*     */     //   12	239	319	finally
/*     */     //   242	262	319	finally
/*     */     //   265	324	319	finally } 
/* 350 */   protected Object invokeEJBObjectMethod(MethodInfo info, MethodInvocation invocation) throws Throwable { Method unadvisedMethod = info.getUnadvisedMethod();
/* 351 */     if (unadvisedMethod.getName().equals("getHandle"))
/*     */     {
/* 353 */       StatelessHandleImpl handle = null;
/* 354 */       RemoteBinding remoteBindingAnnotation = (RemoteBinding)resolveAnnotation(RemoteBinding.class);
/* 355 */       if (remoteBindingAnnotation != null) {
/* 356 */         handle = new StatelessHandleImpl(remoteBindingAnnotation.jndiBinding());
/*     */       }
/* 358 */       return handle;
/*     */     }
/* 360 */     if (unadvisedMethod.getName().equals("remove"))
/*     */     {
/* 362 */       return null;
/*     */     }
/* 364 */     if (unadvisedMethod.getName().equals("getEJBHome"))
/*     */     {
/* 366 */       HomeHandleImpl homeHandle = null;
/*     */ 
/* 368 */       RemoteBinding remoteBindingAnnotation = (RemoteBinding)resolveAnnotation(RemoteBinding.class);
/* 369 */       if (remoteBindingAnnotation != null) {
/* 370 */         homeHandle = new HomeHandleImpl(ProxyFactoryHelper.getHomeJndiName(this));
/*     */       }
/* 372 */       return homeHandle.getEJBHome();
/*     */     }
/* 374 */     if (unadvisedMethod.getName().equals("getPrimaryKey"))
/*     */     {
/* 376 */       return null;
/*     */     }
/* 378 */     if (unadvisedMethod.getName().equals("isIdentical"))
/*     */     {
/* 380 */       return Boolean.valueOf(false);
/*     */     }
/*     */ 
/* 384 */     return null;
/*     */   }
/*     */ 
/*     */   public Object localHomeInvoke(Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 390 */     if (method.getName().equals("create"))
/*     */     {
/* 392 */       LocalBinding binding = (LocalBinding)resolveAnnotation(LocalBinding.class);
/*     */ 
/* 396 */       StatelessLocalProxyFactory factory = new StatelessLocalProxyFactory(this, binding);
/* 397 */       factory.init();
/*     */ 
/* 399 */       Object proxy = factory.createProxy();
/*     */ 
/* 401 */       return proxy;
/*     */     }
/*     */ 
/* 405 */     return null;
/*     */   }
/*     */ 
/*     */   public Object createLocalProxy(Object id, LocalBinding binding)
/*     */     throws Exception
/*     */   {
/* 411 */     StatelessLocalProxyFactory factory = new StatelessLocalProxyFactory(this, binding);
/* 412 */     factory.init();
/*     */ 
/* 414 */     Object proxy = factory.createProxy();
/*     */ 
/* 416 */     return proxy;
/*     */   }
/*     */ 
/*     */   public Object createRemoteProxy(Object id, RemoteBinding binding)
/*     */     throws Exception
/*     */   {
/* 429 */     StatelessRemoteProxyFactory factory = new StatelessRemoteProxyFactory(this, binding);
/* 430 */     factory.init();
/*     */ 
/* 432 */     return factory.createProxy();
/*     */   }
/*     */ 
/*     */   protected Object invokeHomeMethod(MethodInfo info, MethodInvocation invocation) throws Throwable
/*     */   {
/* 437 */     Method unadvisedMethod = info.getUnadvisedMethod();
/* 438 */     if (unadvisedMethod.getName().equals("create"))
/*     */     {
/* 440 */       RemoteBinding binding = null;
/*     */ 
/* 442 */       RemoteBindings bindings = (RemoteBindings)resolveAnnotation(RemoteBindings.class);
/* 443 */       if (bindings != null)
/* 444 */         binding = bindings.value()[0];
/*     */       else {
/* 446 */         binding = (RemoteBinding)resolveAnnotation(RemoteBinding.class);
/*     */       }
/*     */ 
/* 450 */       StatelessRemoteProxyFactory factory = new StatelessRemoteProxyFactory(this, binding);
/* 451 */       factory.init();
/*     */ 
/* 453 */       return factory.createProxy();
/*     */     }
/*     */ 
/* 457 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getBusinessObject(BeanContext ctx, Class intf)
/*     */   {
/* 464 */     assert (intf != null) : "intf is null";
/*     */     try
/*     */     {
/* 468 */       String jndiName = ProxyFactoryHelper.getJndiName(this, intf);
/* 469 */       if (jndiName == null) throw new IllegalStateException("Cannot find BusinessObject for interface: " + intf.getName());
/* 470 */       return getInitialContext().lookup(ProxyFactoryHelper.getJndiName(this, intf));
/*     */     }
/*     */     catch (NamingException e) {
/*     */     }
/* 474 */     throw new RuntimeException("failed to invoke getBusinessObject", e);
/*     */   }
/*     */ 
/*     */   protected void removeHandle(Handle handle)
/*     */   {
/* 480 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  72 */     log = Logger.getLogger(StatelessContainer.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.StatelessContainer
 * JD-Core Version:    0.6.0
 */