/*     */ package org.jboss.ejb3.stateless;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import javassist.util.proxy.MethodHandler;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.session.BaseSessionProxyFactory;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.Util;
/*     */ 
/*     */ public abstract class BaseStatelessProxyFactory extends BaseSessionProxyFactory
/*     */   implements ProxyFactory
/*     */ {
/*     */   private static final Logger log;
/*     */   protected String jndiName;
/*     */   private Constructor proxyConstructor;
/*     */ 
/*     */   public BaseStatelessProxyFactory(SessionContainer container, String jndiName)
/*     */   {
/*  62 */     super(container);
/*     */ 
/*  64 */     assert (jndiName != null) : "jndiName is null";
/*     */ 
/*  66 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   protected Object constructProxy(InvocationHandler handler)
/*     */   {
/*     */     try
/*     */     {
/* 131 */       Object[] args = { handler };
/* 132 */       Object proxy = this.proxyConstructor.newInstance(args);
/*     */ 
/* 150 */       return proxy;
/*     */     }
/*     */     catch (IllegalArgumentException e)
/*     */     {
/* 154 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/* 158 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 162 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 166 */     throw new RuntimeException(e.getTargetException());
/*     */   }
/*     */ 
/*     */   public final Object createProxy(Object id)
/*     */   {
/* 172 */     assert (id == null) : "stateless bean must not have an id";
/* 173 */     return createProxy();
/*     */   }
/*     */ 
/*     */   public void init() throws Exception
/*     */   {
/* 178 */     initializeJndiName();
/* 179 */     Class[] interfaces = getInterfaces();
/*     */ 
/* 184 */     Class proxyClass = Proxy.getProxyClass(getContainer().getBeanClass().getClassLoader(), interfaces);
/* 185 */     Class[] constructorParams = { InvocationHandler.class };
/*     */ 
/* 187 */     this.proxyConstructor = proxyClass.getConstructor(constructorParams);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 230 */     init();
/*     */ 
/* 232 */     Object proxy = createProxy();
/*     */ 
/* 234 */     bindProxy(proxy);
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 239 */     Util.unbind(getContainer().getInitialContext(), this.jndiName);
/*     */   }
/*     */ 
/*     */   protected abstract Class<?>[] getInterfaces();
/*     */ 
/*     */   protected final void initializeJndiName() {
/*     */   }
/*     */ 
/*     */   protected void bindProxy(Object proxy) throws NamingException {
/*     */     try {
/* 250 */       log.debug("Binding proxy for " + getContainer().getEjbName() + " in JNDI at " + this.jndiName);
/* 251 */       Util.rebind(getContainer().getInitialContext(), this.jndiName, proxy);
/*     */     }
/*     */     catch (NamingException e) {
/* 254 */       NamingException namingException = new NamingException("Could not bind stateless proxy with ejb name " + getContainer().getEjbName() + " into JNDI under jndiName: " + getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName);
/* 255 */       namingException.setRootCause(e);
/* 256 */       throw namingException;
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  52 */     log = Logger.getLogger(BaseStatelessProxyFactory.class);
/*     */   }
/*     */ 
/*     */   private static class MethodHandlerAdapter
/*     */     implements MethodHandler, Serializable
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */     private InvocationHandler delegate;
/*     */ 
/*     */     private MethodHandlerAdapter(InvocationHandler delegate)
/*     */     {
/* 109 */       if (delegate == null)
/* 110 */         throw new IllegalArgumentException("delegate must not be null");
/* 111 */       this.delegate = delegate;
/*     */     }
/*     */ 
/*     */     public Object invoke(Object self, Method thisMethod, Method process, Object[] args) throws Throwable
/*     */     {
/* 116 */       return this.delegate.invoke(self, thisMethod, args);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.BaseStatelessProxyFactory
 * JD-Core Version:    0.6.0
 */