/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ import java.security.Identity;
/*     */ import java.security.Principal;
/*     */ import java.util.Properties;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.SessionContext;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.transaction.UserTransaction;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import org.jboss.ejb3.Ejb3Registry;
/*     */ import org.jboss.ejb3.cache.StatefulCache;
/*     */ import org.jboss.ejb3.session.SessionBeanContext;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.ejb3.session.SessionContextImpl;
/*     */ 
/*     */ public class StatefulSessionContextImpl
/*     */   implements Serializable, SessionContext
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String containerGuid;
/*     */   private String containerClusterUid;
/*     */   private Object id;
/*     */   private boolean isClustered;
/*     */   private transient SessionContext delegate;
/*     */ 
/*     */   public StatefulSessionContextImpl(String containerGuid, String containerClusterUid, Object id, boolean isClustered)
/*     */   {
/*  89 */     assert (containerGuid != null) : "containerGuid is null";
/*  90 */     assert (containerClusterUid != null) : "containerClusterUid is null";
/*     */ 
/*  92 */     this.containerGuid = containerGuid;
/*  93 */     this.containerClusterUid = containerClusterUid;
/*  94 */     this.id = id;
/*  95 */     this.isClustered = isClustered;
/*     */   }
/*     */ 
/*     */   public StatefulSessionContextImpl(SessionBeanContext beanContext)
/*     */   {
/* 100 */     assert (beanContext != null) : "beanContext is null";
/*     */ 
/* 102 */     this.delegate = new SessionContextImpl(beanContext);
/* 103 */     this.containerGuid = Ejb3Registry.guid(beanContext.getContainer());
/* 104 */     this.containerClusterUid = Ejb3Registry.clusterUid(beanContext.getContainer());
/* 105 */     this.id = beanContext.getId();
/* 106 */     this.isClustered = ((SessionContainer)beanContext.getContainer()).isClustered();
/*     */   }
/*     */ 
/*     */   private Object writeReplace() throws ObjectStreamException
/*     */   {
/* 111 */     Serialized s = new Serialized(null);
/* 112 */     Serialized.access$102(s, this.containerGuid);
/* 113 */     Serialized.access$202(s, this.containerClusterUid);
/* 114 */     Serialized.access$302(s, this.id);
/* 115 */     Serialized.access$402(s, this.isClustered);
/* 116 */     return s;
/*     */   }
/*     */ 
/*     */   public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException
/*     */   {
/* 121 */     return getDelegate().getBusinessObject(businessInterface);
/*     */   }
/*     */ 
/*     */   protected SessionContext getDelegate()
/*     */   {
/* 126 */     if (this.delegate == null)
/*     */     {
/* 128 */       StatefulContainer container = (StatefulContainer)Ejb3Registry.getContainer(this.containerGuid);
/* 129 */       if ((container == null) && (this.isClustered)) {
/* 130 */         container = (StatefulContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
/*     */       }
/* 132 */       this.delegate = new SessionContextImpl(container.getCache().get(this.id, false));
/*     */     }
/* 134 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public EJBLocalObject getEJBLocalObject() throws IllegalStateException
/*     */   {
/* 139 */     return getDelegate().getEJBLocalObject();
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject() throws IllegalStateException
/*     */   {
/* 144 */     return getDelegate().getEJBObject();
/*     */   }
/*     */ 
/*     */   public Class<?> getInvokedBusinessInterface() throws IllegalStateException
/*     */   {
/* 149 */     return getDelegate().getInvokedBusinessInterface();
/*     */   }
/*     */ 
/*     */   public MessageContext getMessageContext() throws IllegalStateException
/*     */   {
/* 154 */     return getDelegate().getMessageContext();
/*     */   }
/*     */ 
/*     */   public Identity getCallerIdentity()
/*     */   {
/* 160 */     return getDelegate().getCallerIdentity();
/*     */   }
/*     */ 
/*     */   public Principal getCallerPrincipal()
/*     */   {
/* 165 */     return getDelegate().getCallerPrincipal();
/*     */   }
/*     */ 
/*     */   public EJBHome getEJBHome()
/*     */   {
/* 170 */     return getDelegate().getEJBHome();
/*     */   }
/*     */ 
/*     */   public EJBLocalHome getEJBLocalHome()
/*     */   {
/* 175 */     return getDelegate().getEJBLocalHome();
/*     */   }
/*     */ 
/*     */   public Properties getEnvironment()
/*     */   {
/* 180 */     return getDelegate().getEnvironment();
/*     */   }
/*     */ 
/*     */   public boolean getRollbackOnly() throws IllegalStateException
/*     */   {
/* 185 */     return getDelegate().getRollbackOnly();
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService() throws IllegalStateException
/*     */   {
/* 190 */     return getDelegate().getTimerService();
/*     */   }
/*     */ 
/*     */   public UserTransaction getUserTransaction() throws IllegalStateException
/*     */   {
/* 195 */     return getDelegate().getUserTransaction();
/*     */   }
/*     */ 
/*     */   public boolean isCallerInRole(Identity role)
/*     */   {
/* 201 */     return getDelegate().isCallerInRole(role);
/*     */   }
/*     */ 
/*     */   public boolean isCallerInRole(String roleName)
/*     */   {
/* 206 */     return getDelegate().isCallerInRole(roleName);
/*     */   }
/*     */ 
/*     */   public Object lookup(String name)
/*     */   {
/* 211 */     return getDelegate().lookup(name);
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly() throws IllegalStateException
/*     */   {
/* 216 */     getDelegate().setRollbackOnly();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 221 */     return super.toString() + "{containerGuid=" + this.containerGuid + ",id=" + this.id + "}";
/*     */   }
/*     */ 
/*     */   private static class Serialized
/*     */     implements Serializable
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */     private Object id;
/*     */     private String containerClusterUid;
/*     */     private String containerGuid;
/*     */     private boolean isClustered;
/*     */ 
/*     */     private Object readResolve()
/*     */       throws ObjectStreamException
/*     */     {
/*  83 */       return new StatefulSessionContextImpl(this.containerGuid, this.containerClusterUid, this.id, this.isClustered);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulSessionContextImpl
 * JD-Core Version:    0.6.0
 */