/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.ejb3.cache.StatefulCache;
/*     */ import org.jboss.ejb3.tx.TxUtil;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TxUtils;
/*     */ 
/*     */ public class StatefulRemoveInterceptor
/*     */   implements Interceptor
/*     */ {
/*  42 */   private static final Logger log = Logger.getLogger(StatefulRemoveInterceptor.class);
/*     */   protected boolean retainIfException;
/*     */ 
/*     */   public StatefulRemoveInterceptor(boolean removeOnException)
/*     */   {
/*  47 */     this.retainIfException = removeOnException;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  52 */     return getClass().getName();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  94 */     Object rtn = null;
/*     */     try
/*     */     {
/*  97 */       rtn = invocation.invokeNext();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 102 */       if ((TxUtil.getApplicationException(t.getClass(), invocation) != null) && (this.retainIfException)) throw t;
/*     */ 
/* 105 */       removeSession(invocation, true);
/* 106 */       throw t;
/*     */     }
/* 108 */     removeSession(invocation, false);
/* 109 */     return rtn;
/*     */   }
/*     */ 
/*     */   protected void removeSession(Invocation invocation, boolean exceptionThrown) throws Throwable
/*     */   {
/* 114 */     StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
/* 115 */     StatefulBeanContext ctx = (StatefulBeanContext)ejb.getBeanContext();
/* 116 */     if ((ctx == null) || (ctx.isDiscarded()) || (ctx.isRemoved())) return;
/* 117 */     Object id = ejb.getId();
/*     */ 
/* 120 */     StatefulContainer container = (StatefulContainer)ejb.getAdvisor();
/* 121 */     Transaction tx = null;
/*     */     try
/*     */     {
/* 124 */       tx = TxUtil.getTransactionManager().getTransaction();
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 128 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/* 131 */     if ((tx != null) && (TxUtils.isActive(tx)))
/*     */     {
/*     */       try
/*     */       {
/* 135 */         tx.registerSynchronization(new RemoveSynchronization(container, id, (exceptionThrown != true) && (this.retainIfException)));
/*     */       }
/*     */       catch (RollbackException e)
/*     */       {
/* 139 */         throw new RuntimeException(e);
/*     */       }
/*     */       catch (SystemException e)
/*     */       {
/* 143 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 148 */       container.getCache().remove(id);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class RemoveSynchronization
/*     */     implements Synchronization
/*     */   {
/*     */     protected boolean retainIfException;
/*     */     private StatefulContainer container;
/*     */     private Object id;
/*     */ 
/*     */     public RemoveSynchronization(StatefulContainer container, Object id, boolean removeOnException)
/*     */     {
/*  63 */       this.container = container;
/*  64 */       this.id = id;
/*  65 */       this.retainIfException = removeOnException;
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/*     */       try
/*     */       {
/*  77 */         StatefulBeanContext ctx = this.container.getCache().get(this.id);
/*  78 */         this.container.invokePreDestroy(ctx);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*  82 */         if (!this.retainIfException)
/*     */         {
/*  84 */           this.container.getCache().remove(this.id);
/*     */         }
/*  86 */         throw new RuntimeException(t);
/*     */       }
/*  88 */       this.container.getCache().remove(this.id);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulRemoveInterceptor
 * JD-Core Version:    0.6.0
 */