/*    */ package org.jboss.ejb3.stateful;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import javax.ejb.Remove;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.InstanceAdvisor;
/*    */ import org.jboss.aop.advice.AspectFactory;
/*    */ import org.jboss.aop.joinpoint.Joinpoint;
/*    */ import org.jboss.aop.joinpoint.MethodJoinpoint;
/*    */ import org.jboss.ejb.RemoveImpl;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class StatefulRemoveFactory
/*    */   implements AspectFactory
/*    */ {
/* 42 */   private static final Logger log = Logger.getLogger(StatefulRemoveFactory.class);
/*    */ 
/*    */   public Object createPerVM()
/*    */   {
/* 46 */     throw new IllegalStateException("PER_VM NOT APPLICABLE");
/*    */   }
/*    */ 
/*    */   public Object createPerClass(Advisor advisor)
/*    */   {
/* 51 */     throw new IllegalStateException("PER_CLASS NOT APPLICABLE");
/*    */   }
/*    */ 
/*    */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*    */   {
/* 56 */     throw new IllegalStateException("PER_INSTANCE NOT APPLICABLE");
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*    */   {
/* 61 */     if (!(jp instanceof MethodJoinpoint))
/* 62 */       throw new IllegalArgumentException("Joinpoint is not a method: " + jp);
/* 63 */     MethodJoinpoint methodJoinpoint = (MethodJoinpoint)MethodJoinpoint.class.cast(jp);
/* 64 */     Method method = methodJoinpoint.getMethod();
/* 65 */     Remove rm = (Remove)advisor.resolveAnnotation(method, Remove.class);
/* 66 */     if (rm == null)
/*    */     {
/* 68 */       log.warn("Cannot find @" + Remove.class.getName() + " for " + method + " assuming defaults");
/* 69 */       rm = new RemoveImpl();
/*    */     }
/* 71 */     return new StatefulRemoveInterceptor(rm.retainIfException());
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*    */   {
/* 76 */     throw new IllegalStateException("PER_CLASS_JOINPOINT NOT APPLICABLE");
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 81 */     return "StatefulRemoveInterceptor";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulRemoveFactory
 * JD-Core Version:    0.6.0
 */