/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.concurrent.locks.ReentrantLock;
/*     */ import javax.ejb.ApplicationException;
/*     */ import javax.ejb.ConcurrentAccessException;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.ThreadLocalStack;
/*     */ import org.jboss.ejb3.annotation.SerializedConcurrentAccess;
/*     */ import org.jboss.ejb3.cache.StatefulCache;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.ejb.spec.ApplicationExceptionMetaData;
/*     */ import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
/*     */ 
/*     */ public class StatefulInstanceInterceptor
/*     */   implements Interceptor
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(StatefulInstanceInterceptor.class);
/*     */ 
/*     */   public String getName()
/*     */   {
/*  55 */     return null;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/*  60 */     StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
/*  61 */     Object id = ejb.getId();
/*  62 */     StatefulContainer container = (StatefulContainer)ejb.getAdvisor();
/*  63 */     StatefulBeanContext target = container.getCache().get(id);
/*     */ 
/*  65 */     boolean block = container.resolveAnnotation(SerializedConcurrentAccess.class) != null;
/*     */ 
/*  67 */     if (block)
/*     */     {
/*  69 */       target.getLock().lockInterruptibly();
/*     */     }
/*     */     else
/*     */     {
/*  73 */       synchronized (target)
/*     */       {
/*  75 */         if (target.isInInvocation()) throw new ConcurrentAccessException("no concurrent calls on stateful bean '" + container.getName() + "' (EJB3 4.3.13)");
/*  76 */         target.setInInvocation(true);
/*     */       }
/*     */     }
/*  79 */     ejb.setTargetObject(target.getInstance());
/*  80 */     ejb.setBeanContext(target);
/*  81 */     StatefulBeanContext.currentBean.push(target);
/*  82 */     container.pushContext(target);
/*     */     try
/*     */     {
/*  85 */       if (target.isDiscarded()) throw new EJBException("SFSB was discarded by another thread");
/*  86 */       ??? = ejb.invokeNext();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  90 */       if (isApplicationException(ex.getClass(), container)) throw ex;
/*  91 */       if (((ex instanceof RuntimeException)) || ((ex instanceof RemoteException)))
/*     */       {
/*  94 */         if (log.isTraceEnabled())
/*  95 */           log.trace("Removing bean " + id + " because of exception", ex);
/*  96 */         container.getCache().remove(id);
/*  97 */         target.setDiscarded(true);
/*     */       }
/*  99 */       throw ex;
/*     */     }
/*     */     finally
/*     */     {
/* 103 */       container.popContext();
/* 104 */       StatefulBeanContext.currentBean.pop();
/* 105 */       synchronized (target)
/*     */       {
/* 107 */         target.setInInvocation(false);
/* 108 */         if ((!target.isTxSynchronized()) && (!target.isDiscarded())) container.getCache().release(target);
/* 109 */         if (block) target.getLock().unlock();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static boolean isApplicationException(Class<?> exceptionClass, EJBContainer container)
/*     */   {
/* 116 */     if (exceptionClass.isAnnotationPresent(ApplicationException.class)) {
/* 117 */       return true;
/*     */     }
/*     */ 
/* 120 */     JBossAssemblyDescriptorMetaData assembly = container.getAssemblyDescriptor();
/* 121 */     if (assembly != null)
/*     */     {
/* 123 */       ApplicationExceptionsMetaData exceptions = assembly.getApplicationExceptions();
/* 124 */       if ((exceptions != null) && (exceptions.size() > 0))
/*     */       {
/* 126 */         for (ApplicationExceptionMetaData exception : exceptions)
/*     */         {
/* 128 */           if (exception.getExceptionClass().equals(exceptionClass.getName())) {
/* 129 */             return true;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 134 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulInstanceInterceptor
 * JD-Core Version:    0.6.0
 */