/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.ejb.HomeHandle;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ import org.jboss.ejb3.session.BaseSessionRemoteProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class StatefulHomeRemoteProxy extends BaseSessionRemoteProxy
/*     */ {
/*     */   private static final long serialVersionUID = 5509794838403316545L;
/*  48 */   private static final Logger log = Logger.getLogger(StatefulHomeRemoteProxy.class);
/*     */   protected InvokerLocator uri;
/*     */   private HomeHandle homeHandle;
/*     */   private EJBMetaData ejbMetaData;
/*     */ 
/*     */   public StatefulHomeRemoteProxy(Container container, Interceptor[] interceptors, InvokerLocator uri)
/*     */   {
/*  56 */     super(container, interceptors);
/*  57 */     this.uri = uri;
/*     */   }
/*     */ 
/*     */   public StatefulHomeRemoteProxy(Container container, Interceptor[] interceptors, InvokerLocator uri, Object id)
/*     */   {
/*  62 */     super(container, interceptors);
/*  63 */     this.uri = uri;
/*  64 */     this.id = id;
/*     */   }
/*     */ 
/*     */   protected StatefulHomeRemoteProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setHandle(StatefulHandleImpl handle)
/*     */   {
/*  73 */     this.handle = handle;
/*  74 */     handle.id = this.id;
/*     */   }
/*     */ 
/*     */   public void setHomeHandle(HomeHandle homeHandle)
/*     */   {
/*  79 */     this.homeHandle = homeHandle;
/*     */   }
/*     */ 
/*     */   public void setEjbMetaData(EJBMetaData ejbMetaData)
/*     */   {
/*  84 */     this.ejbMetaData = ejbMetaData;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  90 */     long hash = MethodHashing.calculateHash(method);
/*  91 */     Object ret = ProxyUtils.handleCallLocally(hash, proxy, this, method, args);
/*  92 */     if (ret != null)
/*     */     {
/*  94 */       return ret;
/*     */     }
/*     */ 
/*  97 */     ret = handleEjb21CallLocally(method, args);
/*  98 */     if (ret != null)
/*     */     {
/* 100 */       return ret;
/*     */     }
/*     */ 
/* 103 */     StatefulRemoteInvocation sri = new StatefulRemoteInvocation(this.interceptors, hash, method, method, null, null);
/* 104 */     sri.setArguments(args);
/* 105 */     sri.setInstanceResolver(this.metadata);
/* 106 */     sri.getMetaData().addMetaData("DISPATCHER", "OID", this.containerId, PayloadKey.AS_IS);
/* 107 */     sri.getMetaData().addMetaData("REMOTING", "INVOKER_LOCATOR", this.uri, PayloadKey.AS_IS);
/* 108 */     sri.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
/* 109 */     sri.getMetaData().addMetaData("IS_LOCAL", "GUID", this.containerGuid, PayloadKey.AS_IS);
/*     */ 
/* 111 */     return sri.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object getAsynchronousProxy(Object proxy)
/*     */   {
/* 116 */     throw new RuntimeException("NOT IMPLEMENTED");
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 121 */     return this.containerId.toString() + ":Home";
/*     */   }
/*     */ 
/*     */   private Object handleEjb21CallLocally(Method method, Object[] args)
/*     */   {
/* 126 */     if (method.equals(ProxyUtils.GET_HOME_HANDLE))
/*     */     {
/* 128 */       return this.homeHandle;
/*     */     }
/* 130 */     if (method.equals(ProxyUtils.GET_EJB_METADATA))
/*     */     {
/* 132 */       return this.ejbMetaData;
/*     */     }
/*     */ 
/* 135 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulHomeRemoteProxy
 * JD-Core Version:    0.6.0
 */