/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Map;
/*     */ import javax.annotation.PostConstruct;
/*     */ import javax.annotation.PreDestroy;
/*     */ import javax.ejb.EJB;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.Init;
/*     */ import javax.ejb.PostActivate;
/*     */ import javax.ejb.PrePassivate;
/*     */ import javax.ejb.Remote;
/*     */ import javax.ejb.RemoteHome;
/*     */ import javax.ejb.TimerService;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationResponse;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aspects.asynch.FutureHolder;
/*     */ import org.jboss.ejb3.BeanContext;
/*     */ import org.jboss.ejb3.EJBContainerInvocation;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ import org.jboss.ejb3.ThreadLocalStack;
/*     */ import org.jboss.ejb3.annotation.Cache;
/*     */ import org.jboss.ejb3.annotation.Clustered;
/*     */ import org.jboss.ejb3.annotation.LocalBinding;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.annotation.RemoteBindings;
/*     */ import org.jboss.ejb3.cache.CacheFactoryRegistry;
/*     */ import org.jboss.ejb3.cache.Ejb3CacheFactory;
/*     */ import org.jboss.ejb3.cache.StatefulCache;
/*     */ import org.jboss.ejb3.cache.StatefulObjectFactory;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*     */ import org.jboss.ejb3.interceptor.LifecycleInterceptorHandler;
/*     */ import org.jboss.ejb3.proxy.EJBMetaDataImpl;
/*     */ import org.jboss.ejb3.proxy.handle.HomeHandleImpl;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.ejb3.session.ProxyDeployer;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.ejb3.session.SessionContainer.InvokedMethod;
/*     */ import org.jboss.ejb3.statistics.InvocationStatistics;
/*     */ import org.jboss.injection.Injector;
/*     */ import org.jboss.injection.JndiPropertyInjector;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class StatefulContainer extends SessionContainer
/*     */   implements StatefulObjectFactory<StatefulBeanContext>
/*     */ {
/*     */   private static final Logger log;
/*     */   protected StatefulCache cache;
/*  84 */   private StatefulDelegateWrapper mbean = new StatefulDelegateWrapper(this);
/*     */ 
/*     */   public StatefulContainer(ClassLoader cl, String beanClassName, String ejbName, AspectManager manager, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment)
/*     */   {
/*  90 */     super(cl, beanClassName, ejbName, manager, ctxProperties, interceptorRepository, deployment);
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext create(Class<?>[] initTypes, Object[] initValues)
/*     */   {
/*  97 */     return (StatefulBeanContext)createBeanContext();
/*     */   }
/*     */ 
/*     */   public BeanContext<?> createBeanContext()
/*     */   {
/* 103 */     return new StatefulBeanContext(this, construct());
/*     */   }
/*     */ 
/*     */   protected ProxyFactory createProxyFactory(LocalBinding binding)
/*     */   {
/* 109 */     return new StatefulLocalProxyFactory(this, binding);
/*     */   }
/*     */ 
/*     */   protected RemoteProxyFactory createRemoteProxyFactory(RemoteBinding binding)
/*     */   {
/* 115 */     Clustered clustered = (Clustered)getAnnotation(Clustered.class);
/* 116 */     if (clustered != null)
/*     */     {
/* 118 */       return new StatefulClusterProxyFactory(this, binding, clustered);
/*     */     }
/*     */ 
/* 122 */     return new StatefulRemoteProxyFactory(this, binding);
/*     */   }
/*     */ 
/*     */   public void destroy(StatefulBeanContext obj)
/*     */   {
/* 128 */     invokePreDestroy(obj);
/*     */   }
/*     */ 
/*     */   public Object getMBean()
/*     */   {
/* 133 */     return this.mbean;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 140 */       super.start();
/* 141 */       Cache cacheConfig = (Cache)getAnnotation(Cache.class);
/* 142 */       CacheFactoryRegistry registry = getCacheFactoryRegistry();
/* 143 */       Ejb3CacheFactory factory = registry.getCacheFactory(cacheConfig.value());
/* 144 */       this.cache = factory.createCache();
/* 145 */       this.cache.initialize(this);
/* 146 */       this.cache.start();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       try
/*     */       {
/* 152 */         stop();
/*     */       }
/*     */       catch (Exception ignore)
/*     */       {
/* 156 */         log.debug("Failed to cleanup after start() failure", ignore);
/*     */       }
/* 158 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 165 */     if (this.cache != null) this.cache.stop();
/* 166 */     super.stop();
/*     */   }
/*     */ 
/*     */   public StatefulCache getCache()
/*     */   {
/* 171 */     return this.cache;
/*     */   }
/*     */ 
/*     */   public CacheFactoryRegistry getCacheFactoryRegistry()
/*     */   {
/* 176 */     return getDeployment().getCacheFactoryRegistry();
/*     */   }
/*     */ 
/*     */   public Object localInvoke(Object id, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 185 */     return localInvoke(id, method, args, null);
/*     */   }
/*     */ 
/*     */   public Object localHomeInvoke(Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 194 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/* 195 */     pushEnc();
/*     */     try
/*     */     {
/* 198 */       long hash = MethodHashing.calculateHash(method);
/* 199 */       MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
/* 200 */       if (info == null)
/*     */       {
/* 202 */         throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
/*     */       }
/*     */ 
/* 206 */       Object localObject1 = invokeLocalHomeMethod(info, args);
/*     */       return localObject1;
/*     */     }
/*     */     finally
/*     */     {
/* 210 */       Thread.currentThread().setContextClassLoader(oldLoader);
/* 211 */       popEnc(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public Object localInvoke(Object id, Method method, Object[] args, FutureHolder provider)
/*     */     throws Throwable
/*     */   {
/* 223 */     long start = System.currentTimeMillis();
/*     */ 
/* 225 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/* 226 */     pushEnc();
/*     */     try
/*     */     {
/* 229 */       long hash = MethodHashing.calculateHash(method);
/* 230 */       MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
/* 231 */       if (info == null)
/*     */       {
/* 233 */         throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
/*     */       }
/*     */ 
/* 238 */       Method unadvisedMethod = info.getUnadvisedMethod();
/*     */       try
/*     */       {
/* 242 */         this.invokeStats.callIn();
/*     */         Object localObject1;
/* 244 */         if ((unadvisedMethod != null) && (isHomeMethod(unadvisedMethod)))
/*     */         {
/* 246 */           localObject1 = invokeLocalHomeMethod(info, args);
/*     */ 
/* 265 */           if (unadvisedMethod != null)
/*     */           {
/* 267 */             long end = System.currentTimeMillis();
/* 268 */             long elapsed = end - start;
/* 269 */             this.invokeStats.updateStats(unadvisedMethod, elapsed);
/*     */           }
/*     */ 
/* 272 */           this.invokeStats.callOut();
/*     */ 
/* 274 */           this.invokedMethod.pop();
/*     */ 
/* 279 */           Thread.currentThread().setContextClassLoader(oldLoader);
/* 280 */           popEnc(); return localObject1;
/*     */         }
/* 248 */         if ((unadvisedMethod != null) && (isEJBObjectMethod(unadvisedMethod)))
/*     */         {
/* 251 */           localObject1 = invokeEJBLocalObjectMethod(id, info, args);
/*     */ 
/* 265 */           if (unadvisedMethod != null)
/*     */           {
/* 267 */             end = System.currentTimeMillis();
/* 268 */             long elapsed = end - start;
/* 269 */             this.invokeStats.updateStats(unadvisedMethod, elapsed);
/*     */           }
/*     */ 
/* 272 */           this.invokeStats.callOut();
/*     */ 
/* 274 */           this.invokedMethod.pop();
/*     */ 
/* 279 */           Thread.currentThread().setContextClassLoader(oldLoader);
/* 280 */           popEnc(); return localObject1;
/*     */         }
/* 254 */         StatefulContainerInvocation nextInvocation = new StatefulContainerInvocation(info, id);
/* 255 */         nextInvocation.setAdvisor(this);
/* 256 */         nextInvocation.setArguments(args);
/*     */ 
/* 258 */         ProxyUtils.addLocalAsynchronousInfo(nextInvocation, provider);
/*     */ 
/* 260 */         this.invokedMethod.push(new SessionContainer.InvokedMethod(this, true, method));
/* 261 */         long end = nextInvocation.invokeNext();
/*     */ 
/* 265 */         if (unadvisedMethod != null)
/*     */         {
/* 267 */           long end = System.currentTimeMillis();
/* 268 */           long elapsed = end - start;
/* 269 */           this.invokeStats.updateStats(unadvisedMethod, elapsed);
/*     */         }
/*     */ 
/* 272 */         this.invokeStats.callOut();
/*     */ 
/* 274 */         this.invokedMethod.pop();
/*     */ 
/* 279 */         Thread.currentThread().setContextClassLoader(oldLoader);
/* 280 */         popEnc(); return end;
/*     */       }
/*     */       finally
/*     */       {
/* 265 */         if (unadvisedMethod != null)
/*     */         {
/* 267 */           long end = System.currentTimeMillis();
/* 268 */           long elapsed = end - start;
/* 269 */           this.invokeStats.updateStats(unadvisedMethod, elapsed);
/*     */         }
/*     */ 
/* 272 */         this.invokeStats.callOut();
/*     */ 
/* 274 */         this.invokedMethod.pop();
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 279 */       Thread.currentThread().setContextClassLoader(oldLoader);
/* 280 */       popEnc(); } throw localObject3;
/*     */   }
/*     */ 
/*     */   public Object createSession(Class[] initTypes, Object[] initValues)
/*     */   {
/* 291 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/* 292 */     pushEnc();
/*     */     try
/*     */     {
/* 295 */       Thread.currentThread().setContextClassLoader(this.classloader);
/* 296 */       StatefulBeanContext ctx = getCache().create(initTypes, initValues);
/*     */ 
/* 298 */       ctx.setInUse(false);
/* 299 */       Object localObject1 = ctx.getId();
/*     */       return localObject1;
/*     */     }
/*     */     finally
/*     */     {
/* 303 */       Thread.currentThread().setContextClassLoader(oldLoader);
/* 304 */       popEnc(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   protected void destroySession(Object id)
/*     */   {
/* 310 */     getCache().remove(id);
/*     */   }
/*     */ 
/*     */   public InvocationResponse dynamicInvoke(Object target, Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 322 */     long start = System.currentTimeMillis();
/*     */ 
/* 324 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/* 325 */     EJBContainerInvocation newSi = null;
/* 326 */     pushEnc();
/*     */     try
/*     */     {
/* 329 */       Thread.currentThread().setContextClassLoader(this.classloader);
/* 330 */       StatefulRemoteInvocation si = (StatefulRemoteInvocation)invocation;
/* 331 */       MethodInfo info = (MethodInfo)this.methodInterceptors.get(si.getMethodHash());
/* 332 */       if (info == null)
/*     */       {
/* 334 */         throw new RuntimeException("Could not resolve beanClass method from proxy call");
/*     */       }
/*     */ 
/* 337 */       InvocationResponse response = null;
/* 338 */       Method unadvisedMethod = info.getUnadvisedMethod();
/* 339 */       Object newId = null;
/*     */       try
/*     */       {
/* 343 */         this.invokeStats.callIn();
/*     */ 
/* 345 */         if ((info != null) && (unadvisedMethod != null) && (isHomeMethod(unadvisedMethod)))
/*     */         {
/* 347 */           response = invokeHomeMethod(info, si);
/*     */         }
/* 349 */         else if ((info != null) && (unadvisedMethod != null) && (isEJBObjectMethod(unadvisedMethod)))
/*     */         {
/* 351 */           response = invokeEJBObjectMethod(info, si);
/*     */         }
/*     */         else
/*     */         {
/* 355 */           if (si.getId() == null)
/*     */           {
/* 357 */             StatefulBeanContext ctx = getCache().create(null, null);
/* 358 */             newId = ctx.getId();
/*     */           }
/*     */           else
/*     */           {
/* 362 */             newId = si.getId();
/*     */           }
/* 364 */           newSi = new StatefulContainerInvocation(info, newId);
/* 365 */           newSi.setArguments(si.getArguments());
/* 366 */           newSi.setMetaData(si.getMetaData());
/* 367 */           newSi.setAdvisor(this);
/*     */ 
/* 369 */           Object rtn = null;
/*     */ 
/* 371 */           this.invokedMethod.push(new SessionContainer.InvokedMethod(this, false, unadvisedMethod));
/* 372 */           rtn = newSi.invokeNext();
/*     */ 
/* 374 */           response = marshallResponse(invocation, rtn, newSi.getResponseContextInfo());
/* 375 */           if (newId != null) response.addAttachment("NEW_ID", newId);
/*     */         }
/*     */       }
/*     */       catch (Throwable throwable)
/*     */       {
/*     */         long end;
/*     */         long elapsed;
/* 380 */         Throwable exception = throwable;
/* 381 */         if (newId != null)
/*     */         {
/* 383 */           exception = new ForwardId(throwable, newId);
/*     */         }
/* 385 */         Map responseContext = null;
/* 386 */         if (newSi != null) newSi.getResponseContextInfo();
/* 387 */         response = marshallException(invocation, exception, responseContext);
/* 388 */         InvocationResponse localInvocationResponse1 = response;
/*     */ 
/* 392 */         if (unadvisedMethod != null)
/*     */         {
/* 394 */           long end = System.currentTimeMillis();
/* 395 */           long elapsed = end - start;
/* 396 */           this.invokeStats.updateStats(unadvisedMethod, elapsed);
/*     */         }
/*     */ 
/* 399 */         this.invokeStats.callOut();
/*     */ 
/* 401 */         this.invokedMethod.pop();
/*     */ 
/* 408 */         Thread.currentThread().setContextClassLoader(oldLoader);
/* 409 */         popEnc(); return localInvocationResponse1;
/*     */       }
/*     */       finally
/*     */       {
/* 392 */         if (unadvisedMethod != null)
/*     */         {
/* 394 */           long end = System.currentTimeMillis();
/* 395 */           long elapsed = end - start;
/* 396 */           this.invokeStats.updateStats(unadvisedMethod, elapsed);
/*     */         }
/*     */ 
/* 399 */         this.invokeStats.callOut();
/*     */ 
/* 401 */         this.invokedMethod.pop();
/*     */       }
/*     */ 
/* 404 */       throwable = response;
/*     */       return throwable;
/*     */     }
/*     */     finally
/*     */     {
/* 408 */       Thread.currentThread().setContextClassLoader(oldLoader);
/* 409 */       popEnc(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService()
/*     */   {
/* 416 */     throw new UnsupportedOperationException("stateful bean doesn't support TimerService (EJB3 18.2#2)");
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService(Object pKey)
/*     */   {
/* 421 */     return getTimerService();
/*     */   }
/*     */ 
/*     */   public void invokePostActivate(BeanContext beanContext)
/*     */   {
/* 427 */     for (Injector injector : this.injectors)
/*     */     {
/* 429 */       if ((injector instanceof JndiPropertyInjector))
/*     */       {
/* 431 */         AccessibleObject field = ((JndiPropertyInjector)injector).getAccessibleObject();
/*     */ 
/* 433 */         if (field.isAnnotationPresent(EJB.class))
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 438 */         if ((field instanceof Field))
/*     */         {
/* 441 */           if ((((Field)field).getModifiers() & 0x80) > 0)
/* 442 */             injector.inject(beanContext);
/*     */         }
/*     */       }
/*     */     }
/* 446 */     this.callbackHandler.postActivate(beanContext);
/*     */   }
/*     */ 
/*     */   public void invokePrePassivate(BeanContext beanContext)
/*     */   {
/* 452 */     this.callbackHandler.prePassivate(beanContext);
/*     */   }
/*     */ 
/*     */   protected Class[] getHandledCallbacks()
/*     */   {
/* 458 */     return new Class[] { PostConstruct.class, PreDestroy.class, PostActivate.class, PrePassivate.class };
/*     */   }
/*     */ 
/*     */   public void invokeInit(Object bean, Class[] initParameterTypes, Object[] initParameterValues)
/*     */   {
/* 466 */     int numParameters = 0;
/* 467 */     if (initParameterTypes != null)
/* 468 */       numParameters = initParameterTypes.length;
/*     */     try
/*     */     {
/* 471 */       for (Method method : bean.getClass().getDeclaredMethods())
/*     */       {
/* 473 */         if (numParameters != method.getParameterTypes().length) {
/*     */           continue;
/*     */         }
/* 476 */         if ((method.getAnnotation(Init.class) == null) && (resolveAnnotation(method, Init.class) == null)) {
/*     */           continue;
/*     */         }
/* 479 */         if (initParameterTypes != null)
/*     */         {
/* 481 */           Object[] parameters = getInitParameters(method, initParameterTypes, initParameterValues);
/*     */ 
/* 484 */           if (parameters != null)
/* 485 */             method.invoke(bean, parameters);
/*     */         }
/*     */         else
/*     */         {
/* 489 */           method.invoke(bean, new Object[0]);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 496 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object[] getInitParameters(Method method, Class[] initParameterTypes, Object[] initParameterValues)
/*     */   {
/* 503 */     if (method.getParameterTypes().length == initParameterTypes.length)
/*     */     {
/* 505 */       for (int i = 0; i < initParameterTypes.length; i++)
/*     */       {
/* 507 */         Class formal = method.getParameterTypes()[i];
/* 508 */         Class actual = initParameterTypes[i];
/* 509 */         if (!isMethodInvocationConvertible(formal, actual == null ? null : actual))
/*     */         {
/* 511 */           return null;
/*     */         }
/*     */       }
/* 513 */       return initParameterValues;
/*     */     }
/* 515 */     return null;
/*     */   }
/*     */ 
/*     */   private static boolean isMethodInvocationConvertible(Class formal, Class actual)
/*     */   {
/* 541 */     if ((actual == null) && (!formal.isPrimitive()))
/*     */     {
/* 543 */       return true;
/*     */     }
/*     */ 
/* 548 */     if ((actual != null) && (formal.isAssignableFrom(actual)))
/*     */     {
/* 550 */       return true;
/*     */     }
/*     */ 
/* 556 */     if (formal.isPrimitive())
/*     */     {
/* 558 */       if ((formal == Boolean.TYPE) && (actual == Boolean.class))
/* 559 */         return true;
/* 560 */       if ((formal == Character.TYPE) && (actual == Character.class))
/* 561 */         return true;
/* 562 */       if ((formal == Byte.TYPE) && (actual == Byte.class))
/* 563 */         return true;
/* 564 */       if ((formal == Short.TYPE) && ((actual == Short.class) || (actual == Byte.class)))
/*     */       {
/* 566 */         return true;
/* 567 */       }if ((formal == Integer.TYPE) && ((actual == Integer.class) || (actual == Short.class) || (actual == Byte.class)))
/*     */       {
/* 569 */         return true;
/* 570 */       }if ((formal == Long.TYPE) && ((actual == Long.class) || (actual == Integer.class) || (actual == Short.class) || (actual == Byte.class)))
/*     */       {
/* 573 */         return true;
/* 574 */       }if ((formal == Float.TYPE) && ((actual == Float.class) || (actual == Long.class) || (actual == Integer.class) || (actual == Short.class) || (actual == Byte.class)))
/*     */       {
/* 577 */         return true;
/* 578 */       }if ((formal == Double.TYPE) && ((actual == Double.class) || (actual == Float.class) || (actual == Long.class) || (actual == Integer.class) || (actual == Short.class) || (actual == Byte.class)))
/*     */       {
/* 582 */         return true;
/*     */       }
/*     */     }
/* 584 */     return false;
/*     */   }
/*     */ 
/*     */   private Object invokeEJBLocalObjectMethod(Object id, MethodInfo info, Object[] args)
/*     */     throws Exception
/*     */   {
/* 590 */     Method unadvisedMethod = info.getUnadvisedMethod();
/* 591 */     if (unadvisedMethod.getName().equals("remove"))
/*     */     {
/* 593 */       destroySession(id);
/*     */ 
/* 595 */       return null;
/*     */     }
/* 597 */     if (unadvisedMethod.getName().equals("getEJBLocalHome"))
/*     */     {
/* 599 */       Object bean = getCache().get(id).getInstance();
/*     */ 
/* 601 */       return bean;
/*     */     }
/* 603 */     if (unadvisedMethod.getName().equals("getPrimaryKey"))
/*     */     {
/* 605 */       return id;
/*     */     }
/* 607 */     if (unadvisedMethod.getName().equals("isIdentical"))
/*     */     {
/* 609 */       EJBObject bean = (EJBObject)args[0];
/*     */ 
/* 611 */       Object primaryKey = bean.getPrimaryKey();
/*     */ 
/* 613 */       boolean isIdentical = id.equals(primaryKey);
/*     */ 
/* 615 */       return Boolean.valueOf(isIdentical);
/*     */     }
/*     */ 
/* 619 */     return null;
/*     */   }
/*     */ 
/*     */   private Object invokeLocalHomeMethod(MethodInfo info, Object[] args)
/*     */     throws Exception
/*     */   {
/* 626 */     Method unadvisedMethod = info.getUnadvisedMethod();
/* 627 */     if (unadvisedMethod.getName().startsWith("create"))
/*     */     {
/* 629 */       Class[] initParameterTypes = new Class[0];
/*     */ 
/* 631 */       Object[] initParameterValues = new Object[0];
/*     */ 
/* 633 */       if (unadvisedMethod.getParameterTypes().length > 0)
/*     */       {
/* 635 */         initParameterTypes = unadvisedMethod.getParameterTypes();
/* 636 */         initParameterValues = args;
/*     */       }
/*     */ 
/* 639 */       LocalBinding binding = (LocalBinding)resolveAnnotation(LocalBinding.class);
/*     */ 
/* 641 */       StatefulLocalProxyFactory factory = new StatefulLocalProxyFactory(this, binding);
/* 642 */       factory.init();
/*     */ 
/* 644 */       Object proxy = factory.createProxy(initParameterTypes, initParameterValues);
/*     */ 
/* 647 */       return proxy;
/*     */     }
/* 649 */     if (unadvisedMethod.getName().equals("remove"))
/*     */     {
/* 651 */       StatefulHandleImpl handle = (StatefulHandleImpl)args[0];
/*     */ 
/* 653 */       destroySession(handle.id);
/*     */ 
/* 655 */       return null;
/*     */     }
/*     */ 
/* 659 */     return null;
/*     */   }
/*     */ 
/*     */   public Object createLocalProxy(Object id, LocalBinding binding)
/*     */     throws Exception
/*     */   {
/* 665 */     StatefulLocalProxyFactory factory = new StatefulLocalProxyFactory(this, binding);
/* 666 */     factory.init();
/*     */ 
/* 668 */     return factory.createProxy(id);
/*     */   }
/*     */ 
/*     */   public Object createRemoteProxy(Object id, RemoteBinding binding)
/*     */     throws Exception
/*     */   {
/* 680 */     StatefulRemoteProxyFactory factory = new StatefulRemoteProxyFactory(this, binding);
/* 681 */     factory.init();
/*     */ 
/* 683 */     if (id != null) {
/* 684 */       return factory.createProxy(id);
/*     */     }
/* 686 */     return factory.createProxy();
/*     */   }
/*     */ 
/*     */   public boolean isClustered()
/*     */   {
/* 691 */     return hasAnnotation(getBeanClass(), Clustered.class.getName());
/*     */   }
/*     */ 
/*     */   protected InvocationResponse invokeHomeMethod(MethodInfo info, StatefulRemoteInvocation statefulInvocation)
/*     */     throws Throwable
/*     */   {
/* 697 */     Method unadvisedMethod = info.getUnadvisedMethod();
/* 698 */     if (unadvisedMethod.getName().startsWith("create"))
/*     */     {
/* 700 */       Class[] initParameterTypes = new Class[0];
/*     */ 
/* 702 */       Object[] initParameterValues = new Object[0];
/*     */ 
/* 704 */       if (unadvisedMethod.getParameterTypes().length > 0)
/*     */       {
/* 706 */         initParameterTypes = unadvisedMethod.getParameterTypes();
/* 707 */         initParameterValues = statefulInvocation.getArguments();
/*     */       }
/*     */ 
/* 710 */       RemoteBinding binding = null;
/* 711 */       RemoteBindings bindings = (RemoteBindings)resolveAnnotation(RemoteBindings.class);
/* 712 */       if (bindings != null)
/* 713 */         binding = bindings.value()[0];
/*     */       else {
/* 715 */         binding = (RemoteBinding)resolveAnnotation(RemoteBinding.class);
/*     */       }
/* 717 */       StatefulContainerInvocation newStatefulInvocation = buildNewInvocation(info, statefulInvocation, initParameterTypes, initParameterValues);
/*     */ 
/* 721 */       StatefulRemoteProxyFactory factory = new StatefulRemoteProxyFactory(this, binding);
/* 722 */       factory.init();
/*     */ 
/* 724 */       Object proxy = null;
/* 725 */       if (newStatefulInvocation.getId() != null)
/* 726 */         proxy = factory.createProxy(newStatefulInvocation.getId());
/*     */       else {
/* 728 */         proxy = factory.createProxy();
/*     */       }
/* 730 */       InvocationResponse response = marshallResponse(statefulInvocation, proxy, newStatefulInvocation.getResponseContextInfo());
/* 731 */       if (newStatefulInvocation.getId() != null) {
/* 732 */         response.addAttachment("NEW_ID", newStatefulInvocation.getId());
/*     */       }
/* 734 */       return response;
/*     */     }
/* 736 */     if (unadvisedMethod.getName().equals("remove"))
/*     */     {
/* 738 */       StatefulHandleImpl handle = (StatefulHandleImpl)statefulInvocation.getArguments()[0];
/*     */ 
/* 741 */       destroySession(handle.id);
/*     */ 
/* 743 */       InvocationResponse response = new InvocationResponse(null);
/* 744 */       response.setContextInfo(statefulInvocation.getResponseContextInfo());
/* 745 */       return response;
/*     */     }
/* 747 */     if (unadvisedMethod.getName().equals("getEJBMetaData"))
/*     */     {
/* 749 */       Class remote = null;
/* 750 */       Class home = null;
/* 751 */       Class pkClass = Object.class;
/* 752 */       HomeHandleImpl homeHandle = null;
/*     */ 
/* 754 */       Remote remoteAnnotation = (Remote)resolveAnnotation(Remote.class);
/* 755 */       if (remoteAnnotation != null)
/* 756 */         remote = remoteAnnotation.value()[0];
/* 757 */       RemoteHome homeAnnotation = (RemoteHome)resolveAnnotation(RemoteHome.class);
/* 758 */       if (homeAnnotation != null)
/* 759 */         home = homeAnnotation.value();
/* 760 */       RemoteBinding remoteBindingAnnotation = (RemoteBinding)resolveAnnotation(RemoteBinding.class);
/* 761 */       if (remoteBindingAnnotation != null) {
/* 762 */         homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
/*     */       }
/*     */ 
/* 765 */       EJBMetaDataImpl metadata = new EJBMetaDataImpl(remote, home, pkClass, true, false, homeHandle);
/*     */ 
/* 768 */       InvocationResponse response = marshallResponse(statefulInvocation, metadata, null);
/* 769 */       return response;
/*     */     }
/* 771 */     if (unadvisedMethod.getName().equals("getHomeHandle"))
/*     */     {
/* 773 */       HomeHandleImpl homeHandle = null;
/*     */ 
/* 775 */       RemoteBinding remoteBindingAnnotation = (RemoteBinding)resolveAnnotation(RemoteBinding.class);
/* 776 */       if (remoteBindingAnnotation != null) {
/* 777 */         homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
/*     */       }
/*     */ 
/* 781 */       InvocationResponse response = marshallResponse(statefulInvocation, homeHandle, null);
/* 782 */       return response;
/*     */     }
/*     */ 
/* 786 */     return null;
/*     */   }
/*     */ 
/*     */   protected InvocationResponse invokeEJBObjectMethod(MethodInfo info, StatefulRemoteInvocation statefulInvocation)
/*     */     throws Throwable
/*     */   {
/* 793 */     Method unadvisedMethod = info.getUnadvisedMethod();
/* 794 */     if (unadvisedMethod.getName().equals("getHandle"))
/*     */     {
/* 796 */       StatefulContainerInvocation newStatefulInvocation = buildInvocation(info, statefulInvocation);
/*     */ 
/* 799 */       StatefulHandleImpl handle = new StatefulHandleImpl();
/* 800 */       handle.id = newStatefulInvocation.getId();
/* 801 */       RemoteBinding remoteBinding = (RemoteBinding)resolveAnnotation(RemoteBinding.class);
/* 802 */       if (remoteBinding != null)
/* 803 */         handle.jndiName = remoteBinding.jndiBinding();
/* 804 */       InvocationResponse response = marshallResponse(statefulInvocation, handle, null);
/* 805 */       return response;
/*     */     }
/* 807 */     if (unadvisedMethod.getName().equals("remove"))
/*     */     {
/* 809 */       destroySession(statefulInvocation.getId());
/*     */ 
/* 811 */       InvocationResponse response = new InvocationResponse(null);
/* 812 */       return response;
/*     */     }
/* 814 */     if (unadvisedMethod.getName().equals("getEJBHome"))
/*     */     {
/* 816 */       HomeHandleImpl homeHandle = null;
/*     */ 
/* 818 */       RemoteBinding remoteBindingAnnotation = (RemoteBinding)resolveAnnotation(RemoteBinding.class);
/* 819 */       if (remoteBindingAnnotation != null) {
/* 820 */         homeHandle = new HomeHandleImpl(ProxyFactoryHelper.getHomeJndiName(this));
/*     */       }
/* 822 */       EJBHome ejbHome = homeHandle.getEJBHome();
/*     */ 
/* 824 */       InvocationResponse response = marshallResponse(statefulInvocation, ejbHome, null);
/* 825 */       return response;
/*     */     }
/* 827 */     if (unadvisedMethod.getName().equals("getPrimaryKey"))
/*     */     {
/* 829 */       Object id = statefulInvocation.getId();
/*     */ 
/* 831 */       InvocationResponse response = marshallResponse(statefulInvocation, id, null);
/* 832 */       return response;
/*     */     }
/* 834 */     if (unadvisedMethod.getName().equals("isIdentical"))
/*     */     {
/* 836 */       Object id = statefulInvocation.getId();
/* 837 */       EJBObject bean = (EJBObject)statefulInvocation.getArguments()[0];
/*     */ 
/* 839 */       Object primaryKey = bean.getPrimaryKey();
/*     */ 
/* 841 */       boolean isIdentical = id.equals(primaryKey);
/*     */ 
/* 843 */       InvocationResponse response = marshallResponse(statefulInvocation, Boolean.valueOf(isIdentical), null);
/* 844 */       return response;
/*     */     }
/*     */ 
/* 848 */     return null;
/*     */   }
/*     */ 
/*     */   private StatefulContainerInvocation buildNewInvocation(MethodInfo info, StatefulRemoteInvocation statefulInvocation, Class[] initParameterTypes, Object[] initParameterValues)
/*     */   {
/* 856 */     StatefulContainerInvocation newStatefulInvocation = null;
/*     */ 
/* 858 */     StatefulBeanContext ctx = null;
/* 859 */     if (initParameterTypes.length > 0)
/* 860 */       ctx = getCache().create(initParameterTypes, initParameterValues);
/*     */     else {
/* 862 */       ctx = getCache().create(null, null);
/*     */     }
/* 864 */     Object newId = ctx.getId();
/* 865 */     newStatefulInvocation = new StatefulContainerInvocation(info, newId);
/*     */ 
/* 867 */     newStatefulInvocation.setArguments(statefulInvocation.getArguments());
/* 868 */     newStatefulInvocation.setMetaData(statefulInvocation.getMetaData());
/* 869 */     newStatefulInvocation.setAdvisor(this);
/*     */ 
/* 871 */     return newStatefulInvocation;
/*     */   }
/*     */ 
/*     */   private StatefulContainerInvocation buildInvocation(MethodInfo info, StatefulRemoteInvocation statefulInvocation)
/*     */   {
/* 877 */     StatefulContainerInvocation newStatefulInvocation = null;
/* 878 */     Object newId = null;
/* 879 */     if (statefulInvocation.getId() == null)
/*     */     {
/* 881 */       StatefulBeanContext ctx = getCache().create(null, null);
/* 882 */       newId = ctx.getId();
/* 883 */       newStatefulInvocation = new StatefulContainerInvocation(info, newId);
/*     */     }
/*     */     else
/*     */     {
/* 887 */       newStatefulInvocation = new StatefulContainerInvocation(info, statefulInvocation.getId());
/*     */     }
/*     */ 
/* 890 */     newStatefulInvocation.setArguments(statefulInvocation.getArguments());
/* 891 */     newStatefulInvocation.setMetaData(statefulInvocation.getMetaData());
/* 892 */     newStatefulInvocation.setAdvisor(this);
/*     */ 
/* 894 */     return newStatefulInvocation;
/*     */   }
/*     */ 
/*     */   public Object getBusinessObject(BeanContext beanContext, Class businessInterface)
/*     */     throws IllegalStateException
/*     */   {
/* 900 */     assert (beanContext != null) : "beanContext is null";
/* 901 */     assert (businessInterface != null) : "businessInterface is null";
/*     */ 
/* 903 */     StatefulBeanContext ctx = (StatefulBeanContext)beanContext;
/*     */ 
/* 905 */     SessionContainer container = ctx.getContainer();
/* 906 */     assert (container == this) : ("beanContext not of this container (" + container + " != " + this + ")");
/*     */ 
/* 908 */     boolean isRemote = false;
/* 909 */     boolean found = false;
/* 910 */     Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this);
/* 911 */     for (Class intf : remoteInterfaces)
/*     */     {
/* 913 */       if (!intf.getName().equals(businessInterface.getName()))
/*     */         continue;
/* 915 */       isRemote = true;
/* 916 */       found = true;
/* 917 */       break;
/*     */     }
/*     */ 
/* 920 */     if (!found)
/*     */     {
/* 922 */       Class[] localInterfaces = ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(this);
/* 923 */       for (Class intf : localInterfaces)
/*     */       {
/* 925 */         if (!intf.getName().equals(businessInterface.getName()))
/*     */           continue;
/* 927 */         found = true;
/* 928 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 932 */     if (!found) throw new IllegalStateException(businessInterface.getName() + " is not a business interface for container " + this);
/*     */ 
/* 934 */     for (ProxyFactory factory : this.proxyDeployer.getProxyFactories())
/*     */     {
/* 936 */       if ((isRemote) && ((factory instanceof StatefulRemoteProxyFactory)))
/*     */       {
/* 938 */         return ((StatefulRemoteProxyFactory)factory).createProxy(ctx.getId());
/*     */       }
/* 940 */       if ((!isRemote) && ((factory instanceof StatefulLocalProxyFactory)))
/*     */       {
/* 942 */         return ((StatefulLocalProxyFactory)factory).createProxy(ctx.getId());
/*     */       }
/*     */     }
/* 945 */     throw new IllegalStateException("Unable to create proxy for getBusinessObject as a proxy factory was not found");
/*     */   }
/*     */ 
/*     */   protected void removeHandle(Handle arg)
/*     */     throws Exception
/*     */   {
/* 955 */     arg.getEJBObject().remove();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  81 */     log = Logger.getLogger(StatefulContainer.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulContainer
 * JD-Core Version:    0.6.0
 */