/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.Dispatcher;
/*     */ import org.jboss.aop.advice.AdviceStack;
/*     */ import org.jboss.aspects.remoting.FamilyWrapper;
/*     */ import org.jboss.aspects.remoting.Remoting;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.Clustered;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.ha.client.loadbalance.FirstAvailable;
/*     */ import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
/*     */ import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
/*     */ import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
/*     */ import org.jboss.ha.framework.interfaces.DistributedReplicantManager.ReplicantListener;
/*     */ import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
/*     */ import org.jboss.ha.framework.interfaces.HAPartition;
/*     */ import org.jboss.ha.framework.server.HATarget;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class StatefulClusterProxyFactory extends BaseStatefulProxyFactory
/*     */   implements RemoteProxyFactory, DistributedReplicantManager.ReplicantListener
/*     */ {
/*     */   private static final Logger log;
/*     */   private RemoteBinding binding;
/*     */   private Clustered clustered;
/*     */   private InvokerLocator locator;
/*     */   private DistributedReplicantManager drm;
/*     */   private HATarget hatarget;
/*     */   private String proxyFamilyName;
/*     */   private LoadBalancePolicy lbPolicy;
/*     */   private FamilyWrapper wrapper;
/*     */ 
/*     */   public StatefulClusterProxyFactory(SessionContainer container, RemoteBinding binding, Clustered clustered)
/*     */   {
/*  79 */     super(container, binding.jndiBinding());
/*     */ 
/*  81 */     assert (clustered != null) : "clustered is null";
/*     */ 
/*  83 */     this.binding = binding;
/*  84 */     this.clustered = clustered;
/*     */   }
/*     */ 
/*     */   protected Class[] getInterfaces()
/*     */   {
/*  89 */     Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(getContainer());
/*  90 */     Class[] interfaces = new Class[remoteInterfaces.length + 1];
/*  91 */     System.arraycopy(remoteInterfaces, 0, interfaces, 0, remoteInterfaces.length);
/*  92 */     interfaces[remoteInterfaces.length] = JBossProxy.class;
/*  93 */     return interfaces;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  98 */     String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
/*  99 */     this.locator = new InvokerLocator(clientBindUrl);
/* 100 */     String partitionName = ((SessionContainer)getContainer()).getPartitionName();
/* 101 */     this.proxyFamilyName = (((SessionContainer)getContainer()).getDeploymentQualifiedName() + this.locator.getProtocol() + partitionName);
/* 102 */     HAPartition partition = (HAPartition)getContainer().getInitialContext().lookup("/HAPartition/" + partitionName);
/* 103 */     this.hatarget = new HATarget(partition, this.proxyFamilyName, this.locator, 2);
/* 104 */     ClusteringTargetsRepository.initTarget(this.proxyFamilyName, this.hatarget.getReplicants());
/* 105 */     ((SessionContainer)getContainer()).getClusterFamilies().put(this.proxyFamilyName, this.hatarget);
/* 106 */     if ((this.clustered.loadBalancePolicy() == null) || (this.clustered.loadBalancePolicy().equals(LoadBalancePolicy.class)))
/*     */     {
/* 108 */       this.lbPolicy = new FirstAvailable();
/*     */     }
/*     */     else
/*     */     {
/* 112 */       this.lbPolicy = ((LoadBalancePolicy)this.clustered.loadBalancePolicy().newInstance());
/*     */     }
/* 114 */     this.wrapper = new FamilyWrapper(this.proxyFamilyName, this.hatarget.getReplicants());
/*     */ 
/* 116 */     this.drm = partition.getDistributedReplicantManager();
/* 117 */     this.drm.registerListener(this.proxyFamilyName, this);
/*     */ 
/* 119 */     super.start();
/*     */ 
/* 121 */     Class[] interfaces = { ProxyFactory.class };
/* 122 */     String targetId = getTargetId();
/* 123 */     Object factoryProxy = Remoting.createPojiProxy(targetId, interfaces, ProxyFactoryHelper.getClientBindUrl(this.binding));
/*     */     try
/*     */     {
/* 126 */       Util.rebind(getContainer().getInitialContext(), this.jndiName + "StatefulProxyFactory", factoryProxy);
/*     */     }
/*     */     catch (NamingException e) {
/* 129 */       NamingException namingException = new NamingException("Could not bind stateful cluster proxy with ejb name " + getContainer().getEjbName() + " into JNDI under jndiName: " + getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
/* 130 */       namingException.setRootCause(e);
/* 131 */       throw namingException;
/*     */     }
/* 133 */     assert (!Dispatcher.singleton.isRegistered(targetId)) : (targetId + " is already registered");
/* 134 */     Dispatcher.singleton.registerTarget(targetId, this);
/*     */   }
/*     */ 
/*     */   public Object createProxy()
/*     */   {
/* 140 */     String stackName = "ClusteredStatefulSessionClientInterceptors";
/* 141 */     if ((this.binding.interceptorStack() != null) && (!this.binding.interceptorStack().equals("")))
/*     */     {
/* 143 */       stackName = this.binding.interceptorStack();
/*     */     }
/* 145 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 146 */     String partitionName = ((SessionContainer)getContainer()).getPartitionName();
/* 147 */     return constructProxy(new StatefulClusteredProxy(getContainer(), stack.createInterceptors((Advisor)getContainer(), null), this.wrapper, this.lbPolicy, partitionName));
/*     */   }
/*     */ 
/*     */   public Object createProxy(Object id)
/*     */   {
/* 153 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 158 */     Dispatcher.singleton.unregisterTarget(getTargetId());
/* 159 */     this.hatarget.destroy();
/* 160 */     this.drm.unregisterListener(this.proxyFamilyName, this);
/* 161 */     ((SessionContainer)getContainer()).getClusterFamilies().remove(this.proxyFamilyName);
/* 162 */     Util.unbind(getContainer().getInitialContext(), this.jndiName + "StatefulProxyFactory");
/* 163 */     super.stop();
/*     */   }
/*     */ 
/*     */   protected StatefulHandleImpl getHandle()
/*     */   {
/* 168 */     StatefulHandleImpl handle = new StatefulHandleImpl();
/* 169 */     RemoteBinding remoteBinding = (RemoteBinding)((Advisor)getContainer()).resolveAnnotation(RemoteBinding.class);
/* 170 */     if (remoteBinding != null) {
/* 171 */       handle.jndiName = remoteBinding.jndiBinding();
/*     */     }
/* 173 */     return handle;
/*     */   }
/*     */ 
/*     */   protected String getTargetId()
/*     */   {
/* 181 */     assert (this.jndiName != null) : "jndiName is null";
/* 182 */     String partition = ((SessionContainer)getContainer()).getPartitionName();
/* 183 */     return this.jndiName + "StatefulProxyFactory" + "@" + partition;
/*     */   }
/*     */ 
/*     */   public synchronized void replicantsChanged(String key, List newReplicants, int newReplicantsViewId)
/*     */   {
/*     */     try
/*     */     {
/* 193 */       ArrayList targets = new ArrayList(newReplicants);
/* 194 */       this.wrapper.get().updateClusterInfo(targets, newReplicantsViewId);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 198 */       log.error(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  64 */     log = Logger.getLogger(StatefulClusterProxyFactory.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulClusterProxyFactory
 * JD-Core Version:    0.6.0
 */