/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.ejb3.Ejb3Registry;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ 
/*     */ public class NestedStatefulBeanContext extends StatefulBeanContext
/*     */   implements Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 7835719320529968045L;
/*     */ 
/*     */   public NestedStatefulBeanContext(SessionContainer container, Object bean)
/*     */   {
/*  55 */     super(container, bean);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out) throws IOException
/*     */   {
/*  60 */     out.writeUTF(Ejb3Registry.clusterUid(getContainer()));
/*  61 */     out.writeUTF(Ejb3Registry.guid(getContainer()));
/*  62 */     out.writeObject(this.id);
/*  63 */     out.writeBoolean(this.isClustered);
/*  64 */     out.writeObject(this.metadata);
/*  65 */     out.writeObject(this.bean);
/*  66 */     out.writeObject(this.persistenceContexts);
/*  67 */     out.writeObject(this.interceptorInstances);
/*  68 */     out.writeObject(this.contains);
/*     */ 
/*  71 */     out.writeBoolean(this.removed);
/*  72 */     out.writeBoolean(this.replicationIsPassivation);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/*  77 */     this.containerClusterUid = in.readUTF();
/*  78 */     this.containerGuid = in.readUTF();
/*  79 */     this.id = in.readObject();
/*  80 */     this.isClustered = in.readBoolean();
/*  81 */     this.metadata = ((SimpleMetaData)in.readObject());
/*  82 */     this.bean = in.readObject();
/*  83 */     this.persistenceContexts = ((HashMap)in.readObject());
/*  84 */     this.interceptorInstances = ((HashMap)in.readObject());
/*  85 */     this.contains = ((List)in.readObject());
/*  86 */     this.removed = in.readBoolean();
/*  87 */     this.replicationIsPassivation = in.readBoolean();
/*     */ 
/*  91 */     if (this.contains != null)
/*     */     {
/*  93 */       for (StatefulBeanContext contained : this.contains)
/*     */       {
/*  95 */         contained.containedIn = this;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 100 */     this.passivated = true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.NestedStatefulBeanContext
 * JD-Core Version:    0.6.0
 */