/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Proxy;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.JndiProxyFactory;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.session.BaseSessionProxyFactory;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.Util;
/*     */ 
/*     */ public abstract class BaseStatefulProxyFactory extends BaseSessionProxyFactory
/*     */   implements ProxyFactory
/*     */ {
/*     */   private static final Logger log;
/*     */   private Constructor proxyConstructor;
/*     */   protected String jndiName;
/*     */   public static final String PROXY_FACTORY_NAME = "StatefulProxyFactory";
/*     */ 
/*     */   protected BaseStatefulProxyFactory()
/*     */   {
/*     */   }
/*     */ 
/*     */   public BaseStatefulProxyFactory(SessionContainer container, String jndiName)
/*     */   {
/*  71 */     super(container);
/*     */ 
/*  73 */     assert (jndiName != null) : "jndiName is null";
/*     */ 
/*  75 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   protected Object constructProxy(InvocationHandler handler) {
/*     */     Throwable t;
/*     */     try {
/*  82 */       return this.proxyConstructor.newInstance(new Object[] { handler });
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/*  86 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/*  90 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/*  94 */       t = e.getTargetException();
/*  95 */       if ((t instanceof RuntimeException))
/*  96 */         throw ((RuntimeException)t); 
/*     */     }
/*  97 */     throw new RuntimeException(t);
/*     */   }
/*     */ 
/*     */   public void init()
/*     */     throws Exception
/*     */   {
/* 103 */     Class[] interfaces = getInterfaces();
/* 104 */     Class proxyClass = Proxy.getProxyClass(getContainer().getBeanClass().getClassLoader(), interfaces);
/* 105 */     this.proxyConstructor = proxyClass.getConstructor(new Class[] { InvocationHandler.class });
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 110 */     init();
/*     */ 
/* 112 */     Context ctx = getContainer().getInitialContext();
/* 113 */     Name name = ctx.getNameParser("").parse(this.jndiName);
/* 114 */     ctx = Util.createSubcontext(ctx, name.getPrefix(name.size() - 1));
/* 115 */     String atom = name.get(name.size() - 1);
/* 116 */     RefAddr refAddr = new StringRefAddr("FACTORY", this.jndiName + "StatefulProxyFactory");
/* 117 */     Reference ref = new Reference("java.lang.Object", refAddr, JndiProxyFactory.class.getName(), null);
/*     */     try
/*     */     {
/* 120 */       log.debug("Binding reference for " + getContainer().getEjbName() + " in JNDI at " + atom);
/* 121 */       Util.rebind(ctx, atom, ref);
/*     */     }
/*     */     catch (NamingException e) {
/* 124 */       NamingException namingException = new NamingException("Could not bind stateful proxy with ejb name " + getContainer().getEjbName() + " into JNDI under jndiName: " + ctx.getNameInNamespace() + "/" + atom);
/* 125 */       namingException.setRootCause(e);
/* 126 */       throw namingException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 132 */     Util.unbind(getContainer().getInitialContext(), this.jndiName);
/*     */   }
/*     */ 
/*     */   protected abstract Class<?>[] getInterfaces();
/*     */ 
/*     */   protected final void initializeJndiName() {
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
/* 142 */     super.readExternal(in);
/*     */     try
/*     */     {
/* 145 */       init();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 149 */       log.error(e.getMessage(), e);
/* 150 */       throw new IOException(e.getMessage());
/*     */     }
/* 152 */     this.jndiName = in.readUTF();
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 158 */     super.writeExternal(out);
/* 159 */     out.writeUTF(this.jndiName);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  52 */     log = Logger.getLogger(BaseStatefulProxyFactory.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.BaseStatefulProxyFactory
 * JD-Core Version:    0.6.0
 */