/*     */ package org.jboss.ejb3.session;
/*     */ 
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.SessionContext;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import org.jboss.ejb3.EJBContextImpl;
/*     */ import org.jboss.ejb3.stateless.StatelessBeanContext;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class SessionContextImpl extends EJBContextImpl<SessionContainer, SessionBeanContext>
/*     */   implements SessionContext
/*     */ {
/*  42 */   private static final Logger log = Logger.getLogger(SessionContextImpl.class);
/*     */ 
/*     */   public SessionContextImpl(SessionBeanContext beanContext)
/*     */   {
/*  46 */     super(beanContext);
/*     */   }
/*     */ 
/*     */   public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException
/*     */   {
/*  51 */     if (businessInterface == null) {
/*  52 */       throw new IllegalStateException("businessInterface is null");
/*     */     }
/*  54 */     return ((SessionContainer)this.container).getBusinessObject(this.beanContext, businessInterface);
/*     */   }
/*     */ 
/*     */   public EJBLocalObject getEJBLocalObject() throws IllegalStateException
/*     */   {
/*     */     try
/*     */     {
/*  61 */       Object id = ((SessionBeanContext)this.beanContext).getId();
/*  62 */       EJBLocalObject proxy = null;
/*     */       try
/*     */       {
/*  65 */         proxy = (EJBLocalObject)((SessionContainer)this.container).createLocalProxy(id);
/*     */       }
/*     */       catch (ClassCastException cce)
/*     */       {
/*  71 */         throw new IllegalStateException("EJB3 Specification Violation: " + ((SessionContainer)this.container).getBeanClassName() + " does not have a local interface; " + "EJB3 Spec 4.3.3 Bullet 12: Only session beans with a local EJBLocalObject interface " + "can call this method.");
/*     */       }
/*     */ 
/*  77 */       return proxy;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  81 */     throw new IllegalStateException(e);
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject()
/*     */     throws IllegalStateException
/*     */   {
/*     */     try
/*     */     {
/*  89 */       Object id = ((SessionBeanContext)this.beanContext).getId();
/*  90 */       EJBObject proxy = null;
/*     */       try
/*     */       {
/*  93 */         proxy = (EJBObject)((SessionContainer)this.container).createRemoteProxy(id);
/*     */       }
/*     */       catch (ClassCastException cce)
/*     */       {
/*  99 */         throw new IllegalStateException("EJB3 Specification Violation: " + ((SessionContainer)this.container).getBeanClassName() + " does not have a remote interface; " + "EJB3 Spec 4.3.3 Bullet 10: Only session beans with a remote EJBObject interface " + "can call this method.");
/*     */       }
/*     */ 
/* 104 */       return proxy;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 108 */     throw new IllegalStateException(e);
/*     */   }
/*     */ 
/*     */   public Class getInvokedBusinessInterface()
/*     */     throws IllegalStateException
/*     */   {
/* 114 */     return ((SessionContainer)this.container).getInvokedBusinessInterface();
/*     */   }
/*     */ 
/*     */   public MessageContext getMessageContext()
/*     */     throws IllegalStateException
/*     */   {
/* 120 */     if ((this.beanContext instanceof StatelessBeanContext))
/*     */     {
/* 122 */       MessageContext ctx = ((StatelessBeanContext)this.beanContext).getMessageContextJAXRPC();
/* 123 */       if (ctx == null)
/* 124 */         throw new IllegalStateException("No message context found");
/* 125 */       return ctx;
/*     */     }
/* 127 */     throw new UnsupportedOperationException("Only stateless beans can have a message context");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.session.SessionContextImpl
 * JD-Core Version:    0.6.0
 */