/*     */ package org.jboss.ejb3.service;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aspects.asynch.AsynchMixin;
/*     */ import org.jboss.aspects.asynch.AsynchProvider;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ import org.jboss.ejb3.remoting.BaseRemoteProxy;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class ServiceRemoteProxy extends BaseRemoteProxy
/*     */ {
/*     */   private static final long serialVersionUID = 306994045720155142L;
/*     */   protected InvokerLocator uri;
/*     */   AsynchProvider provider;
/*     */ 
/*     */   public ServiceRemoteProxy(Container container, Interceptor[] interceptors, InvokerLocator uri)
/*     */   {
/*  54 */     super(container, interceptors);
/*  55 */     this.uri = uri;
/*     */   }
/*     */ 
/*     */   public ServiceRemoteProxy(AsynchProvider provider, String containerId, String containerGuid, Interceptor[] interceptors, InvokerLocator uri)
/*     */   {
/*  60 */     super(containerId, containerGuid, interceptors);
/*  61 */     this.uri = uri;
/*  62 */     this.provider = provider;
/*     */   }
/*     */ 
/*     */   protected ServiceRemoteProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  73 */     if (method.getDeclaringClass() == AsynchProvider.class)
/*     */     {
/*  75 */       return this.provider.getFuture();
/*     */     }
/*     */ 
/*  78 */     long hash = MethodHashing.calculateHash(method);
/*  79 */     Object ret = ProxyUtils.handleCallLocally((JBossProxy)proxy, this, method, args);
/*  80 */     if (ret != null)
/*     */     {
/*  82 */       return ret;
/*     */     }
/*     */ 
/*  85 */     MethodInvocation sri = new MethodInvocation(this.interceptors, hash, method, method, null);
/*  86 */     sri.setArguments(args);
/*  87 */     sri.setInstanceResolver(this.metadata);
/*  88 */     sri.getMetaData().addMetaData("DISPATCHER", "OID", this.containerId, PayloadKey.AS_IS);
/*  89 */     sri.getMetaData().addMetaData("REMOTING", "INVOKER_LOCATOR", this.uri, PayloadKey.AS_IS);
/*  90 */     sri.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
/*  91 */     sri.getMetaData().addMetaData("IS_LOCAL", "GUID", this.containerGuid, PayloadKey.AS_IS);
/*     */ 
/*  94 */     if (this.provider != null)
/*     */     {
/*  96 */       sri.getMetaData().addMetaData("ASYNCH", "INVOKE_ASYNCH", "YES", PayloadKey.AS_IS);
/*     */     }
/*  98 */     return sri.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object getAsynchronousProxy(Object proxy)
/*     */   {
/* 103 */     Class[] infs = proxy.getClass().getInterfaces();
/* 104 */     if (!ProxyUtils.isAsynchronous(infs))
/*     */     {
/* 106 */       Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
/* 107 */       AsynchMixin mixin = new AsynchMixin();
/* 108 */       Interceptor[] newInterceptors = ProxyUtils.addAsynchProxyInterceptor(mixin, this.interceptors);
/* 109 */       ServiceRemoteProxy handler = new ServiceRemoteProxy(mixin, this.containerId, this.containerGuid, newInterceptors, this.uri);
/* 110 */       return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, handler);
/*     */     }
/*     */ 
/* 114 */     return proxy;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 120 */     return this.containerId.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.service.ServiceRemoteProxy
 * JD-Core Version:    0.6.0
 */