/*     */ package org.jboss.ejb3.service;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.StandardMBean;
/*     */ import javax.management.modelmbean.DescriptorSupport;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.modelmbean.XMBean;
/*     */ import org.jboss.mx.modelmbean.XMBeanConstants;
/*     */ import org.jboss.util.Classes;
/*     */ 
/*     */ public class ServiceMBeanDelegate
/*     */   implements DynamicMBean, XMBeanConstants
/*     */ {
/*  60 */   private static final Logger log = Logger.getLogger(ServiceMBeanDelegate.class);
/*     */   MBeanServer server;
/*     */   ServiceContainer container;
/*     */   ObjectName serviceOn;
/*     */   MBeanInfo mbeanInfo;
/*  67 */   HashMap<String, Method> getterMethods = new HashMap();
/*  68 */   HashSet<String> getterBlackList = new HashSet();
/*  69 */   HashMap<String, Method> setterMethods = new HashMap();
/*  70 */   HashSet<String> setterBlackList = new HashSet();
/*  71 */   HashMap<String, Method> operations = new HashMap();
/*  72 */   HashSet<String> operationBlackList = new HashSet();
/*     */ 
/*     */   public ServiceMBeanDelegate(MBeanServer server, ServiceContainer container, Class intf, ObjectName on)
/*     */   {
/*  76 */     this.container = container;
/*  77 */     this.server = server;
/*  78 */     this.serviceOn = on;
/*  79 */     StandardMBean mbean = null;
/*     */     try
/*     */     {
/*  82 */       mbean = new StandardMBean(container.getSingleton(), intf);
/*     */     }
/*     */     catch (NotCompliantMBeanException e)
/*     */     {
/*  86 */       throw new RuntimeException(e);
/*     */     }
/*  88 */     this.mbeanInfo = mbean.getMBeanInfo();
/*     */   }
/*     */ 
/*     */   public ServiceMBeanDelegate(MBeanServer server, ServiceContainer container, String xmbean, ObjectName on)
/*     */   {
/*  93 */     this.container = container;
/*  94 */     this.server = server;
/*  95 */     this.serviceOn = on;
/*  96 */     XMBean mbean = null;
/*     */     try
/*     */     {
/*  99 */       Descriptor descriptor = new DescriptorSupport();
/* 100 */       descriptor.setField("xmbean.resource.reference", container.getSingleton());
/* 101 */       descriptor.setField("xmbean.resource.type", xmbean);
/* 102 */       descriptor.setField("xmbean.metadata.sax.parser", "org.apache.crimson.parser.XMLReaderImpl");
/*     */ 
/* 104 */       mbean = new XMBean(descriptor, "descriptor");
/*     */     }
/*     */     catch (NotCompliantMBeanException e)
/*     */     {
/* 108 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (MBeanException e)
/*     */     {
/* 112 */       throw new RuntimeException(e);
/*     */     }
/* 114 */     this.mbeanInfo = mbean.getMetaData();
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/* 119 */     return this.serviceOn;
/*     */   }
/*     */ 
/*     */   public void register(ObjectName on, Class intf) throws Exception
/*     */   {
/* 124 */     this.server.registerMBean(this, this.serviceOn);
/*     */   }
/*     */ 
/*     */   public void unregister() throws Exception
/*     */   {
/* 129 */     this.server.unregisterMBean(this.serviceOn);
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String attribute)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 135 */     Method getter = getGetter(attribute);
/*     */     try
/*     */     {
/* 139 */       return this.container.localInvoke(getter, new Object[0]);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 143 */       if ((t instanceof Exception)) throw new MBeanException((Exception)t); 
/*     */     }
/* 144 */     throw new RuntimeException(t);
/*     */   }
/*     */ 
/*     */   public void setAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/* 151 */     Method setter = getSetter(attribute);
/*     */     try
/*     */     {
/* 154 */       this.container.localInvoke(setter, new Object[] { attribute.getValue() });
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 158 */       if ((t instanceof Exception)) throw new MBeanException((Exception)t);
/* 159 */       throw new RuntimeException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(String[] attributes)
/*     */   {
/* 165 */     AttributeList list = new AttributeList();
/*     */ 
/* 167 */     for (int i = 0; i < attributes.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 171 */         Object obj = getAttribute(attributes[i]);
/* 172 */         list.add(new Attribute(attributes[i], obj));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 176 */         throw new RuntimeException("Error reading attribute: " + attributes[i], e);
/*     */       }
/*     */     }
/* 179 */     return list;
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(AttributeList attributes)
/*     */   {
/* 184 */     for (Iterator it = attributes.iterator(); it.hasNext(); )
/*     */     {
/* 186 */       Attribute attribute = (Attribute)it.next();
/*     */       try
/*     */       {
/* 189 */         setAttribute(attribute);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 193 */         throw new RuntimeException("Error setting attribute: " + attribute, e);
/*     */       }
/*     */     }
/* 196 */     return attributes;
/*     */   }
/*     */ 
/*     */   public Object invoke(String actionName, Object[] params, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/* 202 */     if (log.isTraceEnabled()) {
/* 203 */       log.trace("invoke: " + actionName);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 214 */       Method operation = getOperation(actionName, signature);
/* 215 */       return this.container.localInvoke(operation, params);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 219 */       if ((t instanceof Exception)) throw new MBeanException((Exception)t); 
/*     */     }
/* 220 */     throw new RuntimeException(t);
/*     */   }
/*     */ 
/*     */   public MBeanInfo getMBeanInfo()
/*     */   {
/* 226 */     return this.mbeanInfo;
/*     */   }
/*     */ 
/*     */   private String getOperationSignature(String actionName, String[] types)
/*     */   {
/* 232 */     StringBuffer sig = new StringBuffer();
/* 233 */     sig.append(actionName);
/*     */ 
/* 235 */     if (types != null)
/*     */     {
/* 237 */       for (int i = 0; i < types.length; i++)
/*     */       {
/* 239 */         sig.append(" ");
/* 240 */         sig.append(types[i]);
/*     */       }
/*     */     }
/* 243 */     return sig.toString();
/*     */   }
/*     */ 
/*     */   private Method getGetter(String attribute) throws AttributeNotFoundException
/*     */   {
/* 248 */     Method getter = (Method)this.getterMethods.get(attribute);
/*     */ 
/* 250 */     if ((getter == null) && (!this.getterBlackList.contains(attribute)))
/*     */     {
/* 252 */       synchronized (this.getterMethods)
/*     */       {
/* 254 */         getter = (Method)this.getterMethods.get(attribute);
/* 255 */         if (getter == null)
/*     */         {
/*     */           try
/*     */           {
/* 259 */             MBeanAttributeInfo[] attrInfos = this.mbeanInfo.getAttributes();
/* 260 */             for (int i = 0; i < attrInfos.length; i++)
/*     */             {
/* 262 */               MBeanAttributeInfo attrInfo = attrInfos[i];
/* 263 */               if (!attrInfo.getName().equals(attribute))
/*     */                 continue;
/* 265 */               if (!attrInfo.isReadable())
/*     */               {
/* 267 */                 throw new AttributeNotFoundException("Attribute '" + attribute + "' is not writable in " + this.container.getBeanClass().getName());
/*     */               }
/*     */ 
/* 270 */               String getterName = (attrInfo.isIs() ? "is" : "get") + attribute;
/* 271 */               getter = this.container.getBeanClass().getMethod(getterName, new Class[0]);
/* 272 */               this.getterMethods.put(attribute, getter);
/*     */             }
/*     */ 
/* 276 */             if (getter == null)
/*     */             {
/* 278 */               throw new AttributeNotFoundException("No attribute called '" + attribute + "' in " + this.container.getBeanClass());
/*     */             }
/*     */           }
/*     */           catch (NoSuchMethodException e)
/*     */           {
/* 283 */             throw new AttributeNotFoundException("Could not find getter for attribute '" + attribute + "' on " + this.container.getBeanClass().getName());
/*     */           }
/*     */           finally
/*     */           {
/* 287 */             if (getter == null)
/*     */             {
/* 289 */               this.getterBlackList.add(attribute);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 296 */     return getter;
/*     */   }
/*     */ 
/*     */   private Method getSetter(Attribute attribute) throws AttributeNotFoundException
/*     */   {
/* 301 */     String attrName = attribute.getName();
/* 302 */     Method setter = (Method)this.setterMethods.get(attrName);
/*     */ 
/* 304 */     if ((setter == null) && (!this.setterBlackList.contains(attrName)))
/*     */     {
/* 306 */       synchronized (this.setterMethods)
/*     */       {
/* 308 */         setter = (Method)this.setterMethods.get(attrName);
/* 309 */         if (setter == null)
/*     */         {
/*     */           try
/*     */           {
/* 313 */             MBeanAttributeInfo[] attrInfos = this.mbeanInfo.getAttributes();
/* 314 */             for (int i = 0; i < attrInfos.length; i++)
/*     */             {
/* 316 */               MBeanAttributeInfo attrInfo = attrInfos[i];
/* 317 */               if (!attrInfo.getName().equals(attrName))
/*     */                 continue;
/* 319 */               if (!attrInfo.isWritable())
/*     */               {
/* 321 */                 throw new AttributeNotFoundException("Attribute '" + attrName + "' is not readable in " + this.container.getBeanClass().getName());
/*     */               }
/*     */ 
/* 324 */               String setterName = "set" + attrName;
/* 325 */               Class type = Classes.loadClass(attrInfo.getType());
/* 326 */               setter = this.container.getBeanClass().getMethod(setterName, new Class[] { type });
/* 327 */               this.setterMethods.put(attrName, setter);
/*     */             }
/*     */ 
/* 331 */             if (setter == null)
/*     */             {
/* 333 */               throw new AttributeNotFoundException("No attribute called '" + attribute + "' in " + this.container.getBeanClass());
/*     */             }
/*     */           }
/*     */           catch (ClassNotFoundException e)
/*     */           {
/* 338 */             throw new AttributeNotFoundException("Could not load setter type for attribute '" + attrName + "' on " + this.container.getBeanClass().getName());
/*     */           }
/*     */           catch (NoSuchMethodException e)
/*     */           {
/* 342 */             throw new AttributeNotFoundException("Could not find setter for attribute '" + attrName + "' on " + this.container.getBeanClass().getName());
/*     */           }
/*     */           finally
/*     */           {
/* 346 */             if (setter == null)
/*     */             {
/* 348 */               this.setterBlackList.add(attrName);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 355 */     return setter;
/*     */   }
/*     */ 
/*     */   private Method getOperation(String actionName, String[] signature) throws ReflectionException
/*     */   {
/* 360 */     String opSig = getOperationSignature(actionName, signature);
/* 361 */     Method operation = (Method)this.operations.get(actionName);
/*     */ 
/* 363 */     if ((operation == null) && (!this.setterBlackList.contains(opSig)))
/*     */     {
/* 365 */       synchronized (this.setterMethods)
/*     */       {
/* 367 */         operation = (Method)this.operations.get(opSig);
/* 368 */         if (operation == null)
/*     */         {
/*     */           try
/*     */           {
/* 372 */             MBeanOperationInfo[] opInfos = this.mbeanInfo.getOperations();
/* 373 */             for (int i = 0; i < opInfos.length; i++)
/*     */             {
/* 375 */               MBeanOperationInfo op = opInfos[i];
/* 376 */               if (!op.getName().equals(actionName))
/*     */                 continue;
/* 378 */               boolean match = true;
/* 379 */               MBeanParameterInfo[] sigTypes = op.getSignature();
/* 380 */               if (sigTypes.length == signature.length)
/*     */               {
/* 382 */                 for (int j = 0; j < sigTypes.length; j++)
/*     */                 {
/* 384 */                   if (sigTypes[j].getType().equals(signature[j]))
/*     */                     continue;
/* 386 */                   match = false;
/* 387 */                   break;
/*     */                 }
/*     */ 
/*     */               }
/*     */ 
/* 392 */               if (!match)
/*     */                 continue;
/* 394 */               Class[] types = null;
/* 395 */               if (signature.length > 0)
/*     */               {
/* 397 */                 types = new Class[signature.length];
/* 398 */                 for (int j = 0; j < signature.length; j++)
/*     */                 {
/* 400 */                   types[j] = Classes.loadClass(signature[j]);
/*     */                 }
/*     */               }
/*     */               else
/*     */               {
/* 405 */                 types = new Class[0];
/*     */               }
/* 407 */               operation = this.container.getBeanClass().getMethod(actionName, types);
/* 408 */               this.operations.put(opSig, operation);
/*     */             }
/*     */ 
/* 413 */             if (operation == null)
/*     */             {
/* 415 */               throw new RuntimeException("No operation called '" + actionName + "' in " + this.container.getBeanClass());
/*     */             }
/*     */ 
/*     */           }
/*     */           catch (ClassNotFoundException e)
/*     */           {
/* 421 */             throw new RuntimeException("Could not find  type for operation '" + actionName + "' on " + this.container.getBeanClass().getName());
/*     */           }
/*     */           catch (NoSuchMethodException e)
/*     */           {
/* 425 */             throw new RuntimeException("Could not find method for operation '" + actionName + "' on " + this.container.getBeanClass().getName());
/*     */           }
/*     */           finally
/*     */           {
/* 429 */             if (operation == null)
/*     */             {
/* 431 */               this.operationBlackList.add(opSig);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 438 */     return operation;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.service.ServiceMBeanDelegate
 * JD-Core Version:    0.6.0
 */