/*     */ package org.jboss.ejb3.service;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import org.jboss.aspects.asynch.AsynchMixin;
/*     */ import org.jboss.aspects.asynch.AsynchProvider;
/*     */ import org.jboss.aspects.asynch.FutureHolder;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.LocalProxy;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ 
/*     */ public class ServiceLocalProxy extends LocalProxy
/*     */ {
/*     */   private static final long serialVersionUID = -4023671606878355605L;
/*     */   AsynchProvider provider;
/*     */ 
/*     */   public ServiceLocalProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ServiceLocalProxy(Container container)
/*     */   {
/*  53 */     super(container);
/*     */   }
/*     */ 
/*     */   public ServiceLocalProxy(AsynchProvider provider, Container container)
/*     */   {
/*  58 */     super(container);
/*  59 */     this.provider = provider;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  65 */     if (method.getDeclaringClass() == AsynchProvider.class)
/*     */     {
/*  67 */       return this.provider.getFuture();
/*     */     }
/*     */ 
/*  70 */     Object ret = ProxyUtils.handleCallLocally((JBossProxy)proxy, this, method, args);
/*  71 */     if (ret != null)
/*     */     {
/*  73 */       return ret;
/*     */     }
/*     */ 
/*  76 */     ServiceContainer sc = (ServiceContainer)getContainer();
/*  77 */     return sc.localInvoke(method, args, (FutureHolder)this.provider);
/*     */   }
/*     */ 
/*     */   public Object getAsynchronousProxy(Object proxy)
/*     */   {
/*  82 */     Class[] infs = proxy.getClass().getInterfaces();
/*  83 */     if (!ProxyUtils.isAsynchronous(infs))
/*     */     {
/*  85 */       Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
/*  86 */       AsynchMixin mixin = new AsynchMixin();
/*  87 */       ServiceLocalProxy handler = new ServiceLocalProxy(mixin, getContainer());
/*  88 */       return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, handler);
/*     */     }
/*     */ 
/*  92 */     return proxy;
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  98 */     super.readExternal(in);
/*  99 */     this.provider = ((AsynchProvider)in.readObject());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 105 */     super.writeExternal(out);
/* 106 */     out.writeObject(this.provider);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 111 */     return this.proxyName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.service.ServiceLocalProxy
 * JD-Core Version:    0.6.0
 */