/*     */ package org.jboss.ejb3.service;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Hashtable;
/*     */ import java.util.List;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanRegistrationException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationResponse;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aspects.asynch.FutureHolder;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.ejb.AllowedOperationsFlags;
/*     */ import org.jboss.ejb3.BeanContext;
/*     */ import org.jboss.ejb3.EJBContainerInvocation;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.KernelAbstraction;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.annotation.LocalBinding;
/*     */ import org.jboss.ejb3.annotation.Management;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.annotation.Service;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*     */ import org.jboss.ejb3.interceptor.LifecycleInterceptorHandler;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.ejb3.statistics.InvocationStatistics;
/*     */ import org.jboss.ejb3.timerservice.TimedObjectInvoker;
/*     */ import org.jboss.ejb3.timerservice.TimerServiceFactory;
/*     */ import org.jboss.injection.Injector;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ 
/*     */ public class ServiceContainer extends SessionContainer
/*     */   implements TimedObjectInvoker
/*     */ {
/*     */   ServiceMBeanDelegate delegate;
/*     */   Object singleton;
/*     */   boolean injected;
/*     */   BeanContext beanContext;
/*     */   MBeanServer mbeanServer;
/*     */   ObjectName delegateObjectName;
/*     */   private TimerService timerService;
/*  84 */   private Object mbean = new ServiceDelegateWrapper(this);
/*     */   private static final Logger log;
/*     */ 
/*     */   public ServiceContainer(MBeanServer server, ClassLoader cl, String beanClassName, String ejbName, AspectManager manager, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment)
/*     */   {
/*  93 */     super(cl, beanClassName, ejbName, manager, ctxProperties, interceptorRepository, deployment);
/*  94 */     this.mbeanServer = server;
/*     */   }
/*     */ 
/*     */   public void callTimeout(Timer timer) throws Exception
/*     */   {
/*  99 */     Method timeout = this.callbackHandler.getTimeoutCallback();
/* 100 */     if (timeout == null) throw new EJBException("No method has been annotated with @Timeout");
/* 101 */     Object[] args = { timer };
/* 102 */     AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */     try
/*     */     {
/* 105 */       localInvoke(timeout, args);
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 109 */       if ((throwable instanceof Exception)) throw ((Exception)throwable);
/* 110 */       if ((throwable instanceof Error)) throw ((Error)throwable);
/* 111 */       throw new RuntimeException(throwable);
/*     */     }
/*     */     finally
/*     */     {
/* 115 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public BeanContext<?> createBeanContext()
/*     */   {
/* 122 */     return new ServiceBeanContext(this, this.singleton);
/*     */   }
/*     */ 
/*     */   protected ProxyFactory createProxyFactory(LocalBinding binding)
/*     */   {
/* 128 */     return new ServiceLocalProxyFactory(this, binding);
/*     */   }
/*     */ 
/*     */   protected RemoteProxyFactory createRemoteProxyFactory(RemoteBinding binding)
/*     */   {
/* 135 */     return new ServiceRemoteProxyFactory(this, binding);
/*     */   }
/*     */ 
/*     */   public Object createSession(Class[] initTypes, Object[] initArgs)
/*     */   {
/* 142 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   public Object getMBean()
/*     */   {
/* 147 */     return this.mbean;
/*     */   }
/*     */ 
/*     */   public Object getSingleton()
/*     */   {
/* 152 */     return this.singleton;
/*     */   }
/*     */ 
/*     */   public void create() throws Exception
/*     */   {
/* 157 */     super.create();
/*     */ 
/* 160 */     this.singleton = super.construct();
/*     */ 
/* 165 */     invokeOptionalMethod("create");
/*     */   }
/*     */ 
/*     */   protected List<Class<?>> resolveBusinessInterfaces()
/*     */   {
/* 171 */     List interfaces = super.resolveBusinessInterfaces();
/* 172 */     Management man = (Management)resolveAnnotation(Management.class);
/* 173 */     if (man != null)
/*     */     {
/* 175 */       Class iface = man.value();
/* 176 */       if (iface != null)
/*     */       {
/* 178 */         interfaces.add(iface);
/*     */       }
/*     */     }
/*     */ 
/* 182 */     Class[] implIfaces = getBeanClass().getInterfaces();
/* 183 */     for (Class iface : implIfaces)
/*     */     {
/* 185 */       if (iface.getAnnotation(Management.class) == null)
/*     */         continue;
/* 187 */       interfaces.add(iface);
/*     */     }
/*     */ 
/* 190 */     return interfaces;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 195 */     super.start();
/*     */     try
/*     */     {
/* 199 */       initBeanContext();
/*     */ 
/* 202 */       this.timerService = TimerServiceFactory.getInstance().createTimerService(this, this);
/*     */ 
/* 204 */       injectDependencies(this.beanContext);
/*     */ 
/* 207 */       registerManagementInterface();
/*     */ 
/* 209 */       TimerServiceFactory.getInstance().restoreTimerService(this.timerService);
/*     */ 
/* 211 */       invokeOptionalMethod("start");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 215 */       e.printStackTrace();
/* 216 */       stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 222 */     invokeOptionalMethod("stop");
/*     */ 
/* 224 */     if (this.timerService != null)
/*     */     {
/* 226 */       TimerServiceFactory.getInstance().removeTimerService(this.timerService);
/* 227 */       this.timerService = null;
/*     */     }
/*     */ 
/* 231 */     unregisterManagementInterface();
/*     */ 
/* 233 */     this.injected = false;
/*     */ 
/* 235 */     super.stop();
/*     */   }
/*     */ 
/*     */   public void destroy() throws Exception
/*     */   {
/* 240 */     invokeOptionalMethod("destroy");
/*     */ 
/* 244 */     super.destroy();
/*     */   }
/*     */ 
/*     */   public void initializePool() throws Exception
/*     */   {
/* 249 */     resolveInjectors();
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService()
/*     */   {
/* 254 */     return this.timerService;
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService(Object pKey)
/*     */   {
/* 259 */     assert (this.timerService != null) : "Timer Service not yet initialized";
/* 260 */     return this.timerService;
/*     */   }
/*     */ 
/*     */   private void invokeOptionalMethod(String methodName)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void invokePostConstruct(BeanContext beanContext, Object[] params)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void invokePreDestroy(BeanContext beanContext)
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object localInvoke(Object id, Method method, Object[] args, FutureHolder provider)
/*     */     throws Throwable
/*     */   {
/* 315 */     return localInvoke(method, args, provider);
/*     */   }
/*     */ 
/*     */   public Object localHomeInvoke(Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 321 */     return null;
/*     */   }
/*     */ 
/*     */   public Object localInvoke(Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 329 */     return localInvoke(method, args, null);
/*     */   }
/*     */ 
/*     */   public Object localInvoke(Method method, Object[] args, FutureHolder provider)
/*     */     throws Throwable
/*     */   {
/* 339 */     long start = System.currentTimeMillis();
/*     */ 
/* 341 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 344 */       this.invokeStats.callIn();
/*     */ 
/* 346 */       Thread.currentThread().setContextClassLoader(this.classloader);
/* 347 */       long hash = MethodHashing.calculateHash(method);
/* 348 */       MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
/* 349 */       if (info == null)
/*     */       {
/* 351 */         throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
/*     */       }
/* 353 */       EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info);
/* 354 */       nextInvocation.setAdvisor(this);
/* 355 */       nextInvocation.setArguments(args);
/*     */ 
/* 357 */       nextInvocation = populateInvocation(nextInvocation);
/*     */ 
/* 359 */       if (provider != null)
/*     */       {
/* 361 */         nextInvocation.getMetaData().addMetaData("ASYNCH", "INVOKE_ASYNCH", "YES", PayloadKey.AS_IS);
/* 362 */         nextInvocation.getMetaData().addMetaData("ASYNCH", "FUTURE_HOLDER", provider, PayloadKey.AS_IS);
/*     */       }
/* 364 */       Object localObject1 = nextInvocation.invokeNext();
/*     */       long end;
/*     */       long elapsed;
/*     */       return localObject1;
/*     */     }
/*     */     finally
/*     */     {
/* 368 */       if (method != null)
/*     */       {
/* 370 */         long end = System.currentTimeMillis();
/* 371 */         long elapsed = end - start;
/* 372 */         this.invokeStats.updateStats(method, elapsed);
/*     */       }
/*     */ 
/* 375 */       this.invokeStats.callOut();
/*     */ 
/* 377 */       Thread.currentThread().setContextClassLoader(oldLoader); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public InvocationResponse dynamicInvoke(Object target, Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 383 */     long start = System.currentTimeMillis();
/*     */ 
/* 385 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/* 386 */     EJBContainerInvocation newSi = null;
/*     */ 
/* 388 */     MethodInvocation si = (MethodInvocation)invocation;
/* 389 */     MethodInfo info = (MethodInfo)this.methodInterceptors.get(si.getMethodHash());
/* 390 */     Method method = info.getUnadvisedMethod();
/*     */     try
/*     */     {
/* 393 */       this.invokeStats.callIn();
/*     */ 
/* 395 */       Thread.currentThread().setContextClassLoader(this.classloader);
/*     */ 
/* 397 */       if (info == null)
/*     */       {
/* 399 */         throw new RuntimeException("Could not resolve beanClass method from proxy call");
/*     */       }
/* 401 */       newSi = new EJBContainerInvocation(info);
/* 402 */       newSi.setArguments(si.getArguments());
/* 403 */       newSi.setMetaData(si.getMetaData());
/* 404 */       newSi.setAdvisor(this);
/*     */ 
/* 406 */       newSi = populateInvocation(newSi);
/*     */ 
/* 408 */       Object rtn = null;
/*     */       try
/*     */       {
/* 411 */         rtn = newSi.invokeNext();
/*     */       }
/*     */       catch (Throwable throwable)
/*     */       {
/* 415 */         localInvocationResponse1 = marshallException(invocation, throwable, newSi.getResponseContextInfo());
/*     */ 
/* 423 */         if (method != null)
/*     */         {
/* 425 */           long end = System.currentTimeMillis();
/* 426 */           long elapsed = end - start;
/* 427 */           this.invokeStats.updateStats(method, elapsed);
/*     */         }
/*     */ 
/* 430 */         this.invokeStats.callOut();
/*     */ 
/* 432 */         Thread.currentThread().setContextClassLoader(oldLoader); return localInvocationResponse1;
/*     */       }
/* 417 */       InvocationResponse response = SessionContainer.marshallResponse(invocation, rtn, newSi.getResponseContextInfo());
/*     */ 
/* 419 */       InvocationResponse localInvocationResponse1 = response;
/*     */       long end;
/*     */       long elapsed;
/*     */       return localInvocationResponse1;
/*     */     }
/*     */     finally
/*     */     {
/* 423 */       if (method != null)
/*     */       {
/* 425 */         long end = System.currentTimeMillis();
/* 426 */         long elapsed = end - start;
/* 427 */         this.invokeStats.updateStats(method, elapsed);
/*     */       }
/*     */ 
/* 430 */       this.invokeStats.callOut();
/*     */ 
/* 432 */       Thread.currentThread().setContextClassLoader(oldLoader); } throw localObject1;
/*     */   }
/*     */ 
/*     */   protected void initBeanContext()
/*     */     throws RuntimeException
/*     */   {
/* 438 */     if (this.beanContext == null)
/*     */     {
/* 440 */       synchronized (this.singleton)
/*     */       {
/* 442 */         if (this.beanContext == null)
/*     */         {
/* 444 */           this.beanContext = createBeanContext();
/* 445 */           this.beanContext.initialiseInterceptorInstances();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public BeanContext<?> peekContext()
/*     */   {
/* 453 */     return this.beanContext;
/*     */   }
/*     */ 
/*     */   protected EJBContainerInvocation populateInvocation(EJBContainerInvocation invocation)
/*     */   {
/* 459 */     invocation.setTargetObject(this.singleton);
/* 460 */     invocation.setBeanContext(this.beanContext);
/* 461 */     return invocation;
/*     */   }
/*     */ 
/*     */   protected synchronized void injectDependencies(BeanContext ctx)
/*     */   {
/* 466 */     if (this.injectors != null)
/*     */     {
/*     */       try
/*     */       {
/* 470 */         pushEnc();
/* 471 */         for (Injector injector : this.injectors)
/*     */         {
/* 473 */           injector.inject(ctx);
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 478 */         popEnc();
/*     */       }
/*     */     }
/* 481 */     this.injected = true;
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String attribute)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 489 */     return this.delegate.getAttribute(attribute);
/*     */   }
/*     */ 
/*     */   public void setAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/* 495 */     this.delegate.setAttribute(attribute);
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(String[] attributes)
/*     */   {
/* 500 */     return this.delegate.getAttributes(attributes);
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(AttributeList attributes)
/*     */   {
/* 505 */     return this.delegate.setAttributes(attributes);
/*     */   }
/*     */ 
/*     */   public Object invoke(String actionName, Object[] params, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/* 511 */     return this.delegate.invoke(actionName, params, signature);
/*     */   }
/*     */ 
/*     */   protected Object invokeEJBObjectMethod(ProxyFactory factory, Object id, MethodInfo info, Object[] args)
/*     */     throws Exception
/*     */   {
/* 517 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   public MBeanInfo getMBeanInfo()
/*     */   {
/* 522 */     return this.delegate.getMBeanInfo();
/*     */   }
/*     */ 
/*     */   public Object createLocalProxy(Object id, LocalBinding binding) throws Exception
/*     */   {
/* 527 */     ServiceLocalProxyFactory factory = new ServiceLocalProxyFactory(this, binding);
/*     */ 
/* 529 */     return factory.createProxy(id);
/*     */   }
/*     */ 
/*     */   public Object createRemoteProxy(Object id, RemoteBinding binding) throws Exception
/*     */   {
/* 534 */     ServiceRemoteProxyFactory factory = new ServiceRemoteProxyFactory(this, binding);
/*     */ 
/* 536 */     return factory.createProxy(id);
/*     */   }
/*     */ 
/*     */   private void registerManagementInterface()
/*     */   {
/*     */     try
/*     */     {
/* 543 */       Management annotation = (Management)resolveAnnotation(Management.class);
/*     */ 
/* 545 */       Class intf = null;
/* 546 */       if (annotation != null) {
/* 547 */         intf = annotation.value();
/*     */       }
/* 549 */       if (intf == null)
/*     */       {
/* 551 */         Class[] interfaces = getBeanClass().getInterfaces();
/* 552 */         int interfaceIndex = 0;
/* 553 */         while ((intf == null) && (interfaceIndex < interfaces.length))
/*     */         {
/* 555 */           if (interfaces[interfaceIndex].getAnnotation(Management.class) != null) {
/* 556 */             intf = interfaces[interfaceIndex]; continue;
/*     */           }
/* 558 */           interfaceIndex++;
/*     */         }
/*     */       }
/*     */ 
/* 562 */       if (intf != null)
/*     */       {
/* 564 */         if (this.mbeanServer == null) {
/* 565 */           this.mbeanServer = MBeanServerLocator.locateJBoss();
/*     */         }
/* 567 */         if (this.mbeanServer == null) {
/* 568 */           throw new RuntimeException("There is a @Management interface on " + this.ejbName + " but the MBeanServer has not been initialized for it");
/*     */         }
/* 570 */         Service service = (Service)resolveAnnotation(Service.class);
/*     */ 
/* 572 */         String objname = service.objectName();
/* 573 */         this.delegateObjectName = ((objname == null) || (objname.equals("")) ? new ObjectName(getObjectName().getCanonicalName() + ",type=ManagementInterface") : new ObjectName(service.objectName()));
/*     */ 
/* 576 */         this.delegate = new ServiceMBeanDelegate(this.mbeanServer, this, intf, this.delegateObjectName);
/*     */ 
/* 578 */         getDeployment().getKernelAbstraction().installMBean(this.delegateObjectName, getDependencyPolicy(), this.delegate);
/*     */       }
/*     */       else
/*     */       {
/* 582 */         Service service = (Service)resolveAnnotation(Service.class);
/* 583 */         if (service.xmbean().length() > 0)
/*     */         {
/* 585 */           if (this.mbeanServer == null) {
/* 586 */             this.mbeanServer = MBeanServerLocator.locateJBoss();
/*     */           }
/* 588 */           if (this.mbeanServer == null) {
/* 589 */             throw new RuntimeException(this.ejbName + "is defined as an XMBean, but the MBeanServer has not been initialized for it");
/*     */           }
/* 591 */           String objname = service.objectName();
/* 592 */           this.delegateObjectName = ((objname == null) || (objname.equals("")) ? new ObjectName(getObjectName().getCanonicalName() + ",type=ManagementInterface") : new ObjectName(service.objectName()));
/*     */ 
/* 595 */           this.delegate = new ServiceMBeanDelegate(this.mbeanServer, this, service.xmbean(), this.delegateObjectName);
/*     */ 
/* 597 */           getDeployment().getKernelAbstraction().installMBean(this.delegateObjectName, getDependencyPolicy(), this.delegate);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 604 */       throw new RuntimeException("Problem registering @Management interface for @Service " + getBeanClass(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void unregisterManagementInterface() throws InstanceNotFoundException, MBeanRegistrationException
/*     */   {
/* 610 */     if (this.delegate != null)
/*     */     {
/* 612 */       getDeployment().getKernelAbstraction().uninstallMBean(this.delegateObjectName);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void removeHandle(Handle handle)
/*     */   {
/* 618 */     throw new RuntimeException("Don't do this");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  87 */     log = Logger.getLogger(ServiceContainer.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.service.ServiceContainer
 * JD-Core Version:    0.6.0
 */