/*    */ package org.jboss.ejb3.service;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ import java.lang.reflect.InvocationHandler;
/*    */ import java.lang.reflect.Proxy;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.ejb3.ProxyFactory;
/*    */ import org.jboss.naming.Util;
/*    */ 
/*    */ public abstract class BaseServiceProxyFactory
/*    */   implements ProxyFactory
/*    */ {
/*    */   protected Constructor<?> proxyConstructor;
/*    */   protected String jndiName;
/*    */   protected ServiceContainer container;
/*    */ 
/*    */   protected BaseServiceProxyFactory(ServiceContainer container, String jndiName)
/*    */   {
/* 45 */     assert (container != null) : "container is null";
/* 46 */     assert (jndiName != null) : "jndiName is null";
/*    */ 
/* 48 */     this.container = container;
/* 49 */     this.jndiName = jndiName;
/*    */   }
/*    */ 
/*    */   public Object createHomeProxy()
/*    */   {
/* 54 */     throw new UnsupportedOperationException("service can't have a home interface");
/*    */   }
/*    */ 
/*    */   public Object createProxy(Object id)
/*    */   {
/* 59 */     if (id != null)
/* 60 */       throw new IllegalArgumentException("service proxy must not have an id");
/* 61 */     return createProxy();
/*    */   }
/*    */ 
/*    */   public void start() throws Exception
/*    */   {
/* 66 */     Class[] interfaces = getInterfaces();
/* 67 */     Class proxyClass = Proxy.getProxyClass(this.container.getBeanClass().getClassLoader(), interfaces);
/* 68 */     this.proxyConstructor = proxyClass.getConstructor(new Class[] { InvocationHandler.class });
/*    */     try
/*    */     {
/* 72 */       Util.rebind(this.container.getInitialContext(), this.jndiName, createProxy());
/*    */     }
/*    */     catch (NamingException e) {
/* 75 */       NamingException namingException = new NamingException("Could not bind service proxy factory for EJB container with ejb name " + this.container.getEjbName() + " into JNDI under jndiName: " + this.container.getInitialContext().getNameInNamespace() + "/" + this.jndiName);
/* 76 */       namingException.setRootCause(e);
/* 77 */       throw namingException;
/*    */     }
/*    */   }
/*    */ 
/*    */   public void stop() throws Exception
/*    */   {
/* 83 */     Util.unbind(this.container.getInitialContext(), this.jndiName);
/*    */   }
/*    */ 
/*    */   protected abstract Class[] getInterfaces();
/*    */ 
/*    */   protected final void initializeJndiName()
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.service.BaseServiceProxyFactory
 * JD-Core Version:    0.6.0
 */