/*    */ package org.jboss.ejb3.security;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import javax.ejb.TimedObject;
/*    */ import javax.ejb.Timeout;
/*    */ import javax.ejb.Timer;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.ejb3.Container;
/*    */ import org.jboss.ejb3.EJBContainer;
/*    */ import org.jboss.ejb3.mdb.MessagingContainer;
/*    */ 
/*    */ public class SecurityHelper
/*    */ {
/*    */   public boolean isLocalCall(MethodInvocation mi)
/*    */   {
/* 53 */     return mi.getMetaData("IS_LOCAL", "IS_LOCAL") != null;
/*    */   }
/*    */ 
/*    */   public boolean isEJBTimeOutCallback(Method m)
/*    */   {
/* 64 */     Method ejbTimeout = null;
/*    */     try
/*    */     {
/* 69 */       ejbTimeout = TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class });
/*    */     }
/*    */     catch (NoSuchMethodException ignore)
/*    */     {
/*    */     }
/* 74 */     return m == ejbTimeout;
/*    */   }
/*    */ 
/*    */   public boolean containsTimeoutAnnotation(EJBContainer container, Method meth)
/*    */   {
/* 85 */     return (Timeout)container.resolveAnnotation(meth, Timeout.class) != null;
/*    */   }
/*    */ 
/*    */   public boolean isMDB(Container container)
/*    */   {
/* 95 */     return container instanceof MessagingContainer;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.SecurityHelper
 * JD-Core Version:    0.6.0
 */