/*     */ package org.jboss.ejb3.security;
/*     */ 
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.SecurityActions;
/*     */ import org.jboss.ejb3.annotation.SecurityDomain;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ public class RunAsSecurityInterceptorv2
/*     */   implements Interceptor
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(RunAsSecurityInterceptorv2.class);
/*     */   private RunAsIdentity runAsIdentity;
/*     */   private EJBContainer container;
/*     */ 
/*     */   public RunAsSecurityInterceptorv2(EJBContainer container, RunAsIdentity id)
/*     */   {
/*  50 */     this.runAsIdentity = id;
/*  51 */     this.container = container;
/*     */   }
/*     */ 
/*     */   protected RunAsIdentity getRunAsIdentity(Invocation invocation)
/*     */   {
/*  56 */     MethodInvocation mi = (MethodInvocation)invocation;
/*  57 */     return this.runAsIdentity;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  92 */     SecurityHelper shelper = new SecurityHelper();
/*  93 */     if (shelper.isEJBTimeOutCallback(((MethodInvocation)invocation).getMethod())) {
/*  94 */       return invocation.invokeNext();
/*     */     }
/*  96 */     SecurityContext sc = SecurityActions.getSecurityContext();
/*     */     SecurityDomain domain;
/* 102 */     if (sc == null)
/*     */     {
/* 104 */       domain = (SecurityDomain)this.container.resolveAnnotation(SecurityDomain.class);
/* 105 */       if (domain != null)
/*     */       {
/* 107 */         sc = SecurityActions.createSecurityContext(domain.value());
/* 108 */         SecurityContextAssociation.setSecurityContext(sc);
/*     */       }
/*     */     }
/*     */ 
/* 112 */     if (sc != null)
/*     */     {
/* 114 */       sc.setOutgoingRunAs(this.runAsIdentity);
/*     */     }
/*     */     try
/*     */     {
/* 118 */       domain = invocation.invokeNext();
/*     */     }
/*     */     finally
/*     */     {
/* 122 */       if (sc != null)
/* 123 */         SecurityActions.popRunAs();
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 130 */     return getClass().getName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.RunAsSecurityInterceptorv2
 * JD-Core Version:    0.6.0
 */