/*     */ package org.jboss.ejb3.security;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.annotation.security.RunAs;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.advice.AspectFactory;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.annotation.SecurityDomain;
/*     */ import org.jboss.ejb3.tx.NullInterceptor;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ 
/*     */ public class RunAsSecurityInterceptorFactory extends PerClassAspectFactoryAdaptor
/*     */   implements AspectFactory
/*     */ {
/*  53 */   private static final Logger log = Logger.getLogger(RunAsSecurityInterceptorFactory.class);
/*     */ 
/*     */   protected RunAsIdentity getRunAsIdentity(EJBContainer container)
/*     */   {
/*  57 */     RunAs runAs = (RunAs)container.resolveAnnotation(RunAs.class);
/*  58 */     if (runAs == null) {
/*  59 */       return null;
/*     */     }
/*  61 */     String runAsPrincipal = runAs.value();
/*  62 */     Set extraRoles = new HashSet();
/*     */ 
/*  64 */     JBossAssemblyDescriptorMetaData ad = container.getAssemblyDescriptor();
/*  65 */     if ((ad != null) && (runAsPrincipal != null))
/*     */     {
/*  67 */       extraRoles.addAll(ad.getSecurityRoleNamesByPrincipal(runAsPrincipal));
/*     */     }
/*     */ 
/*  70 */     return new RunAsIdentity(runAs.value(), runAsPrincipal, extraRoles);
/*     */   }
/*     */ 
/*     */   public Object createPerClass(Advisor advisor)
/*     */   {
/*  76 */     EJBContainer container = (EJBContainer)advisor;
/*  77 */     RunAsIdentity runAsIdentity = getRunAsIdentity(container);
/*     */ 
/*  83 */     Object domain = null;
/*     */     try
/*     */     {
/*  86 */       InitialContext ctx = container.getInitialContext();
/*  87 */       SecurityDomain securityDomain = (SecurityDomain)advisor.resolveAnnotation(SecurityDomain.class);
/*  88 */       if (securityDomain != null)
/*     */       {
/*  90 */         String domainName = securityDomain.value();
/*  91 */         domain = SecurityDomainManager.getSecurityManager(domainName, ctx);
/*     */       }
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/*  96 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/*  99 */     Interceptor interceptor = new NullInterceptor();
/* 100 */     if (domain != null)
/*     */     {
/* 102 */       AuthenticationManager manager = (AuthenticationManager)domain;
/* 103 */       RealmMapping mapping = (RealmMapping)domain;
/*     */ 
/* 106 */       interceptor = new RunAsSecurityInterceptorv2(container, getRunAsIdentity(container));
/*     */     }
/* 108 */     return interceptor;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.RunAsSecurityInterceptorFactory
 * JD-Core Version:    0.6.0
 */