/*    */ package org.jboss.ejb3.security;
/*    */ 
/*    */ import java.util.HashSet;
/*    */ import java.util.Set;
/*    */ import javax.security.auth.Subject;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.ejb3.SecurityActions;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.security.AuthenticationManager;
/*    */ import org.jboss.security.RealmMapping;
/*    */ import org.jboss.security.RunAsIdentity;
/*    */ import org.jboss.security.SecurityAssociation;
/*    */ 
/*    */ public class RunAsSecurityInterceptor extends org.jboss.aspects.security.RunAsSecurityInterceptor
/*    */ {
/* 43 */   private static final Logger log = Logger.getLogger(RunAsSecurityInterceptor.class);
/*    */   private RunAsIdentity runAsIdentity;
/*    */ 
/*    */   public RunAsSecurityInterceptor(AuthenticationManager manager, RealmMapping realmMapping, RunAsIdentity id)
/*    */   {
/* 48 */     super(manager, realmMapping);
/* 49 */     this.runAsIdentity = id;
/*    */   }
/*    */ 
/*    */   protected RunAsIdentity getRunAsIdentity(Invocation invocation)
/*    */   {
/* 54 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 55 */     return this.runAsIdentity;
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 60 */     Subject previousSubject = null;
/*    */     try
/*    */     {
/* 63 */       RunAsIdentity runAsIdentity = getRunAsIdentity(invocation);
/* 64 */       SecurityActions.pushRunAsIdentity(runAsIdentity);
/*    */ 
/* 66 */       runAsIdentity = SecurityActions.peekRunAsIdentity(1);
/* 67 */       if (runAsIdentity != null)
/*    */       {
/* 69 */         previousSubject = SecurityActions.getActiveSubject();
/* 70 */         newPrincipals = runAsIdentity.getPrincipalsSet();
/* 71 */         Subject newSubject = new Subject(false, newPrincipals, new HashSet(), new HashSet());
/* 72 */         SecurityAssociation.setSubject(newSubject);
/*    */       }
/*    */ 
/* 75 */       newPrincipals = invocation.invokeNext();
/*    */     }
/*    */     finally
/*    */     {
/*    */       Set newPrincipals;
/* 79 */       if (previousSubject != null) {
/* 80 */         SecurityAssociation.setSubject(previousSubject);
/*    */       }
/* 82 */       SecurityActions.popRunAsIdentity();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.RunAsSecurityInterceptor
 * JD-Core Version:    0.6.0
 */