/*     */ package org.jboss.ejb3.security;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.CodeSource;
/*     */ import java.security.Principal;
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.annotation.security.DenyAll;
/*     */ import javax.annotation.security.PermitAll;
/*     */ import javax.annotation.security.RolesAllowed;
/*     */ import javax.ejb.EJBAccessException;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.annotation.SecurityDomain;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.security.AnybodyPrincipal;
/*     */ import org.jboss.security.NobodyPrincipal;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.SecurityRolesAssociation;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.jboss.security.integration.ejb.EJBAuthorizationHelper;
/*     */ 
/*     */ public final class RoleBasedAuthorizationInterceptorv2
/*     */   implements Interceptor
/*     */ {
/*  65 */   private static final Logger log = Logger.getLogger(RoleBasedAuthorizationInterceptorv2.class);
/*     */   private EJBContainer container;
/*     */   private CodeSource ejbCS;
/*     */   private String ejbName;
/*     */ 
/*     */   public RoleBasedAuthorizationInterceptorv2(Container container, CodeSource ejbCS, String ejbName)
/*     */   {
/*  76 */     this.container = ((EJBContainer)container);
/*  77 */     this.ejbCS = ejbCS;
/*  78 */     this.ejbName = ejbName;
/*     */   }
/*     */ 
/*     */   protected Set<Principal> getRoleSet(Invocation invocation)
/*     */   {
/*  83 */     Method method = ((MethodInvocation)invocation).getActualMethod();
/*     */ 
/*  85 */     Class[] classes = { DenyAll.class, PermitAll.class, RolesAllowed.class };
/*     */ 
/*  87 */     Object annotation = this.container.resolveAnnotation(method, classes);
/*     */ 
/*  89 */     int classIndex = 0;
/*  90 */     while ((annotation == null) && (classIndex < 3))
/*     */     {
/*  92 */       annotation = this.container.resolveAnnotation(classes[(classIndex++)]);
/*     */     }
/*     */ 
/*  95 */     HashSet set = new HashSet();
/*  96 */     if (annotation != null)
/*     */     {
/*  98 */       if ((annotation instanceof DenyAll))
/*     */       {
/* 100 */         set.add(NobodyPrincipal.NOBODY_PRINCIPAL);
/*     */       }
/* 102 */       else if ((annotation instanceof PermitAll))
/*     */       {
/* 104 */         set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/*     */       }
/* 106 */       else if ((annotation instanceof RolesAllowed))
/*     */       {
/* 108 */         RolesAllowed permissions = (RolesAllowed)annotation;
/* 109 */         for (int i = 0; i < permissions.value().length; i++)
/*     */         {
/* 111 */           set.add(new SimplePrincipal(permissions.value()[i]));
/*     */         }
/*     */       }
/*     */       else {
/* 115 */         set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/*     */       }
/*     */     }
/* 118 */     else set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/*     */ 
/* 120 */     return set;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/* 125 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 127 */     SecurityHelper shelper = new SecurityHelper();
/* 128 */     Method method = mi.getMethod();
/* 129 */     if ((shelper.isEJBTimeOutCallback(method)) || (shelper.containsTimeoutAnnotation(this.container, method)) || (shelper.isMDB(this.container)))
/*     */     {
/* 132 */       return invocation.invokeNext();
/*     */     }
/*     */     try
/*     */     {
/* 136 */       SecurityDomain domain = (SecurityDomain)this.container.resolveAnnotation(SecurityDomain.class);
/*     */ 
/* 138 */       boolean domainExists = (domain != null) && (domain.value() != null) && (domain.value().length() > 0);
/*     */ 
/* 141 */       if (domainExists)
/*     */       {
/* 143 */         sc = SecurityActions.getSecurityContext();
/* 144 */         if (sc == null)
/* 145 */           throw new IllegalStateException("Security Context has not been set");
/* 146 */         Set methodRoles = getRoleSet(invocation);
/* 147 */         if (methodRoles == null)
/*     */         {
/* 155 */           String message = "No method permissions assigned.";
/* 156 */           log.error(message);
/* 157 */           throw new SecurityException(message);
/*     */         }
/*     */ 
/* 161 */         JBossAssemblyDescriptorMetaData jmd = this.container.getAssemblyDescriptor();
/* 162 */         if (jmd != null)
/*     */         {
/* 164 */           Map principalRoleMap = jmd.getPrincipalVersusRolesMap();
/* 165 */           SecurityRolesAssociation.setSecurityRoles(principalRoleMap);
/*     */         }
/* 167 */         InvokerLocator locator = (InvokerLocator)invocation.getMetaData("REMOTING", "INVOKER_LOCATOR");
/*     */ 
/* 170 */         String iface = locator != null ? "Remote" : "Local";
/*     */ 
/* 172 */         RunAsIdentity callerRunAs = SecurityActions.peekRunAsIdentity();
/*     */ 
/* 174 */         EJBAuthorizationHelper helper = new EJBAuthorizationHelper(sc);
/* 175 */         boolean isAuthorized = helper.authorize(this.ejbName, mi.getMethod(), sc.getUtil().getUserPrincipal(), iface, this.ejbCS, sc.getUtil().getSubject(), callerRunAs, methodRoles);
/*     */ 
/* 183 */         if (!isAuthorized)
/* 184 */           throw new EJBAccessException("Caller unauthorized");
/*     */       }
/* 186 */       sc = invocation.invokeNext();
/*     */     }
/*     */     catch (SecurityException throwable)
/*     */     {
/*     */       SecurityContext sc;
/* 190 */       log.debug("Authorization failure", throwable);
/* 191 */       throw new EJBAccessException("Authorization failure");
/*     */     }
/*     */     finally {
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getName() {
/* 198 */     return getClass().getName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.RoleBasedAuthorizationInterceptorv2
 * JD-Core Version:    0.6.0
 */