/*    */ package org.jboss.ejb3.security;
/*    */ 
/*    */ import java.security.CodeSource;
/*    */ import java.security.ProtectionDomain;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.advice.AspectFactory;
/*    */ import org.jboss.ejb3.Container;
/*    */ import org.jboss.ejb3.EJBContainer;
/*    */ import org.jboss.ejb3.annotation.SecurityDomain;
/*    */ import org.jboss.security.AuthenticationManager;
/*    */ import org.jboss.security.RealmMapping;
/*    */ 
/*    */ public class RoleBasedAuthorizationInterceptorFactory extends PerClassAspectFactoryAdaptor
/*    */   implements AspectFactory
/*    */ {
/*    */   public Object createPerClass(Advisor advisor)
/*    */   {
/* 50 */     Object domain = null;
/* 51 */     Container container = (Container)advisor;
/*    */     try
/*    */     {
/* 54 */       InitialContext ctx = container.getInitialContext();
/* 55 */       SecurityDomain securityAnnotation = (SecurityDomain)advisor.resolveAnnotation(SecurityDomain.class);
/*    */ 
/* 58 */       if (securityAnnotation == null) {
/* 59 */         return new NullInterceptor();
/*    */       }
/* 61 */       domain = SecurityDomainManager.getSecurityManager(securityAnnotation.value(), ctx);
/*    */     }
/*    */     catch (NamingException e)
/*    */     {
/* 65 */       throw new RuntimeException(e);
/*    */     }
/* 67 */     AuthenticationManager manager = (AuthenticationManager)domain;
/* 68 */     RealmMapping mapping = (RealmMapping)domain;
/* 69 */     if (manager == null) throw new RuntimeException("Unable to find Security Domain");
/*    */ 
/* 71 */     CodeSource ejbCS = advisor.getClazz().getProtectionDomain().getCodeSource();
/* 72 */     String ejbName = ((EJBContainer)advisor).getEjbName();
/* 73 */     return new RoleBasedAuthorizationInterceptorv2(container, ejbCS, ejbName);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.RoleBasedAuthorizationInterceptorFactory
 * JD-Core Version:    0.6.0
 */