/*     */ package org.jboss.ejb3.security;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.annotation.security.DenyAll;
/*     */ import javax.annotation.security.PermitAll;
/*     */ import javax.annotation.security.RolesAllowed;
/*     */ import javax.ejb.EJBAccessException;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AnybodyPrincipal;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.NobodyPrincipal;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public final class RoleBasedAuthorizationInterceptor extends org.jboss.aspects.security.RoleBasedAuthorizationInterceptor
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(RoleBasedAuthorizationInterceptor.class);
/*     */   private EJBContainer container;
/*     */ 
/*     */   public RoleBasedAuthorizationInterceptor(AuthenticationManager manager, RealmMapping realmMapping, Container container)
/*     */   {
/*  58 */     super(manager, realmMapping);
/*  59 */     this.container = ((EJBContainer)container);
/*     */   }
/*     */ 
/*     */   protected Set getRoleSet(Invocation invocation)
/*     */   {
/*  64 */     Method method = ((MethodInvocation)invocation).getActualMethod();
/*     */ 
/*  66 */     Class[] classes = { DenyAll.class, PermitAll.class, RolesAllowed.class };
/*     */ 
/*  68 */     Object annotation = this.container.resolveAnnotation(method, classes);
/*     */ 
/*  70 */     int classIndex = 0;
/*  71 */     while ((annotation == null) && (classIndex < 3))
/*     */     {
/*  73 */       annotation = this.container.resolveAnnotation(classes[(classIndex++)]);
/*     */     }
/*     */ 
/*  76 */     HashSet set = new HashSet();
/*  77 */     if (annotation != null)
/*     */     {
/*  79 */       if ((annotation instanceof DenyAll))
/*     */       {
/*  81 */         set.add(NobodyPrincipal.NOBODY_PRINCIPAL);
/*     */       }
/*  83 */       else if ((annotation instanceof PermitAll))
/*     */       {
/*  85 */         set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/*     */       }
/*  87 */       else if ((annotation instanceof RolesAllowed))
/*     */       {
/*  89 */         RolesAllowed permissions = (RolesAllowed)annotation;
/*  90 */         for (int i = 0; i < permissions.value().length; i++)
/*     */         {
/*  92 */           set.add(new SimplePrincipal(permissions.value()[i]));
/*     */         }
/*     */       }
/*     */       else {
/*  96 */         set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/*     */       }
/*     */     }
/*  99 */     else set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
/*     */ 
/* 101 */     return set;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/*     */     try
/*     */     {
/* 108 */       localObject1 = super.invoke(invocation);
/*     */     }
/*     */     catch (SecurityException throwable)
/*     */     {
/*     */       Object localObject1;
/* 112 */       log.debug("Authorization failure", throwable);
/* 113 */       throw new EJBAccessException("Authorization failure");
/*     */     }
/*     */     finally
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.RoleBasedAuthorizationInterceptor
 * JD-Core Version:    0.6.0
 */