/*     */ package org.jboss.ejb3.security;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.CodeSource;
/*     */ import javax.security.jacc.EJBMethodPermission;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.jacc.DelegatingPolicy;
/*     */ 
/*     */ public class JaccAuthorizationInterceptor
/*     */   implements Interceptor
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(JaccAuthorizationInterceptor.class);
/*     */   public static final String JACC = "JACC";
/*     */   public static final String CTX = "ctx";
/*     */   private String ejbName;
/*     */   private CodeSource ejbCS;
/*     */   private RealmMapping realmMapping;
/*     */ 
/*     */   public JaccAuthorizationInterceptor(String ejbName, CodeSource cs)
/*     */   {
/*  56 */     this.ejbName = ejbName;
/*  57 */     this.ejbCS = cs;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  62 */     return "JaccAuthorizationInterceptor";
/*     */   }
/*     */ 
/*     */   public void setRealmMapping(RealmMapping ssm)
/*     */   {
/*  67 */     this.realmMapping = ssm;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation inv) throws Throwable
/*     */   {
/*     */     try
/*     */     {
/*  74 */       checkSecurityAssociation((MethodInvocation)inv);
/*  75 */       return inv.invokeNext();
/*     */     }
/*     */     catch (ClassCastException e) {
/*     */     }
/*  79 */     throw new RuntimeException("Jacc authorization is only available for method invocations", e);
/*     */   }
/*     */ 
/*     */   private void checkSecurityAssociation(MethodInvocation mi)
/*     */     throws Throwable
/*     */   {
/*  88 */     String contextID = (String)mi.getMetaData("JACC", "ctx");
/*  89 */     SecurityActions.setContextID(contextID);
/*     */ 
/*  91 */     if (log.isTraceEnabled()) {
/*  92 */       log.trace("permissions: " + DelegatingPolicy.getInstance().getPermissions(this.ejbCS));
/*     */     }
/*     */ 
/*  99 */     Method m = mi.getMethod();
/*     */ 
/* 101 */     SecurityHelper shelper = new SecurityHelper();
/*     */ 
/* 103 */     String iface = !shelper.isLocalCall(mi) ? "Remote" : "Local";
/*     */ 
/* 105 */     EJBMethodPermission methodPerm = new EJBMethodPermission(this.ejbName, iface, m);
/* 106 */     if (this.realmMapping != null)
/*     */     {
/* 108 */       JaccHelper.checkPermission(this.ejbCS, methodPerm, this.realmMapping);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.JaccAuthorizationInterceptor
 * JD-Core Version:    0.6.0
 */