/*     */ package org.jboss.ejb3.security;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.security.SecurityPermission;
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyConfigurationFactory;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class Ejb3PolicyConfigurationFactory
/*     */ {
/*  27 */   private static final Logger log = Logger.getLogger(Ejb3PolicyConfigurationFactory.class);
/*     */   private static final String FACTORY_PROP = "javax.security.jacc.PolicyConfigurationFactory.provider";
/*     */   private static final String DEFAULT_FACTORY_NAME = "org.jboss.security.jacc.JBossPolicyConfigurationFactory";
/*     */   private static PolicyConfigurationFactory factory;
/*     */ 
/*     */   public static PolicyConfigurationFactory getPolicyConfigurationFactory()
/*     */     throws ClassNotFoundException, PolicyContextException
/*     */   {
/*  60 */     SecurityManager sm = System.getSecurityManager();
/*  61 */     if (sm != null) {
/*  62 */       sm.checkPermission(new SecurityPermission("setPolicy"));
/*     */     }
/*  64 */     if (factory == null)
/*     */     {
/*  66 */       String factoryName = null;
/*  67 */       Class clazz = null;
/*     */       try
/*     */       {
/*  70 */         LoadAction action = new LoadAction(null);
/*     */         try
/*     */         {
/*  73 */           clazz = (Class)AccessController.doPrivileged(action);
/*  74 */           factoryName = action.getName();
/*     */         }
/*     */         catch (PrivilegedActionException ex)
/*     */         {
/*  78 */           ex.printStackTrace();
/*  79 */           factoryName = action.getName();
/*  80 */           Exception e = ex.getException();
/*  81 */           if ((e instanceof ClassNotFoundException)) {
/*  82 */             throw ((ClassNotFoundException)e);
/*     */           }
/*  84 */           throw new PolicyContextException("Failure during load of class: " + action.getName(), e);
/*     */         }
/*     */ 
/*  87 */         factory = (PolicyConfigurationFactory)clazz.newInstance();
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/*  91 */         String msg = "Failed to find PolicyConfigurationFactory : " + factoryName;
/*  92 */         throw new ClassNotFoundException(msg, e);
/*     */       }
/*     */       catch (IllegalAccessException e)
/*     */       {
/*  96 */         String msg = "Unable to access class : " + factoryName;
/*  97 */         throw new PolicyContextException(msg, e);
/*     */       }
/*     */       catch (InstantiationException e)
/*     */       {
/* 101 */         String msg = "Failed to create instance of: " + factoryName;
/* 102 */         throw new PolicyContextException(msg, e);
/*     */       }
/*     */       catch (ClassCastException e)
/*     */       {
/* 106 */         StringBuffer msg = new StringBuffer(factoryName + " Is not a PolicyConfigurationFactory, ");
/* 107 */         msg.append("PCF.class.CL: " + Ejb3PolicyConfigurationFactory.class.getClassLoader());
/* 108 */         msg.append("\nPCF.class.CS: " + Ejb3PolicyConfigurationFactory.class.getProtectionDomain().getCodeSource());
/* 109 */         msg.append("\nPCF.class.hash: " + System.identityHashCode(Ejb3PolicyConfigurationFactory.class));
/* 110 */         msg.append("\nclazz.CL: " + clazz.getClassLoader());
/* 111 */         msg.append("\nclazz.CS: " + clazz.getProtectionDomain().getCodeSource());
/* 112 */         msg.append("\nclazz.super.CL: " + clazz.getSuperclass().getClassLoader());
/* 113 */         msg.append("\nclazz.super.CS: " + clazz.getSuperclass().getProtectionDomain().getCodeSource());
/* 114 */         msg.append("\nclazz.super.hash: " + System.identityHashCode(clazz.getSuperclass()));
/* 115 */         ClassCastException cce = new ClassCastException(msg.toString());
/* 116 */         cce.initCause(e);
/*     */       }
/*     */     }
/* 119 */     return factory;
/*     */   }
/*     */ 
/*     */   public abstract PolicyConfiguration getPolicyConfiguration(String paramString, boolean paramBoolean)
/*     */     throws PolicyContextException;
/*     */ 
/*     */   public abstract boolean inService(String paramString)
/*     */     throws PolicyContextException;
/*     */ 
/*     */   private static class LoadAction
/*     */     implements PrivilegedExceptionAction
/*     */   {
/*     */     private String name;
/*     */ 
/*     */     public String getName()
/*     */     {
/* 179 */       return this.name;
/*     */     }
/*     */ 
/*     */     public Object run() throws Exception
/*     */     {
/* 184 */       this.name = System.getProperty("javax.security.jacc.PolicyConfigurationFactory.provider");
/* 185 */       if (this.name == null)
/*     */       {
/* 188 */         this.name = "org.jboss.security.jacc.JBossPolicyConfigurationFactory";
/*     */       }
/* 190 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 191 */       Class factoryClass = loader.loadClass(this.name);
/* 192 */       return factoryClass;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.Ejb3PolicyConfigurationFactory
 * JD-Core Version:    0.6.0
 */