/*     */ package org.jboss.ejb3.security;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import javax.ejb.EJBAccessException;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.annotation.SecurityDomain;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.SecurityIdentity;
/*     */ import org.jboss.security.SecurityUtil;
/*     */ import org.jboss.security.integration.JNDIBasedSecurityManagement;
/*     */ import org.jboss.security.integration.ejb.EJBAuthenticationHelper;
/*     */ 
/*     */ public class Ejb3AuthenticationInterceptorv2
/*     */   implements Interceptor
/*     */ {
/*  54 */   protected Logger log = Logger.getLogger(getClass());
/*     */   private EJBContainer container;
/*     */ 
/*     */   public Ejb3AuthenticationInterceptorv2(Container container)
/*     */   {
/*  59 */     this.container = ((EJBContainer)container);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  64 */     return getClass().getName();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  70 */     SecurityHelper shelper = new SecurityHelper();
/*  71 */     MethodInvocation mi = (MethodInvocation)invocation;
/*  72 */     Method method = mi.getMethod();
/*  73 */     if ((shelper.isEJBTimeOutCallback(method)) || (shelper.containsTimeoutAnnotation(this.container, method)) || (shelper.isMDB(this.container)))
/*     */     {
/*  76 */       return invocation.invokeNext();
/*     */     }
/*  78 */     SecurityIdentity si = null;
/*  79 */     SecurityContext sc = SecurityActions.getSecurityContext();
/*  80 */     SecurityContext invSC = (SecurityContext)invocation.getMetaData("security", "context");
/*     */ 
/*  82 */     SecurityDomain domain = (SecurityDomain)this.container.resolveAnnotation(SecurityDomain.class);
/*     */ 
/*  84 */     boolean domainExists = (domain != null) && (domain.value() != null) && (domain.value().length() > 0);
/*     */     Principal p;
/*  91 */     if (domainExists)
/*     */     {
/*  93 */       p = null;
/*  94 */       Object cred = null;
/*     */ 
/*  97 */       if ((sc == null) && (invSC == null))
/*     */       {
/*  99 */         sc = SecurityActions.createSecurityContext(domain.value());
/* 100 */         SecurityActions.setSecurityContext(sc);
/*     */       }
/*     */ 
/* 103 */       if (shelper.isLocalCall(mi))
/*     */       {
/* 105 */         if (sc == null)
/* 106 */           throw new IllegalStateException("Security Context null on Local call");
/* 107 */         si = sc.getUtil().getSecurityIdentity();
/*     */       }
/*     */       else
/*     */       {
/* 111 */         if ((invSC == null) && (sc == null)) {
/* 112 */           throw new IllegalStateException("Security Context is not available");
/*     */         }
/*     */ 
/* 115 */         if (invSC != null)
/*     */         {
/* 117 */           sc = invSC;
/* 118 */           p = sc.getUtil().getUserPrincipal();
/* 119 */           cred = sc.getUtil().getCredential();
/* 120 */           String unprefixed = SecurityUtil.unprefixSecurityDomain(domain.value());
/* 121 */           sc = SecurityActions.createSecurityContext(p, cred, null, unprefixed);
/*     */ 
/* 125 */           SecurityActions.setSecurityContext(sc);
/* 126 */           sc.getUtil().setSecurityIdentity(invSC.getUtil().getSecurityIdentity());
/*     */         }
/*     */       }
/*     */ 
/* 130 */       sc = SecurityActions.getSecurityContext();
/*     */ 
/* 132 */       sc.setSecurityManagement(new JNDIBasedSecurityManagement());
/*     */ 
/* 135 */       EJBAuthenticationHelper helper = new EJBAuthenticationHelper(sc);
/* 136 */       boolean trustedCaller = helper.isTrusted();
/* 137 */       if (!trustedCaller)
/*     */       {
/* 139 */         Subject subject = new Subject();
/*     */ 
/* 141 */         if (!helper.isValid(subject, method.getName()))
/* 142 */           throw new EJBAccessException("Invalid User");
/* 143 */         helper.pushSubjectContext(subject);
/*     */       }
/*     */ 
/*     */     }
/* 157 */     else if (invSC != null)
/*     */     {
/* 159 */       SecurityActions.setSecurityContext(invSC);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 164 */       if (sc != null)
/* 165 */         SecurityActions.pushCallerRunAsIdentity(sc.getOutgoingRunAs());
/* 166 */       p = invocation.invokeNext();
/*     */     }
/*     */     finally
/*     */     {
/* 170 */       if ((shelper.isLocalCall(mi)) && (si != null))
/* 171 */         SecurityActions.getSecurityContext().getUtil().setSecurityIdentity(si);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.Ejb3AuthenticationInterceptorv2
 * JD-Core Version:    0.6.0
 */