/*     */ package org.jboss.ejb3.security;
/*     */ 
/*     */ import java.security.GeneralSecurityException;
/*     */ import java.security.Principal;
/*     */ import java.util.Map;
/*     */ import javax.ejb.EJBAccessException;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aspects.security.AuthenticationInterceptor;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.annotation.SecurityDomain;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityRolesAssociation;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ public class Ejb3AuthenticationInterceptor extends AuthenticationInterceptor
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(Ejb3AuthenticationInterceptor.class);
/*     */   private EJBContainer container;
/*     */   protected RealmMapping realmMapping;
/*     */   private AuthenticationInterceptor unauthenticatedAuthenticationInterceptor;
/*     */ 
/*     */   public Ejb3AuthenticationInterceptor(AuthenticationManager manager, Container container)
/*     */   {
/*  68 */     super(manager);
/*  69 */     this.container = ((EJBContainer)container);
/*  70 */     this.realmMapping = ((RealmMapping)manager);
/*     */ 
/*  72 */     this.unauthenticatedAuthenticationInterceptor = new AuthenticationInterceptor(null, manager)
/*     */     {
/*     */       protected void authenticate(Invocation invocation)
/*     */         throws Exception
/*     */       {
/*  77 */         super.authenticate(invocation);
/*     */ 
/*  80 */         if (this.val$manager != null)
/*     */         {
/*  82 */           Principal principal = (Principal)invocation.getMetaData("security", "principal");
/*  83 */           Subject subject = new Subject();
/*  84 */           String securityDomain = this.val$manager.getSecurityDomain();
/*  85 */           SecurityContext sc = SecurityActions.createSecurityContext(principal, null, subject, securityDomain);
/*  86 */           SecurityContextAssociation.setSecurityContext(sc);
/*     */         }
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   protected void handleGeneralSecurityException(GeneralSecurityException gse) {
/*  94 */     log.debug("Authentication failure", gse);
/*  95 */     throw new EJBAccessException("Authentication failure");
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/* 100 */     SecurityDomain domain = (SecurityDomain)this.container.resolveAnnotation(SecurityDomain.class);
/*     */ 
/* 102 */     if ((domain != null) && (domain.unauthenticatedPrincipal() != null) && (domain.unauthenticatedPrincipal().length() != 0))
/*     */     {
/* 104 */       Principal principal = (Principal)invocation.getMetaData("security", "principal");
/* 105 */       if (principal == null) {
/* 106 */         principal = SecurityAssociation.getPrincipal();
/*     */       }
/* 108 */       if (principal == null)
/*     */       {
/* 111 */         principal = new TrustedPrincipal(domain.unauthenticatedPrincipal());
/*     */ 
/* 114 */         invocation.getMetaData().addMetaData("security", "principal", principal);
/*     */       }
/*     */ 
/* 118 */       if ((principal != null) && ((principal instanceof TrustedPrincipal)))
/*     */       {
/* 121 */         return this.unauthenticatedAuthenticationInterceptor.invoke(invocation);
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 127 */       if (this.container.getAssemblyDescriptor() != null)
/*     */       {
/* 129 */         securityRoles = null;
/*     */ 
/* 131 */         SecurityRolesAssociation.setSecurityRoles(securityRoles);
/*     */       }
/* 133 */       securityRoles = super.invoke(invocation);
/*     */     }
/*     */     finally
/*     */     {
/*     */       Map securityRoles;
/* 137 */       SecurityRolesAssociation.setSecurityRoles(null);
/*     */     }
/*     */   }
/*     */ 
/*     */   class TrustedPrincipal extends SimplePrincipal
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */ 
/*     */     public TrustedPrincipal(String name) {
/* 147 */       super();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.Ejb3AuthenticationInterceptor
 * JD-Core Version:    0.6.0
 */