/*    */ package org.jboss.ejb3.remoting;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.jboss.aop.Dispatcher;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.InvocationResponse;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class IsLocalProxyFactoryInterceptor
/*    */   implements Interceptor, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -1264055696758370812L;
/* 46 */   public static final IsLocalProxyFactoryInterceptor singleton = new IsLocalProxyFactoryInterceptor();
/*    */ 
/* 48 */   private static final Logger log = Logger.getLogger(IsLocalProxyFactoryInterceptor.class);
/*    */ 
/* 50 */   private static final long stamp = System.currentTimeMillis();
/* 51 */   private long marshalledStamp = stamp;
/*    */ 
/*    */   public String getName()
/*    */   {
/* 55 */     return getClass().getName();
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 60 */     if (isLocal())
/*    */     {
/* 62 */       Object oid = invocation.getMetaData("DISPATCHER", "OID");
/* 63 */       if (Dispatcher.singleton.isRegistered(oid))
/*    */       {
/* 65 */         InvocationResponse response = Dispatcher.singleton.invoke(invocation);
/* 66 */         invocation.setResponseContextInfo(response.getContextInfo());
/* 67 */         return response.getResponse();
/*    */       }
/*    */     }
/* 70 */     return invocation.invokeNext();
/*    */   }
/*    */ 
/*    */   private boolean isLocal()
/*    */   {
/* 75 */     return stamp == this.marshalledStamp;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.remoting.IsLocalProxyFactoryInterceptor
 * JD-Core Version:    0.6.0
 */