/*     */ package org.jboss.ejb3.remoting;
/*     */ 
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.Ejb3Registry;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClusteredIsLocalInterceptor extends IsLocalInterceptor
/*     */ {
/*     */   private static final long serialVersionUID = 5765933584762500725L;
/*  44 */   private static final Logger log = Logger.getLogger(ClusteredIsLocalInterceptor.class);
/*     */   public static final String PARTITION_NAME = "PARTITION_NAME";
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  50 */     Container localContainer = findLocalContainer(invocation);
/*  51 */     if (localContainer != null)
/*     */     {
/*  53 */       return invokeLocal(invocation, localContainer);
/*     */     }
/*  55 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   private Container findLocalContainer(Invocation invocation)
/*     */   {
/*  60 */     String guid = (String)invocation.getMetaData("IS_LOCAL", "GUID");
/*  61 */     String partitionName = (String)invocation.getMetaData("PARTITION_NAME", "PARTITION_NAME");
/*     */ 
/*  63 */     Container container = null;
/*     */     try
/*     */     {
/*  66 */       container = Ejb3Registry.findContainer(guid);
/*  67 */       if (container == null)
/*     */       {
/*  69 */         String oid = (String)invocation.getMetaData("DISPATCHER", "OID");
/*  70 */         container = Ejb3Registry.getClusterContainer(Ejb3Registry.clusterUid(oid, partitionName));
/*     */       }
/*     */     }
/*     */     catch (IllegalStateException ignored)
/*     */     {
/*  75 */       if (log.isTraceEnabled()) {
/*  76 */         log.trace("Cannot find local container for " + guid);
/*     */       }
/*     */     }
/*  79 */     if (container != null)
/*     */     {
/*  81 */       if (partitionName != null)
/*     */       {
/*  83 */         if (!partitionName.equals(((EJBContainer)container).getPartitionName()))
/*     */         {
/*  85 */           if (log.isTraceEnabled())
/*     */           {
/*  87 */             log.trace("Partition (" + ((EJBContainer)container).getPartitionName() + ") for local container " + guid + " does not match invocation (" + partitionName + ")");
/*     */           }
/*     */ 
/*  91 */           container = null;
/*     */         }
/*  93 */         else if (log.isTraceEnabled())
/*     */         {
/*  95 */           log.trace("Partition (" + ((EJBContainer)container).getPartitionName() + ") for local container " + guid + " matches invocation (" + partitionName + ")");
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 102 */         log.warn("No PARTITION_NAME metadata associated with invocation");
/* 103 */         container = null;
/*     */       }
/*     */     }
/*     */ 
/* 107 */     return container;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.remoting.ClusteredIsLocalInterceptor
 * JD-Core Version:    0.6.0
 */