/*    */ package org.jboss.ejb3.remoting;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.lang.reflect.InvocationHandler;
/*    */ import java.lang.reflect.Method;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.ejb3.Container;
/*    */ import org.jboss.ejb3.Ejb3Registry;
/*    */ 
/*    */ public abstract class BaseRemoteProxy
/*    */   implements Serializable, InvocationHandler, RemoteProxy
/*    */ {
/*    */   private static final long serialVersionUID = 1126421850898582900L;
/*    */   protected String containerId;
/*    */   protected String containerGuid;
/*    */   protected Interceptor[] interceptors;
/*    */   protected SimpleMetaData metadata;
/*    */ 
/*    */   protected BaseRemoteProxy(Container container, Interceptor[] interceptors)
/*    */   {
/* 49 */     this.containerId = container.getObjectName().getCanonicalName();
/* 50 */     this.containerGuid = Ejb3Registry.guid(container);
/* 51 */     this.interceptors = interceptors;
/*    */   }
/*    */ 
/*    */   protected BaseRemoteProxy(String containerId, String containerGuid, Interceptor[] interceptors)
/*    */   {
/* 56 */     this.containerId = containerId;
/* 57 */     this.containerGuid = containerGuid;
/* 58 */     this.interceptors = interceptors;
/*    */   }
/*    */ 
/*    */   protected BaseRemoteProxy()
/*    */   {
/*    */   }
/*    */ 
/*    */   public SimpleMetaData getMetaData()
/*    */   {
/* 67 */     synchronized (this)
/*    */     {
/* 69 */       if (this.metadata == null) this.metadata = new SimpleMetaData();
/*    */     }
/* 71 */     return this.metadata;
/*    */   }
/*    */ 
/*    */   public abstract Object invoke(Object paramObject, Method paramMethod, Object[] paramArrayOfObject)
/*    */     throws Throwable;
/*    */ 
/*    */   public abstract String toString();
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.remoting.BaseRemoteProxy
 * JD-Core Version:    0.6.0
 */