/*     */ package org.jboss.ejb3.proxy.handle;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.rmi.RemoteException;
/*     */ import java.rmi.ServerException;
/*     */ import java.util.Hashtable;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.HomeHandle;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.naming.NamingContextFactory;
/*     */ 
/*     */ public class HomeHandleImpl
/*     */   implements HomeHandle
/*     */ {
/*     */   static final long serialVersionUID = 208629381571948124L;
/*  56 */   private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("jndiName", String.class), new ObjectStreamField("jndiEnv", Hashtable.class) };
/*     */   private String jndiName;
/*     */   private Hashtable jndiEnv;
/*     */ 
/*     */   public HomeHandleImpl(String jndiName)
/*     */   {
/*  82 */     this.jndiName = jndiName;
/*  83 */     this.jndiEnv = ((Hashtable)NamingContextFactory.lastInitialContextEnv.get());
/*     */   }
/*     */ 
/*     */   public EJBHome getEJBHome()
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 102 */       InitialContext ic = InitialContextFactory.getInitialContext(this.jndiEnv);
/*     */ 
/* 104 */       EJBHome home = (EJBHome)ic.lookup(this.jndiName);
/* 105 */       return home;
/*     */     }
/*     */     catch (NamingException e) {
/*     */     }
/* 109 */     throw new ServerException("Could not get EJBHome", e);
/*     */   }
/*     */ 
/*     */   public String getJNDIName()
/*     */   {
/* 118 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 124 */     ObjectInputStream.GetField getField = ois.readFields();
/* 125 */     this.jndiName = ((String)getField.get("jndiName", null));
/* 126 */     this.jndiEnv = ((Hashtable)getField.get("jndiEnv", null));
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 132 */     ObjectOutputStream.PutField putField = oos.putFields();
/* 133 */     putField.put("jndiName", this.jndiName);
/* 134 */     putField.put("jndiEnv", this.jndiEnv);
/* 135 */     oos.writeFields();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.proxy.handle.HomeHandleImpl
 * JD-Core Version:    0.6.0
 */