/*    */ package org.jboss.ejb3.protocol.jarjar;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.net.JarURLConnection;
/*    */ import java.net.URL;
/*    */ import java.net.URLConnection;
/*    */ import java.util.jar.JarEntry;
/*    */ import java.util.jar.JarFile;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class JarJarURLConnection extends URLConnection
/*    */ {
/* 42 */   private static final Logger log = Logger.getLogger(JarJarURLConnection.class);
/*    */   private URL delegate;
/*    */   private JarFile jarFile;
/*    */   private JarEntry rootEntry;
/*    */ 
/*    */   protected JarJarURLConnection(URL url)
/*    */   {
/* 50 */     super(url);
/*    */   }
/*    */ 
/*    */   public void connect()
/*    */     throws IOException
/*    */   {
/* 56 */     if (this.connected) return;
/*    */ 
/* 58 */     this.delegate = new URL(getURL().toString().substring(7));
/* 59 */     log.debug("delegate " + this.delegate);
/* 60 */     JarURLConnection conn = (JarURLConnection)this.delegate.openConnection();
/* 61 */     this.jarFile = conn.getJarFile();
/* 62 */     log.trace("jar file " + this.jarFile);
/* 63 */     this.rootEntry = conn.getJarEntry();
/* 64 */     log.trace("root entry " + this.rootEntry);
/*    */ 
/* 66 */     this.connected = true;
/*    */   }
/*    */ 
/*    */   public InputStream getInputStream()
/*    */     throws IOException
/*    */   {
/* 72 */     if (!this.connected) connect();
/*    */ 
/* 74 */     String spec = this.delegate.toString();
/*    */     URL jarFileURL;
/*    */     URL jarFileURL;
/* 76 */     if (this.rootEntry != null)
/* 77 */       jarFileURL = new URL(spec.substring(0, spec.length() - this.rootEntry.getName().length()));
/*    */     else
/* 79 */       jarFileURL = this.delegate;
/* 80 */     log.debug("jar file url " + jarFileURL);
/*    */ 
/* 82 */     return new JarJarInputStream(this.jarFile, this.rootEntry);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.protocol.jarjar.JarJarURLConnection
 * JD-Core Version:    0.6.0
 */