/*     */ package org.jboss.ejb3.pool;
/*     */ 
/*     */ import org.jboss.ejb3.BeanContext;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.InfinitePool;
/*     */ import org.jboss.injection.Injector;
/*     */ import org.jboss.lang.ref.WeakThreadLocal;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ThreadlocalPool
/*     */   implements Pool
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(ThreadlocalPool.class);
/*     */ 
/*  42 */   protected Pool pool = new InfinitePool();
/*  43 */   protected WeakThreadLocal<BeanContext> currentBeanContext = new WeakThreadLocal();
/*  44 */   private int inUse = 0;
/*  45 */   private int maxSize = 30;
/*     */ 
/*     */   protected BeanContext create()
/*     */   {
/*  53 */     return this.pool.get();
/*     */   }
/*     */ 
/*     */   protected BeanContext create(Class[] initTypes, Object[] initValues)
/*     */   {
/*  58 */     return this.pool.get(initTypes, initValues);
/*     */   }
/*     */ 
/*     */   public void discard(BeanContext obj)
/*     */   {
/*  63 */     this.pool.discard(obj);
/*  64 */     this.inUse -= 1;
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  69 */     log.trace("destroying pool");
/*     */ 
/*  71 */     this.pool.destroy();
/*     */ 
/*  74 */     this.currentBeanContext.remove();
/*     */ 
/*  76 */     this.inUse = 0;
/*     */   }
/*     */ 
/*     */   public BeanContext get()
/*     */   {
/*  81 */     BeanContext ctx = null;
/*     */ 
/*  83 */     synchronized (this.pool)
/*     */     {
/*  85 */       ctx = (BeanContext)this.currentBeanContext.get();
/*  86 */       if (ctx != null)
/*     */       {
/*  88 */         this.currentBeanContext.set(null);
/*  89 */         this.inUse += 1;
/*  90 */         return ctx;
/*     */       }
/*     */ 
/*  93 */       ctx = create();
/*  94 */       this.inUse += 1;
/*     */     }
/*     */ 
/*  97 */     return ctx;
/*     */   }
/*     */ 
/*     */   public BeanContext get(Class[] initTypes, Object[] initValues)
/*     */   {
/* 102 */     BeanContext ctx = null;
/* 103 */     synchronized (this.pool)
/*     */     {
/* 105 */       ctx = (BeanContext)this.currentBeanContext.get();
/* 106 */       if (ctx != null)
/*     */       {
/* 108 */         this.currentBeanContext.set(null);
/* 109 */         this.inUse += 1;
/* 110 */         return ctx;
/*     */       }
/*     */ 
/* 113 */       ctx = create(initTypes, initValues);
/* 114 */       this.inUse += 1;
/*     */     }
/*     */ 
/* 117 */     return ctx;
/*     */   }
/*     */ 
/*     */   public void initialize(Container container, int maxSize, long timeout)
/*     */   {
/* 122 */     this.pool.initialize(container, maxSize, timeout);
/* 123 */     this.maxSize = maxSize;
/*     */   }
/*     */ 
/*     */   public void release(BeanContext ctx)
/*     */   {
/* 128 */     synchronized (this.pool)
/*     */     {
/* 130 */       if (this.currentBeanContext.get() != null)
/*     */       {
/* 132 */         remove(ctx);
/*     */       }
/*     */       else
/*     */       {
/* 136 */         this.currentBeanContext.set(ctx);
/*     */       }
/*     */ 
/* 139 */       this.inUse -= 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(BeanContext ctx)
/*     */   {
/* 145 */     this.pool.remove(ctx);
/*     */   }
/*     */ 
/*     */   public int getCurrentSize()
/*     */   {
/*     */     int size;
/* 151 */     synchronized (this.pool)
/*     */     {
/* 153 */       size = this.pool.getCreateCount() - this.pool.getRemoveCount();
/*     */     }
/* 155 */     return size;
/*     */   }
/*     */ 
/*     */   public int getAvailableCount()
/*     */   {
/* 160 */     return this.maxSize - this.inUse;
/*     */   }
/*     */ 
/*     */   public int getCreateCount()
/*     */   {
/* 165 */     return this.pool.getCreateCount();
/*     */   }
/*     */ 
/*     */   public int getMaxSize()
/*     */   {
/* 170 */     return this.maxSize;
/*     */   }
/*     */ 
/*     */   public int getRemoveCount()
/*     */   {
/* 175 */     return this.pool.getRemoveCount();
/*     */   }
/*     */ 
/*     */   public void setInjectors(Injector[] injectors)
/*     */   {
/* 180 */     this.pool.setInjectors(injectors);
/*     */   }
/*     */ 
/*     */   public void setMaxSize(int maxSize)
/*     */   {
/* 185 */     this.maxSize = maxSize;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.pool.ThreadlocalPool
 * JD-Core Version:    0.6.0
 */