/*    */ package org.jboss.ejb3.pool;
/*    */ 
/*    */ import java.util.Map;
/*    */ 
/*    */ public class PoolFactoryRegistry
/*    */ {
/*    */   private Map<String, Class<? extends PoolFactory>> factories;
/*    */ 
/*    */   public Map<String, Class<? extends PoolFactory>> getFactories()
/*    */   {
/* 41 */     return this.factories;
/*    */   }
/*    */ 
/*    */   public void setFactories(Map<String, Class<? extends PoolFactory>> factories)
/*    */   {
/* 46 */     this.factories = factories;
/*    */   }
/*    */ 
/*    */   public PoolFactory getPoolFactory(String name)
/*    */     throws PoolFactoryNotRegisteredException
/*    */   {
/* 60 */     Class poolFactory = (Class)this.factories.get(name);
/*    */ 
/* 63 */     if (poolFactory == null)
/*    */     {
/* 65 */       throw new PoolFactoryNotRegisteredException("Pool Factory with name " + name + " is not registered.");
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 71 */       return (PoolFactory)poolFactory.newInstance();
/*    */     }
/*    */     catch (InstantiationException e)
/*    */     {
/* 75 */       throw new RuntimeException("Error in instanciating pool factory " + poolFactory.getName(), e);
/*    */     }
/*    */     catch (IllegalAccessException e) {
/*    */     }
/* 79 */     throw new RuntimeException(e);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.pool.PoolFactoryRegistry
 * JD-Core Version:    0.6.0
 */