/*     */ package org.jboss.ejb3.metamodel;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metamodel.descriptor.DDObjectFactory;
/*     */ import org.jboss.metamodel.descriptor.EjbRef;
/*     */ import org.jboss.metamodel.descriptor.MessageDestinationRef;
/*     */ import org.jboss.metamodel.descriptor.ResourceEnvRef;
/*     */ import org.jboss.metamodel.descriptor.ResourceRef;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class JBossClientDDObjectFactory extends DDObjectFactory
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(JBossClientDDObjectFactory.class);
/*     */   private ApplicationClientDD dd;
/*     */ 
/*     */   public static ApplicationClientDD parse(URL ddResource, ApplicationClientDD dd)
/*     */     throws JBossXBException, IOException
/*     */   {
/*  58 */     if (dd == null) {
/*  59 */       dd = new ApplicationClientDD();
/*     */     }
/*  61 */     if (ddResource == null) {
/*  62 */       return dd;
/*     */     }
/*  64 */     log.debug("found jboss-client.xml " + ddResource);
/*     */ 
/*  66 */     JBossClientDDObjectFactory factory = new JBossClientDDObjectFactory(dd);
/*  67 */     UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
/*  68 */     Unmarshaller unmarshaller = unmarshallerFactory.newUnmarshaller();
/*  69 */     unmarshaller.setEntityResolver(new JBossEntityResolver());
/*  70 */     unmarshaller.setNamespaceAware(true);
/*  71 */     unmarshaller.setSchemaValidation(true);
/*  72 */     unmarshaller.setValidation(true);
/*     */ 
/*  74 */     dd = (ApplicationClientDD)unmarshaller.unmarshal(ddResource.openStream(), factory, null);
/*     */ 
/*  76 */     return dd;
/*     */   }
/*     */ 
/*     */   public JBossClientDDObjectFactory(ApplicationClientDD dd)
/*     */   {
/*  82 */     if (dd == null) {
/*  83 */       throw new NullPointerException("dd is null");
/*     */     }
/*  85 */     this.dd = dd;
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD parent, EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*  90 */     this.dd.updateEjbRef(ref);
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD parent, MessageDestinationRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*  95 */     this.dd.updateMessageDestinationRef(ref);
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD parent, ServiceRefMetaData sref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 100 */     String refName = sref.getServiceRefName();
/* 101 */     if (refName == null) {
/* 102 */       throw new IllegalStateException("Invalid service-ref-name: " + refName);
/*     */     }
/* 104 */     ServiceRefMetaData targetRef = parent.getServiceRef(refName);
/* 105 */     if (targetRef == null)
/*     */     {
/* 107 */       log.debug("Cannot find <service-ref> with name: " + refName);
/* 108 */       parent.addServiceRef(sref);
/*     */     }
/*     */     else
/*     */     {
/* 112 */       targetRef.merge(sref);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD dd, ResourceEnvRef envRef, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 118 */     dd.updateResourceEnvRef(envRef);
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationClientDD parent, ResourceRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 123 */     this.dd.updateResourceRef(ref);
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext navigator, String uri, String name)
/*     */   {
/* 128 */     return root;
/*     */   }
/*     */ 
/*     */   public Object newChild(ApplicationClientDD dd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 133 */     Object child = null;
/*     */ 
/* 135 */     child = newEnvRefGroupChild(localName);
/* 136 */     if (child != null) {
/* 137 */       return child;
/*     */     }
/*     */ 
/* 140 */     if (localName.equals("webservices"))
/*     */     {
/* 143 */       System.out.println("** Skip <webservices> element in JBossClientDDObjectfactory **");
/*     */     }
/*     */ 
/* 146 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 151 */     return this.dd;
/*     */   }
/*     */ 
/*     */   public void setValue(ApplicationClientDD dd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 156 */     if (localName.equals("jndi-name"))
/* 157 */       dd.setJndiName(value);
/* 158 */     else if (localName.equals("depends"))
/* 159 */       dd.addDependency(value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.metamodel.JBossClientDDObjectFactory
 * JD-Core Version:    0.6.0
 */