/*     */ package org.jboss.ejb3.metamodel;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metamodel.descriptor.EjbLocalRef;
/*     */ import org.jboss.metamodel.descriptor.EjbRef;
/*     */ import org.jboss.metamodel.descriptor.InjectionTarget;
/*     */ import org.jboss.metamodel.descriptor.JndiRef;
/*     */ import org.jboss.metamodel.descriptor.MessageDestinationRef;
/*     */ import org.jboss.metamodel.descriptor.ResourceEnvRef;
/*     */ import org.jboss.metamodel.descriptor.ResourceRef;
/*     */ import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
/*     */ 
/*     */ public class EnterpriseBeans
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(EnterpriseBeans.class);
/*     */ 
/*  53 */   private HashMap<String, EnterpriseBean> enterpriseBeans = new HashMap();
/*     */   private EnterpriseBean currentEjb;
/*     */ 
/*     */   public void setPoolConfig(PoolConfig config)
/*     */   {
/*  59 */     this.currentEjb.setPoolConfig(config);
/*     */   }
/*     */ 
/*     */   public void setDefaultActivationConfig(ActivationConfig config)
/*     */   {
/*  64 */     ((MessageDrivenBean)this.currentEjb).setDefaultActivationConfig(config);
/*     */   }
/*     */ 
/*     */   public void setCacheConfig(CacheConfig config)
/*     */   {
/*  69 */     ((SessionEnterpriseBean)this.currentEjb).setCacheConfig(config);
/*     */   }
/*     */ 
/*     */   public void setClustered(String clustered)
/*     */   {
/*  74 */     ((SessionEnterpriseBean)this.currentEjb).setClustered(clustered);
/*     */   }
/*     */ 
/*     */   public void setConcurrent(String concurrent)
/*     */   {
/*  79 */     ((SessionEnterpriseBean)this.currentEjb).setConcurrent(concurrent);
/*     */   }
/*     */ 
/*     */   public void addJndiRef(JndiRef ref)
/*     */   {
/*  84 */     this.currentEjb.addJndiRef(ref);
/*     */   }
/*     */ 
/*     */   public void addXmlAnnotation(XmlAnnotation xmlAnnotation)
/*     */   {
/*  89 */     this.currentEjb.addXmlAnnotation(xmlAnnotation);
/*     */   }
/*     */ 
/*     */   public void addRemoteBinding(RemoteBinding binding)
/*     */   {
/*  94 */     this.currentEjb.addRemoteBinding(binding);
/*     */   }
/*     */ 
/*     */   public void addIgnoreDependency(InjectionTarget ignore)
/*     */   {
/*  99 */     this.currentEjb.addIgnoreDependency(ignore);
/*     */   }
/*     */ 
/*     */   public void addResourceRef(ResourceRef ref)
/*     */   {
/* 104 */     this.currentEjb.mergeResourceRef(ref);
/*     */   }
/*     */ 
/*     */   public void addResourceEnvRef(ResourceEnvRef ref)
/*     */   {
/* 109 */     this.currentEjb.mergeResourceEnvRef(ref);
/*     */   }
/*     */ 
/*     */   public void addMessageDestinationRef(MessageDestinationRef ref)
/*     */   {
/* 114 */     this.currentEjb.mergeMessageDestinationRef(ref);
/*     */   }
/*     */ 
/*     */   public void addServiceRef(ServiceRefMetaData ref)
/*     */   {
/* 119 */     this.currentEjb.addServiceRef(ref);
/*     */   }
/*     */ 
/*     */   public ServiceRefMetaData getServiceRef(String name)
/*     */   {
/* 124 */     return this.currentEjb.getServiceRef(name);
/*     */   }
/*     */ 
/*     */   public void addPortComponent(Ejb3PortComponent portComp)
/*     */   {
/* 129 */     this.currentEjb.setPortComponent(portComp);
/*     */   }
/*     */ 
/*     */   public void setMethodAttributes(MethodAttributes attributes)
/*     */   {
/* 134 */     this.currentEjb.setMethodAttributes(attributes);
/*     */   }
/*     */ 
/*     */   public void setCurrentEjbName(String currentEjbName, Class ejbClass)
/*     */   {
/* 139 */     this.currentEjb = createEjbByEjbName(currentEjbName, ejbClass);
/*     */   }
/*     */ 
/*     */   public void addDependency(String depends)
/*     */   {
/* 144 */     this.currentEjb.addDependency(depends);
/*     */   }
/*     */ 
/*     */   public void updateEjbRef(EjbRef ref)
/*     */   {
/* 149 */     this.currentEjb.updateEjbRef(ref);
/*     */   }
/*     */ 
/*     */   public void updateEjbLocalRef(EjbLocalRef ref)
/*     */   {
/* 154 */     this.currentEjb.updateEjbLocalRef(ref);
/*     */   }
/*     */ 
/*     */   public void updateResourceRef(ResourceRef ref)
/*     */   {
/* 159 */     this.currentEjb.updateResourceRef(ref);
/*     */   }
/*     */ 
/*     */   public void updateResourceEnvRef(ResourceEnvRef ref)
/*     */   {
/* 164 */     this.currentEjb.updateResourceEnvRef(ref);
/*     */   }
/*     */ 
/*     */   public void updateMessageDestinationRef(MessageDestinationRef ref)
/*     */   {
/* 169 */     this.currentEjb.updateMessageDestinationRef(ref);
/*     */   }
/*     */ 
/*     */   public void setResourceAdapterName(String name)
/*     */   {
/* 174 */     ((MessageDrivenBean)this.currentEjb).setResourceAdaptorName(name);
/*     */   }
/*     */ 
/*     */   public void setDestinationJndiName(String name)
/*     */   {
/* 179 */     ((MessageDrivenBean)this.currentEjb).setDestinationJndiName(name);
/*     */   }
/*     */ 
/*     */   public void setMdbUser(String name)
/*     */   {
/* 184 */     ((MessageDrivenBean)this.currentEjb).setMdbUser(name);
/*     */   }
/*     */ 
/*     */   public void setMdbPassword(String name)
/*     */   {
/* 189 */     ((MessageDrivenBean)this.currentEjb).setMdbPassword(name);
/*     */   }
/*     */ 
/*     */   public void setMdbSubscriptionId(String id)
/*     */   {
/* 194 */     ((MessageDrivenBean)this.currentEjb).setMdbSubscriptionId(id);
/*     */   }
/*     */ 
/*     */   public void setAopDomainName(String aopDomainName)
/*     */   {
/* 199 */     this.currentEjb.setAopDomainName(aopDomainName);
/*     */   }
/*     */ 
/*     */   public void setRunAsPrincipal(String principal)
/*     */   {
/* 204 */     this.currentEjb.setRunAsPrincipal(principal);
/*     */   }
/*     */ 
/*     */   public void setClusterConfig(ClusterConfig config)
/*     */   {
/* 209 */     ((SessionEnterpriseBean)this.currentEjb).setClusterConfig(config);
/*     */   }
/*     */ 
/*     */   public void setCallByValue(boolean callByValue)
/*     */   {
/* 214 */     this.currentEjb.setCallByValue(callByValue);
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 219 */     this.currentEjb.setJndiName(jndiName);
/*     */   }
/*     */ 
/*     */   public void setHomeJndiName(String homeJndiName)
/*     */   {
/* 224 */     this.currentEjb.setHomeJndiName(homeJndiName);
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String securityDomain)
/*     */   {
/* 229 */     this.currentEjb.setSecurityDomain(securityDomain);
/*     */   }
/*     */ 
/*     */   public void setLocalJndiName(String jndiName)
/*     */   {
/* 234 */     this.currentEjb.setLocalJndiName(jndiName);
/*     */   }
/*     */ 
/*     */   public void setLocalHomeJndiName(String homeJndiName)
/*     */   {
/* 239 */     this.currentEjb.setLocalHomeJndiName(homeJndiName);
/*     */   }
/*     */ 
/*     */   public EnterpriseBean createEjbByEjbName(String ejbName, Class ejbClass)
/*     */   {
/* 244 */     EnterpriseBean ejb = (EnterpriseBean)this.enterpriseBeans.get(ejbName);
/* 245 */     if (ejb != null) {
/* 246 */       return ejb;
/*     */     }
/*     */     try
/*     */     {
/* 250 */       ejb = (EnterpriseBean)ejbClass.newInstance();
/* 251 */       ejb.setEjbName(ejbName);
/* 252 */       this.enterpriseBeans.put(ejbName, ejb);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 258 */     return ejb;
/*     */   }
/*     */ 
/*     */   public EnterpriseBean findEjbByEjbName(String ejbName)
/*     */   {
/* 263 */     return (EnterpriseBean)this.enterpriseBeans.get(ejbName);
/*     */   }
/*     */ 
/*     */   public List<EnterpriseBean> findEjbsByClass(String className)
/*     */   {
/* 268 */     ArrayList result = new ArrayList();
/*     */ 
/* 270 */     Iterator ejbs = this.enterpriseBeans.values().iterator();
/* 271 */     while (ejbs.hasNext())
/*     */     {
/* 273 */       EnterpriseBean ejb = (EnterpriseBean)ejbs.next();
/* 274 */       String ejbClassName = ejb.getEjbClass();
/* 275 */       if ((ejbClassName != null) && (ejbClassName.equals(className)))
/* 276 */         result.add(ejb);
/*     */     }
/* 278 */     return result;
/*     */   }
/*     */ 
/*     */   public EnterpriseBean findEjbByRemote(String remote)
/*     */   {
/* 283 */     Iterator ejbs = this.enterpriseBeans.values().iterator();
/* 284 */     while (ejbs.hasNext())
/*     */     {
/* 286 */       EnterpriseBean ejb = (EnterpriseBean)ejbs.next();
/* 287 */       if ((ejb.getRemote() != null) && (ejb.getRemote().equals(remote)))
/* 288 */         return ejb;
/*     */     }
/* 290 */     return null;
/*     */   }
/*     */ 
/*     */   public EnterpriseBean findEjbByLocal(String local)
/*     */   {
/* 295 */     Iterator ejbs = this.enterpriseBeans.values().iterator();
/* 296 */     while (ejbs.hasNext())
/*     */     {
/* 298 */       EnterpriseBean ejb = (EnterpriseBean)ejbs.next();
/* 299 */       if ((ejb.getLocal() != null) && (ejb.getLocal().equals(local)))
/* 300 */         return ejb;
/*     */     }
/* 302 */     return null;
/*     */   }
/*     */ 
/*     */   public Collection<EnterpriseBean> getEnterpriseBeans()
/*     */   {
/* 307 */     return this.enterpriseBeans.values();
/*     */   }
/*     */ 
/*     */   public void addEnterpriseBean(EnterpriseBean ejb)
/*     */   {
/* 317 */     this.enterpriseBeans.put(ejb.getEjbName(), ejb);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 322 */     StringBuffer sb = new StringBuffer(100);
/* 323 */     sb.append("[");
/* 324 */     sb.append("enterpriseBeans=").append(this.enterpriseBeans);
/* 325 */     sb.append("]");
/* 326 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 331 */     if (this == o)
/* 332 */       return true;
/* 333 */     if (!(o instanceof EnterpriseBeans)) {
/* 334 */       return false;
/*     */     }
/* 336 */     EnterpriseBeans ejbs = (EnterpriseBeans)o;
/*     */ 
/* 339 */     return this.enterpriseBeans != null ? this.enterpriseBeans.equals(ejbs.enterpriseBeans) : ejbs.enterpriseBeans == null;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 347 */     int result = this.enterpriseBeans != null ? this.enterpriseBeans.hashCode() : 0;
/*     */ 
/* 349 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.metamodel.EnterpriseBeans
 * JD-Core Version:    0.6.0
 */