/*      */ package org.jboss.ejb3.metamodel;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.net.URL;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.metamodel.descriptor.DDObjectFactory;
/*      */ import org.jboss.metamodel.descriptor.EjbLocalRef;
/*      */ import org.jboss.metamodel.descriptor.EjbRef;
/*      */ import org.jboss.metamodel.descriptor.EnvEntry;
/*      */ import org.jboss.metamodel.descriptor.MessageDestinationRef;
/*      */ import org.jboss.metamodel.descriptor.NameValuePair;
/*      */ import org.jboss.metamodel.descriptor.PersistenceContextRef;
/*      */ import org.jboss.metamodel.descriptor.PersistenceUnitRef;
/*      */ import org.jboss.metamodel.descriptor.ResourceEnvRef;
/*      */ import org.jboss.metamodel.descriptor.ResourceRef;
/*      */ import org.jboss.metamodel.descriptor.RunAs;
/*      */ import org.jboss.metamodel.descriptor.SecurityRole;
/*      */ import org.jboss.metamodel.descriptor.SecurityRoleRef;
/*      */ import org.jboss.util.StringPropertyReplacer;
/*      */ import org.jboss.util.xml.JBossEntityResolver;
/*      */ import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
/*      */ import org.jboss.xb.binding.JBossXBException;
/*      */ import org.jboss.xb.binding.ObjectModelFactory;
/*      */ import org.jboss.xb.binding.Unmarshaller;
/*      */ import org.jboss.xb.binding.UnmarshallerFactory;
/*      */ import org.jboss.xb.binding.UnmarshallingContext;
/*      */ import org.xml.sax.Attributes;
/*      */ 
/*      */ public class EjbJarDDObjectFactory extends DDObjectFactory
/*      */ {
/*   62 */   private static final Logger log = Logger.getLogger(EjbJarDDObjectFactory.class);
/*      */ 
/*      */   public static EjbJarDD parse(URL ddResource) throws JBossXBException, IOException
/*      */   {
/*   66 */     ObjectModelFactory factory = null;
/*   67 */     Unmarshaller unmarshaller = null;
/*   68 */     EjbJarDD dd = null;
/*      */ 
/*   70 */     if (ddResource != null)
/*      */     {
/*   72 */       log.debug("found ejb-jar.xml " + ddResource);
/*      */ 
/*   74 */       factory = new EjbJarDDObjectFactory();
/*   75 */       UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
/*   76 */       unmarshaller = unmarshallerFactory.newUnmarshaller();
/*   77 */       unmarshaller.setEntityResolver(new JBossEntityResolver());
/*   78 */       unmarshaller.setNamespaceAware(true);
/*   79 */       unmarshaller.setSchemaValidation(true);
/*   80 */       unmarshaller.setValidation(true);
/*      */ 
/*   82 */       dd = (EjbJarDD)unmarshaller.unmarshal(ddResource.openStream(), factory, null);
/*      */     }
/*      */ 
/*   85 */     return dd;
/*      */   }
/*      */ 
/*      */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*      */     EjbJarDD dd;
/*   92 */     if (root == null)
/*      */     {
/*      */       EjbJarDD dd;
/*   94 */       root = dd = new EjbJarDD();
/*      */     }
/*      */     else
/*      */     {
/*   98 */       dd = (EjbJarDD)root;
/*      */     }
/*      */ 
/*  101 */     if (attrs.getLength() > 0)
/*      */     {
/*  103 */       for (int i = 0; i < attrs.getLength(); i++)
/*      */       {
/*  105 */         if (!attrs.getLocalName(i).equals("version"))
/*      */           continue;
/*  107 */         dd.setVersion(attrs.getValue(i));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  112 */     return root;
/*      */   }
/*      */ 
/*      */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*      */   {
/*  117 */     return root;
/*      */   }
/*      */ 
/*      */   public Object newChild(EjbJarDD dd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  127 */     Object child = null;
/*      */ 
/*  129 */     if (localName.equals("enterprise-beans"))
/*      */     {
/*  131 */       child = new EnterpriseBeans();
/*      */     }
/*  133 */     if (localName.equals("interceptors"))
/*      */     {
/*  135 */       child = new Interceptors();
/*      */     }
/*  137 */     else if (localName.equals("relationships"))
/*      */     {
/*  139 */       child = new Relationships();
/*      */     }
/*  141 */     else if (localName.equals("assembly-descriptor"))
/*      */     {
/*  143 */       child = new AssemblyDescriptor();
/*      */     }
/*      */ 
/*  146 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(EnterpriseBeans ejbs, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  154 */     Object child = null;
/*      */ 
/*  156 */     if (localName.equals("session"))
/*      */     {
/*  158 */       child = new SessionEnterpriseBean();
/*      */     }
/*  160 */     else if (localName.equals("entity"))
/*      */     {
/*  162 */       child = new EntityEnterpriseBean();
/*      */     }
/*  164 */     else if (localName.equals("message-driven"))
/*      */     {
/*  166 */       child = new MessageDrivenBean();
/*      */     }
/*      */ 
/*  169 */     return child;
/*      */   }
/*      */ 
/*      */   private Object newEjbChild(EnterpriseBean parent, String localName)
/*      */   {
/*  177 */     Object child = null;
/*      */ 
/*  179 */     if ((child = super.newEnvRefGroupChild(localName)) != null)
/*  180 */       return child;
/*  181 */     return child;
/*      */   }
/*      */ 
/*      */   private Object newEjbHasInterceptorsChild(EnterpriseBean parent, String localName)
/*      */   {
/*  186 */     Object child = null;
/*      */ 
/*  188 */     if (localName.equals("around-invoke"))
/*      */     {
/*  190 */       child = new Method();
/*      */     }
/*  192 */     else if (localName.equals("post-construct"))
/*      */     {
/*  194 */       child = new Method();
/*      */     }
/*  196 */     else if (localName.equals("pre-destroy"))
/*      */     {
/*  198 */       child = new Method();
/*      */     }
/*  200 */     else if (localName.equals("post-activate"))
/*      */     {
/*  202 */       child = new Method();
/*      */     }
/*  204 */     else if (localName.equals("pre-passivate"))
/*      */     {
/*  206 */       child = new Method();
/*      */     }
/*  208 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(MessageDrivenBean parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  213 */     Object child = newEjbChild(parent, localName);
/*  214 */     if (child != null) {
/*  215 */       return child;
/*      */     }
/*  217 */     child = newEjbHasInterceptorsChild(parent, localName);
/*  218 */     if (child != null) {
/*  219 */       return child;
/*      */     }
/*  221 */     if (localName.equals("message-driven-destination"))
/*      */     {
/*  223 */       child = new MessageDrivenDestination();
/*      */     }
/*  225 */     else if (localName.equals("activation-config"))
/*      */     {
/*  227 */       child = new ActivationConfig();
/*      */     }
/*      */ 
/*  230 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(ActivationConfig parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  235 */     Object child = null;
/*      */ 
/*  237 */     if (localName.equals("activation-config-property"))
/*      */     {
/*  239 */       child = new NameValuePair();
/*      */     }
/*      */ 
/*  242 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(SessionEnterpriseBean parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  250 */     Object child = newEjbChild(parent, localName);
/*  251 */     if (child != null) {
/*  252 */       return child;
/*      */     }
/*  254 */     child = newEjbHasInterceptorsChild(parent, localName);
/*  255 */     if (child != null) {
/*  256 */       return child;
/*      */     }
/*  258 */     if (localName.equals("security-role-ref"))
/*      */     {
/*  260 */       child = new SecurityRoleRef();
/*      */     }
/*  262 */     else if (localName.equals("security-identity"))
/*      */     {
/*  264 */       child = new SecurityIdentity();
/*      */     }
/*  266 */     else if (localName.equals("remove-method"))
/*      */     {
/*  268 */       RemoveMethod method = new RemoveMethod();
/*  269 */       parent.addRemoveMethod(method);
/*  270 */       child = method;
/*      */     }
/*  272 */     else if (localName.equals("init-method"))
/*      */     {
/*  274 */       InitMethod method = new InitMethod();
/*  275 */       parent.addInitMethod(method);
/*  276 */       child = method;
/*      */     }
/*      */ 
/*  279 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(EntityEnterpriseBean parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  287 */     Object child = null;
/*      */ 
/*  289 */     child = newEjbChild(parent, localName);
/*  290 */     if (child == null)
/*      */     {
/*  292 */       if (localName.equals("security-role-ref"))
/*      */       {
/*  294 */         child = new SecurityRoleRef();
/*      */       }
/*  296 */       else if (localName.equals("cmp-field"))
/*      */       {
/*  298 */         child = new CmpField();
/*      */       }
/*  300 */       else if (localName.equals("query"))
/*      */       {
/*  302 */         child = new Query();
/*      */       }
/*      */     }
/*      */ 
/*  306 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(SecurityIdentity parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  314 */     Object child = null;
/*      */ 
/*  316 */     if (localName.equals("run-as"))
/*      */     {
/*  318 */       child = new RunAs();
/*      */     }
/*  320 */     else if (localName.equals("use-caller-identity"))
/*      */     {
/*  322 */       parent.setUseCallerIdentity(true);
/*      */     }
/*      */ 
/*  325 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(RemoveMethod parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  333 */     Object child = null;
/*      */ 
/*  335 */     if (localName.equals("bean-method"))
/*      */     {
/*  337 */       parent.setBeanMethod(new Method());
/*  338 */       child = parent.getBeanMethod();
/*      */     }
/*      */ 
/*  341 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(InitMethod parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  349 */     Object child = null;
/*      */ 
/*  351 */     if (localName.equals("bean-method"))
/*      */     {
/*  353 */       parent.setBeanMethod(new Method());
/*  354 */       child = parent.getBeanMethod();
/*      */     }
/*      */ 
/*  357 */     return child;
/*      */   }
/*      */ 
/*      */   public void setValue(RemoveMethod dd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/*  365 */     if (localName.equals("retain-if-exception"))
/*      */     {
/*  367 */       dd.setRetainIfException(Boolean.parseBoolean(getValue(localName, value)));
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object newChild(Relationships relationships, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  376 */     Object child = null;
/*      */ 
/*  378 */     if (localName.equals("ejb-relation"))
/*      */     {
/*  380 */       child = new EjbRelation();
/*      */     }
/*      */ 
/*  383 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(EjbRelation relation, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  391 */     Object child = null;
/*      */ 
/*  393 */     if (localName.equals("ejb-relationship-role"))
/*      */     {
/*  395 */       child = new EjbRelationshipRole();
/*      */     }
/*      */ 
/*  398 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(EjbRelationshipRole parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  406 */     Object child = null;
/*      */ 
/*  408 */     if (localName.equals("cascade-delete"))
/*      */     {
/*  410 */       parent.setCascadeDelete(true);
/*      */     }
/*  412 */     else if (localName.equals("relationship-role-source"))
/*      */     {
/*  414 */       child = new RelationshipRoleSource();
/*      */     }
/*  416 */     else if (localName.equals("cmr-field"))
/*      */     {
/*  418 */       child = new CmrField();
/*      */     }
/*      */ 
/*  421 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(Interceptors interceptors, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  426 */     Object child = null;
/*      */ 
/*  428 */     if (localName.equals("interceptor"))
/*      */     {
/*  430 */       return new Interceptor();
/*      */     }
/*      */ 
/*  433 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(Interceptor interceptor, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  438 */     Object child = null;
/*      */ 
/*  440 */     if ((child = newEnvRefGroupChild(localName)) != null) {
/*  441 */       return child;
/*      */     }
/*  443 */     if (localName.equals("around-invoke"))
/*      */     {
/*  445 */       return new Method();
/*      */     }
/*  447 */     if (localName.equals("post-construct"))
/*      */     {
/*  449 */       return new Method();
/*      */     }
/*  451 */     if (localName.equals("pre-destroy"))
/*      */     {
/*  453 */       return new Method();
/*      */     }
/*  455 */     if (localName.equals("post-activate"))
/*      */     {
/*  457 */       return new Method();
/*      */     }
/*  459 */     if (localName.equals("pre-passivate"))
/*      */     {
/*  461 */       return new Method();
/*      */     }
/*      */ 
/*  464 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(AssemblyDescriptor relationships, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  472 */     Object child = null;
/*      */ 
/*  474 */     if (localName.equals("security-role"))
/*      */     {
/*  476 */       child = new SecurityRole();
/*      */     }
/*  478 */     else if (localName.equals("method-permission"))
/*      */     {
/*  480 */       child = new MethodPermission();
/*      */     }
/*  482 */     if (localName.equals("container-transaction"))
/*      */     {
/*  484 */       child = new ContainerTransaction();
/*      */     }
/*  486 */     else if (localName.equals("inject"))
/*      */     {
/*  488 */       child = new Inject();
/*      */     }
/*  490 */     else if (localName.equals("exclude-list"))
/*      */     {
/*  492 */       child = new ExcludeList();
/*      */     }
/*  494 */     else if (localName.equals("application-exception"))
/*      */     {
/*  496 */       child = new ApplicationException();
/*      */     }
/*  498 */     else if (localName.equals("interceptor-binding"))
/*      */     {
/*  500 */       child = new InterceptorBinding();
/*      */     }
/*  502 */     else if (localName.equals("message-destination"))
/*      */     {
/*  504 */       child = new MessageDestination();
/*      */     }
/*      */ 
/*  507 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(Inject inject, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  515 */     Object child = null;
/*      */ 
/*  517 */     if (localName.equals("method"))
/*      */     {
/*  519 */       child = new Method();
/*      */     }
/*      */ 
/*  522 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(MethodPermission permission, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  530 */     Object child = null;
/*      */ 
/*  532 */     if (localName.equals("method"))
/*      */     {
/*  534 */       child = new Method();
/*      */     }
/*  536 */     else if (localName.equals("unchecked"))
/*      */     {
/*  538 */       permission.setUnchecked(true);
/*      */     }
/*      */ 
/*  541 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(ExcludeList list, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  549 */     Object child = null;
/*      */ 
/*  551 */     if (localName.equals("method"))
/*      */     {
/*  553 */       child = new Method();
/*      */     }
/*      */ 
/*  556 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(InitList list, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  564 */     Object child = null;
/*      */ 
/*  566 */     if (localName.equals("method"))
/*      */     {
/*  568 */       child = new Method();
/*      */     }
/*      */ 
/*  571 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(ContainerTransaction transaction, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  579 */     Object child = null;
/*      */ 
/*  581 */     if (localName.equals("method"))
/*      */     {
/*  583 */       child = new Method();
/*      */     }
/*      */ 
/*  586 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(Method method, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  591 */     Object child = null;
/*      */ 
/*  593 */     if (localName.equals("method-params"))
/*      */     {
/*  595 */       method.setHasParameters();
/*      */     }
/*      */ 
/*  598 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(InterceptorBinding binding, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  603 */     Object child = null;
/*      */ 
/*  605 */     if (localName.equals("interceptor-order"))
/*      */     {
/*  607 */       child = new InterceptorOrder();
/*      */     }
/*  609 */     else if (localName.equals("exclude-default-interceptors"))
/*      */     {
/*  611 */       child = new ExcludeDefaultInterceptors();
/*      */     }
/*  613 */     else if (localName.equals("exclude-class-interceptors"))
/*      */     {
/*  615 */       child = new ExcludeClassInterceptors();
/*      */     }
/*  617 */     else if (localName.equals("method-params"))
/*      */     {
/*  619 */       binding.setHasParameters();
/*      */     }
/*      */ 
/*  622 */     return child;
/*      */   }
/*      */ 
/*      */   public void addChild(MessageDrivenBean parent, ActivationConfig config, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  630 */     parent.setActivationConfig(config);
/*      */   }
/*      */ 
/*      */   public void addChild(MessageDrivenBean parent, EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  638 */     parent.addEjbRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(MessageDrivenBean parent, EjbLocalRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  646 */     parent.addEjbLocalRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(MessageDrivenBean parent, EnvEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  654 */     parent.addEnvEntry(entry);
/*      */   }
/*      */ 
/*      */   public void addChild(MessageDrivenBean parent, ResourceEnvRef envRef, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  662 */     parent.addResourceEnvRef(envRef);
/*      */   }
/*      */ 
/*      */   public void addChild(MessageDrivenBean parent, ResourceRef envRef, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  670 */     parent.addResourceRef(envRef);
/*      */   }
/*      */ 
/*      */   public void addChild(MessageDrivenBean parent, ServiceRefMetaData envRef, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  675 */     parent.addServiceRef(envRef);
/*      */   }
/*      */ 
/*      */   public void addChild(MessageDrivenBean parent, MessageDestinationRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  680 */     parent.addMessageDestinationRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(ActivationConfig parent, NameValuePair property, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  685 */     parent.addActivationConfigProperty(property);
/*      */   }
/*      */ 
/*      */   public void addChild(EjbJarDD parent, EnterpriseBeans ejbs, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  690 */     parent.setEnterpriseBeans(ejbs);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, EnterpriseBean ejb, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  698 */     parent.addEnterpriseBean(ejb);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, SecurityRoleRef roleRef, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  703 */     parent.addSecurityRoleRef(roleRef);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, SecurityIdentity si, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  708 */     parent.setSecurityIdentity(si);
/*      */   }
/*      */ 
/*      */   public void addChild(SecurityIdentity parent, RunAs runAs, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  713 */     parent.setRunAs(runAs);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, EjbLocalRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  718 */     parent.addEjbLocalRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  723 */     parent.addEjbRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, PersistenceContextRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  728 */     parent.addPersistenceContextRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, PersistenceUnitRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  736 */     parent.addPersistenceUnitRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, MessageDestinationRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  744 */     parent.addMessageDestinationRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, EnvEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  752 */     parent.addEnvEntry(entry);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, ResourceEnvRef envRef, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  760 */     parent.addResourceEnvRef(envRef);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, ResourceRef envRef, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  768 */     parent.addResourceRef(envRef);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, ServiceRefMetaData envRef, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  776 */     parent.addServiceRef(envRef);
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  784 */     if (localName.equals("around-invoke"))
/*      */     {
/*  786 */       parent.setAroundInvoke(method);
/*      */     }
/*  788 */     else if (localName.equals("post-construct"))
/*      */     {
/*  790 */       parent.setPostConstruct(method);
/*      */     }
/*  792 */     else if (localName.equals("pre-destroy"))
/*      */     {
/*  794 */       parent.setPreDestroy(method);
/*      */     }
/*  796 */     else if (localName.equals("post-activate"))
/*      */     {
/*  798 */       parent.setPostActivate(method);
/*      */     }
/*  800 */     else if (localName.equals("pre-passivate"))
/*      */     {
/*  802 */       parent.setPrePassivate(method);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addChild(EntityEnterpriseBean parent, CmpField field, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  811 */     parent.addCmpField(field);
/*      */   }
/*      */ 
/*      */   public void addChild(EntityEnterpriseBean parent, Query query, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  819 */     parent.addQuery(query);
/*      */   }
/*      */ 
/*      */   public void addChild(EjbJarDD parent, Relationships relationships, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  827 */     parent.setRelationships(relationships);
/*      */   }
/*      */ 
/*      */   public void addChild(Relationships parent, EjbRelation relation, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  835 */     parent.addEjbRelation(relation);
/*      */   }
/*      */ 
/*      */   public void addChild(EjbRelation parent, EjbRelationshipRole role, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  843 */     parent.addEjbRelationshipRole(role);
/*      */   }
/*      */ 
/*      */   public void addChild(EjbRelationshipRole parent, RelationshipRoleSource source, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  851 */     parent.setRelationshipRoleSource(source);
/*      */   }
/*      */ 
/*      */   public void addChild(EjbRelationshipRole parent, CmrField field, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  859 */     parent.setCmrField(field);
/*      */   }
/*      */ 
/*      */   public void addChild(EjbJarDD parent, AssemblyDescriptor descriptor, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  867 */     parent.setAssemblyDescriptor(descriptor);
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, SecurityRole role, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  875 */     parent.addSecurityRole(role);
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, MethodPermission permission, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  883 */     parent.addMethodPermission(permission);
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, MessageDestination destination, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  888 */     parent.addMessageDestination(destination);
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, ExcludeList list, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  896 */     parent.setExcludeList(list);
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, ApplicationException exception, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  904 */     parent.addApplicationException(exception);
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, InitList list, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  912 */     parent.setInitList(list);
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, Inject inject, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  920 */     parent.addInject(inject);
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, InterceptorBinding binding, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  928 */     parent.addInterceptorBinding(binding);
/*      */   }
/*      */ 
/*      */   public void addChild(ExcludeList parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  936 */     parent.addMethod(method);
/*      */   }
/*      */ 
/*      */   public void addChild(InitList parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  944 */     parent.addMethod(method);
/*      */   }
/*      */ 
/*      */   public void addChild(MethodPermission parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  952 */     parent.addMethod(method);
/*      */   }
/*      */ 
/*      */   public void addChild(Inject parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  960 */     parent.addMethod(method);
/*      */   }
/*      */ 
/*      */   public void addChild(EjbJarDD parent, Interceptors interceptors, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  965 */     parent.setInterceptors(interceptors);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptors parent, Interceptor interceptor, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  970 */     parent.addInterceptor(interceptor);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptor parent, EjbLocalRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  978 */     parent.addEjbLocalRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptor parent, EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  986 */     parent.addEjbRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptor parent, PersistenceContextRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  994 */     parent.addPersistenceContextRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptor parent, PersistenceUnitRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1002 */     parent.addPersistenceUnitRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptor parent, MessageDestinationRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1010 */     parent.addMessageDestinationRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptor parent, EnvEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1018 */     parent.addEnvEntry(entry);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptor parent, ResourceEnvRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1026 */     parent.addResourceEnvRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptor parent, ResourceRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1034 */     parent.addResourceRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptor parent, ServiceRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1042 */     parent.addServiceRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Interceptor parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1047 */     if (localName.equals("around-invoke"))
/*      */     {
/* 1049 */       parent.setAroundInvoke(method);
/*      */     }
/* 1051 */     else if (localName.equals("post-construct"))
/*      */     {
/* 1053 */       parent.setPostConstruct(method);
/*      */     }
/* 1055 */     else if (localName.equals("pre-destroy"))
/*      */     {
/* 1057 */       parent.setPreDestroy(method);
/*      */     }
/* 1059 */     else if (localName.equals("post-activate"))
/*      */     {
/* 1061 */       parent.setPostActivate(method);
/*      */     }
/* 1063 */     else if (localName.equals("pre-passivate"))
/*      */     {
/* 1065 */       parent.setPrePassivate(method);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addChild(InterceptorBinding parent, InterceptorOrder order, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1074 */     parent.setOrderedInterceptorClasses(order);
/*      */   }
/*      */ 
/*      */   public void addChild(InterceptorBinding parent, ExcludeDefaultInterceptors exclude, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1082 */     parent.setExcludeDefaultInterceptors(true);
/*      */   }
/*      */ 
/*      */   public void addChild(InterceptorBinding parent, ExcludeClassInterceptors exclude, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1090 */     parent.setExcludeClassInterceptors(true);
/*      */   }
/*      */ 
/*      */   public void addChild(ContainerTransaction parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1098 */     parent.setMethod(method);
/*      */   }
/*      */ 
/*      */   public void addChild(MessageDrivenBean parent, MessageDrivenDestination destination, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1106 */     parent.setMessageDrivenDestination(destination);
/*      */   }
/*      */ 
/*      */   public void addChild(MessageDrivenBean parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1114 */     if (localName.equals("around-invoke"))
/*      */     {
/* 1116 */       parent.setAroundInvoke(method);
/*      */     }
/* 1118 */     else if (localName.equals("post-construct"))
/*      */     {
/* 1120 */       parent.setPostConstruct(method);
/*      */     }
/* 1122 */     else if (localName.equals("pre-destroy"))
/*      */     {
/* 1124 */       parent.setPreDestroy(method);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, ContainerTransaction transaction, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/* 1133 */     parent.addContainerTransaction(transaction);
/*      */   }
/*      */ 
/*      */   public void setValue(EjbJarDD dd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1141 */     if (localName.equals("display-name"))
/*      */     {
/* 1143 */       dd.setDisplayName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(NameValuePair property, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1152 */     if (localName.equals("activation-config-property-name"))
/*      */     {
/* 1154 */       property.setName(getValue(localName, value));
/*      */     }
/* 1156 */     else if (localName.equals("activation-config-property-value"))
/*      */     {
/* 1158 */       property.setValue(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean isEjbParentName(EnterpriseBean ejb, String localName, String value)
/*      */   {
/* 1167 */     if (localName.equals("ejb-name"))
/*      */     {
/* 1169 */       ejb.setEjbName(getValue(localName, value));
/* 1170 */       return true;
/*      */     }
/* 1172 */     if (localName.equals("home"))
/*      */     {
/* 1174 */       ejb.setHome(getValue(localName, value));
/* 1175 */       return true;
/*      */     }
/* 1177 */     if ((localName.equals("remote")) || (localName.equals("business-remote")))
/*      */     {
/* 1179 */       ejb.setRemote(getValue(localName, value));
/* 1180 */       return true;
/*      */     }
/* 1182 */     if (localName.equals("local-home"))
/*      */     {
/* 1184 */       ejb.setLocalHome(getValue(localName, value));
/* 1185 */       return true;
/*      */     }
/* 1187 */     if ((localName.equals("local")) || (localName.equals("business-local")))
/*      */     {
/* 1189 */       ejb.setLocal(getValue(localName, value));
/* 1190 */       return true;
/*      */     }
/* 1192 */     if (localName.equals("ejb-class"))
/*      */     {
/* 1194 */       ejb.setEjbClass(getValue(localName, value));
/* 1195 */       return true;
/*      */     }
/*      */ 
/* 1198 */     return false;
/*      */   }
/*      */ 
/*      */   public void setValue(MessageDestination destination, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1203 */     if (localName.equals("message-destination-name"))
/*      */     {
/* 1205 */       destination.setMessageDestinationName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(MessageDrivenBean ejb, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1214 */     if (!isEjbParentName(ejb, localName, value))
/*      */     {
/* 1216 */       if (localName.equals("acknowledge-mode"))
/*      */       {
/* 1218 */         ejb.setAcknowledgeMode(getValue(localName, value));
/*      */       }
/* 1220 */       else if (localName.equals("transaction-type"))
/*      */       {
/* 1222 */         ejb.setTransactionType(getValue(localName, value));
/*      */       }
/* 1224 */       else if (localName.equals("messaging-type"))
/*      */       {
/* 1226 */         ejb.setMessagingType(getValue(localName, value));
/*      */       }
/* 1228 */       else if (localName.equals("message-destination-link"))
/*      */       {
/* 1230 */         ejb.setMessageDestinationLink(getValue(localName, value));
/*      */       }
/* 1232 */       else if (localName.equals("message-destination-type"))
/*      */       {
/* 1234 */         MessageDrivenDestination destination = ejb.getMessageDrivenDestination();
/* 1235 */         if (destination == null)
/*      */         {
/* 1237 */           destination = new MessageDrivenDestination();
/* 1238 */           ejb.setMessageDrivenDestination(destination);
/*      */         }
/*      */ 
/* 1241 */         destination.setDestinationType(getValue(localName, value));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(MessageDrivenDestination destination, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1251 */     if (localName.equals("destination-type"))
/*      */     {
/* 1253 */       destination.setDestinationType(getValue(localName, value));
/*      */     }
/* 1255 */     else if (localName.equals("subscription-durability"))
/*      */     {
/* 1257 */       destination.setSubscriptionDurability(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(SessionEnterpriseBean ejb, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1266 */     if (!isEjbParentName(ejb, localName, value))
/*      */     {
/* 1268 */       if (localName.equals("session-type"))
/*      */       {
/* 1270 */         ejb.setSessionType(getValue(localName, value));
/*      */       }
/* 1272 */       else if (localName.equals("transaction-type"))
/*      */       {
/* 1274 */         ejb.setTransactionManagementType(getValue(localName, value));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(ApplicationException exception, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1284 */     if (localName.equals("exception-class"))
/*      */     {
/* 1286 */       exception.setExceptionClass(getValue(localName, value));
/*      */     }
/* 1288 */     else if (localName.equals("rollback"))
/*      */     {
/* 1290 */       exception.setRollback(Boolean.valueOf(getValue(localName, value)).booleanValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(EntityEnterpriseBean ejb, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1299 */     if (!isEjbParentName(ejb, localName, value))
/*      */     {
/* 1301 */       if (localName.equals("persistence-type"))
/*      */       {
/* 1303 */         ejb.setPersistenceType(getValue(localName, value));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(SecurityRoleRef parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1313 */     if (localName.equals("role-name"))
/*      */     {
/* 1315 */       parent.setRoleName(value);
/*      */     }
/* 1317 */     else if (localName.equals("role-link"))
/*      */     {
/* 1319 */       parent.setRoleLink(value);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(SecurityIdentity si, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1328 */     if (localName.equals("use-caller-identity"))
/*      */     {
/* 1330 */       si.setUseCallerIdentity(true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(Interceptor interceptor, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1336 */     if (localName.equals("interceptor-class"))
/*      */     {
/* 1338 */       interceptor.setInterceptorClass(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(EjbRelation relation, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1347 */     if (localName.equals("ejb-relation-name"))
/*      */     {
/* 1349 */       relation.setEjbRelationName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(EjbRelationshipRole role, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1358 */     if (localName.equals("ejb-relationship-role-name"))
/*      */     {
/* 1360 */       role.setEjbRelationshipRoleName(getValue(localName, value));
/*      */     }
/* 1362 */     else if (localName.equals("multiplicity"))
/*      */     {
/* 1364 */       role.setMultiplicity(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(RelationshipRoleSource source, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1373 */     if (localName.equals("ejb-name"))
/*      */     {
/* 1375 */       source.setEjbName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(CmrField field, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1384 */     if (localName.equals("cmr-field-name"))
/*      */     {
/* 1386 */       field.setCmrFieldName(getValue(localName, value));
/*      */     }
/* 1388 */     else if (localName.equals("cmr-field-type"))
/*      */     {
/* 1390 */       field.setCmrFieldType(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(SecurityRole role, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1399 */     if (localName.equals("role-name"))
/*      */     {
/* 1401 */       role.setRoleName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(MethodPermission permission, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1410 */     if (localName.equals("role-name"))
/*      */     {
/* 1412 */       permission.addRoleName(getValue(localName, value));
/*      */     }
/* 1414 */     else if (localName.equals("unchecked"))
/*      */     {
/* 1416 */       permission.setUnchecked(true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(ContainerTransaction transaction, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1425 */     if (localName.equals("trans-attribute"))
/*      */     {
/* 1427 */       transaction.setTransAttribute(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(Method method, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1436 */     if (localName.equals("ejb-name"))
/*      */     {
/* 1438 */       method.setEjbName(getValue(localName, value));
/*      */     }
/* 1440 */     else if (localName.equals("method-name"))
/*      */     {
/* 1442 */       method.setMethodName(getValue(localName, value));
/*      */     }
/* 1444 */     else if (localName.equals("method-param"))
/*      */     {
/* 1446 */       method.addMethodParam(getValue(localName, value));
/*      */     }
/* 1448 */     else if (localName.equals("lifecycle-callback-method"))
/*      */     {
/* 1450 */       method.setMethodName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(Inject inject, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1459 */     if (localName.equals("jndi-name"))
/*      */     {
/* 1461 */       inject.setJndiName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(InterceptorBinding binding, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1467 */     if (localName.equals("ejb-name"))
/*      */     {
/* 1469 */       binding.setEjbName(getValue(localName, value));
/*      */     }
/* 1471 */     else if (localName.equals("interceptor-class"))
/*      */     {
/* 1473 */       binding.addInterceptorClass(getValue(localName, value));
/*      */     }
/* 1475 */     else if (localName.equals("method-name"))
/*      */     {
/* 1477 */       binding.setMethodName(getValue(localName, value));
/*      */     }
/* 1479 */     else if (localName.equals("method-param"))
/*      */     {
/* 1481 */       binding.addMethodParam(getValue(localName, value));
/*      */     }
/* 1483 */     else if (localName.equals("exclude-default-interceptors"))
/*      */     {
/* 1485 */       binding.setExcludeDefaultInterceptors(true);
/*      */     }
/* 1487 */     else if (localName.equals("exclude-class-interceptors"))
/*      */     {
/* 1489 */       binding.setExcludeClassInterceptors(true);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(InterceptorOrder order, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1495 */     if (localName.equals("interceptor-class"))
/*      */     {
/* 1497 */       order.addInterceptorClass(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   protected String getValue(String name, String value)
/*      */   {
/* 1504 */     if ((value.startsWith("${")) && (value.endsWith("}")))
/*      */     {
/* 1506 */       String replacement = StringPropertyReplacer.replaceProperties(value);
/* 1507 */       if (replacement != null)
/* 1508 */         value = replacement;
/*      */     }
/* 1510 */     return value;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.metamodel.EjbJarDDObjectFactory
 * JD-Core Version:    0.6.0
 */