/*     */ package org.jboss.ejb3.metamodel;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.SecurityRoleMetaData;
/*     */ import org.jboss.metamodel.descriptor.SecurityRole;
/*     */ 
/*     */ public class AssemblyDescriptor
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(AssemblyDescriptor.class);
/*     */ 
/*  50 */   private List securityRoles = new ArrayList();
/*     */ 
/*  52 */   private Map<String, SecurityRoleMetaData> securityRoleMetaData = new HashMap();
/*     */ 
/*  54 */   private List methodPermissions = new ArrayList();
/*     */ 
/*  56 */   private List containerTransactions = new ArrayList();
/*     */ 
/*  58 */   private HashMap<String, MessageDestination> messageDestinations = new HashMap();
/*     */   private ExcludeList excludeList;
/*  62 */   private List applicationExceptions = new ArrayList();
/*     */   private InitList initList;
/*  66 */   private List injects = new ArrayList();
/*     */ 
/*  83 */   private List interceptorBindings = new ArrayList();
/*     */ 
/*     */   public Collection<MessageDestination> getMessageDestinations()
/*     */   {
/*  70 */     return this.messageDestinations.values();
/*     */   }
/*     */ 
/*     */   public void addMessageDestination(MessageDestination messageDestination)
/*     */   {
/*  75 */     this.messageDestinations.put(messageDestination.getMessageDestinationName(), messageDestination);
/*     */   }
/*     */ 
/*     */   public MessageDestination findMessageDestination(String name)
/*     */   {
/*  80 */     return (MessageDestination)this.messageDestinations.get(name);
/*     */   }
/*     */ 
/*     */   public InitList getInitList()
/*     */   {
/*  87 */     return this.initList;
/*     */   }
/*     */ 
/*     */   public void setInitList(InitList initList)
/*     */   {
/*  92 */     this.initList = initList;
/*     */   }
/*     */ 
/*     */   public ExcludeList getExcludeList()
/*     */   {
/*  97 */     return this.excludeList;
/*     */   }
/*     */ 
/*     */   public void setExcludeList(ExcludeList excludeList)
/*     */   {
/* 102 */     this.excludeList = excludeList;
/*     */   }
/*     */ 
/*     */   public List getApplicationExceptions()
/*     */   {
/* 107 */     return this.applicationExceptions;
/*     */   }
/*     */ 
/*     */   public void addApplicationException(ApplicationException applicationException)
/*     */   {
/* 112 */     this.applicationExceptions.add(applicationException);
/*     */   }
/*     */ 
/*     */   public List getSecurityRoles()
/*     */   {
/* 117 */     return this.securityRoles;
/*     */   }
/*     */ 
/*     */   public void setSecurityRoles(List securityRoles)
/*     */   {
/* 122 */     this.securityRoles = securityRoles;
/*     */   }
/*     */ 
/*     */   public void addSecurityRole(SecurityRole securityRole)
/*     */   {
/* 127 */     this.securityRoles.add(securityRole);
/*     */   }
/*     */ 
/*     */   public List<InterceptorBinding> getInterceptorBindings()
/*     */   {
/* 132 */     return this.interceptorBindings;
/*     */   }
/*     */ 
/*     */   public void addInterceptorBinding(InterceptorBinding binding)
/*     */   {
/* 137 */     this.interceptorBindings.add(binding);
/*     */   }
/*     */ 
/*     */   public List getInjects()
/*     */   {
/* 142 */     return this.injects;
/*     */   }
/*     */ 
/*     */   public void addInject(Inject inject)
/*     */   {
/* 147 */     this.injects.add(inject);
/*     */   }
/*     */ 
/*     */   public List getMethodPermissions()
/*     */   {
/* 152 */     return this.methodPermissions;
/*     */   }
/*     */ 
/*     */   public void setMethodPermissions(List methodPermissions)
/*     */   {
/* 157 */     this.methodPermissions = methodPermissions;
/*     */   }
/*     */ 
/*     */   public void addMethodPermission(MethodPermission methodPermission)
/*     */   {
/* 162 */     this.methodPermissions.add(methodPermission);
/*     */   }
/*     */ 
/*     */   public List getContainerTransactions()
/*     */   {
/* 167 */     return this.containerTransactions;
/*     */   }
/*     */ 
/*     */   public void setContainerTransactions(List containerTransactions)
/*     */   {
/* 172 */     this.containerTransactions = containerTransactions;
/*     */   }
/*     */ 
/*     */   public void addContainerTransaction(ContainerTransaction containerTransaction)
/*     */   {
/* 177 */     this.containerTransactions.add(containerTransaction);
/*     */   }
/*     */ 
/*     */   public void addSecurityRoleMetaData(SecurityRoleMetaData srm)
/*     */   {
/* 182 */     this.securityRoleMetaData.put(srm.getRoleName(), srm);
/*     */   }
/*     */ 
/*     */   public Set getSecurityRolesGivenPrincipal(String userName)
/*     */   {
/* 187 */     HashSet roleNames = new HashSet();
/* 188 */     Iterator it = this.securityRoleMetaData.values().iterator();
/* 189 */     while (it.hasNext())
/*     */     {
/* 191 */       SecurityRoleMetaData srMetaData = (SecurityRoleMetaData)it.next();
/* 192 */       if (srMetaData.getPrincipals().contains(userName))
/* 193 */         roleNames.add(srMetaData.getRoleName());
/*     */     }
/* 195 */     return roleNames;
/*     */   }
/*     */ 
/*     */   public Map getPrincipalVersusRolesMap()
/*     */   {
/* 205 */     Map principalRolesMap = null;
/*     */ 
/* 207 */     Iterator iter = this.securityRoleMetaData.keySet().iterator();
/* 208 */     while (iter.hasNext())
/*     */     {
/* 210 */       if (principalRolesMap == null)
/* 211 */         principalRolesMap = new HashMap();
/* 212 */       String rolename = (String)iter.next();
/* 213 */       SecurityRoleMetaData srm = (SecurityRoleMetaData)this.securityRoleMetaData.get(rolename);
/* 214 */       Iterator principalIter = srm.getPrincipals().iterator();
/* 215 */       while (principalIter.hasNext())
/*     */       {
/* 217 */         String pr = (String)principalIter.next();
/* 218 */         Set roleset = (Set)principalRolesMap.get(pr);
/* 219 */         if (roleset == null)
/* 220 */           roleset = new HashSet();
/* 221 */         if (!roleset.contains(rolename))
/* 222 */           roleset.add(rolename);
/* 223 */         principalRolesMap.put(pr, roleset);
/*     */       }
/*     */     }
/* 226 */     return principalRolesMap;
/*     */   }
/*     */ 
/*     */   public Map<String, SecurityRoleMetaData> getSecurityRoleMetaData()
/*     */   {
/* 231 */     return this.securityRoleMetaData;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 236 */     StringBuffer sb = new StringBuffer(100);
/* 237 */     sb.append("[");
/* 238 */     sb.append("securityRoles=").append(this.securityRoles);
/* 239 */     sb.append(", applicationExceptions=").append(this.applicationExceptions);
/* 240 */     sb.append("]");
/* 241 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.metamodel.AssemblyDescriptor
 * JD-Core Version:    0.6.0
 */